/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.info;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.syncope.common.lib.BaseBean;
import org.apache.syncope.common.lib.info.JavaImplInfo;

public class PlatformInfo
implements BaseBean {
    private static final long serialVersionUID = -7941853999417673827L;
    private String keymasterConfParamOps;
    private String keymasterServiceOps;
    private final ProvisioningInfo provisioningInfo = new ProvisioningInfo();
    private final WorkflowInfo workflowInfo = new WorkflowInfo();
    private final PersistenceInfo persistenceInfo = new PersistenceInfo();
    private boolean selfRegAllowed;
    private boolean pwdResetAllowed;
    private boolean pwdResetRequiringSecurityQuestions;
    private final Set<String> connIdLocations = new HashSet<String>();
    private String passwordGenerator;
    private final List<String> anyTypes = new ArrayList<String>();
    private final List<String> userClasses = new ArrayList<String>();
    private final List<String> anyTypeClasses = new ArrayList<String>();
    private final List<String> resources = new ArrayList<String>();
    private final Set<String> entitlements = new HashSet<String>();
    private final Set<String> implementationTypes = new HashSet<String>();
    private final Set<JavaImplInfo> javaImplInfos = new HashSet<JavaImplInfo>();

    public String getKeymasterConfParamOps() {
        return this.keymasterConfParamOps;
    }

    public String getKeymasterServiceOps() {
        return this.keymasterServiceOps;
    }

    public ProvisioningInfo getProvisioningInfo() {
        return this.provisioningInfo;
    }

    public WorkflowInfo getWorkflowInfo() {
        return this.workflowInfo;
    }

    public PersistenceInfo getPersistenceInfo() {
        return this.persistenceInfo;
    }

    public boolean isSelfRegAllowed() {
        return this.selfRegAllowed;
    }

    public boolean isPwdResetAllowed() {
        return this.pwdResetAllowed;
    }

    public boolean isPwdResetRequiringSecurityQuestions() {
        return this.pwdResetRequiringSecurityQuestions;
    }

    @JacksonXmlElementWrapper(localName="connIdLocations")
    @JacksonXmlProperty(localName="connIdLocation")
    public Set<String> getConnIdLocations() {
        return this.connIdLocations;
    }

    public String getPasswordGenerator() {
        return this.passwordGenerator;
    }

    public void setPasswordGenerator(String passwordGenerator) {
        this.passwordGenerator = passwordGenerator;
    }

    @JacksonXmlElementWrapper(localName="anyTypes")
    @JacksonXmlProperty(localName="anyType")
    public List<String> getAnyTypes() {
        return this.anyTypes;
    }

    @JacksonXmlElementWrapper(localName="userClasses")
    @JacksonXmlProperty(localName="userClass")
    public List<String> getUserClasses() {
        return this.userClasses;
    }

    @JacksonXmlElementWrapper(localName="anyTypeClasses")
    @JacksonXmlProperty(localName="anyTypeClass")
    public List<String> getAnyTypeClasses() {
        return this.anyTypeClasses;
    }

    @JacksonXmlElementWrapper(localName="resources")
    @JacksonXmlProperty(localName="resource")
    public List<String> getResources() {
        return this.resources;
    }

    @JacksonXmlElementWrapper(localName="entitlements")
    @JacksonXmlProperty(localName="entitlement")
    public Set<String> getEntitlements() {
        return this.entitlements;
    }

    @JacksonXmlElementWrapper(localName="implementationTypes")
    @JacksonXmlProperty(localName="implementationType")
    public Set<String> getImplementationTypes() {
        return this.implementationTypes;
    }

    @JsonIgnore
    public Optional<JavaImplInfo> getJavaImplInfo(String type) {
        return this.javaImplInfos.stream().filter(javaImplInfo -> javaImplInfo.getType().equals(type)).findFirst();
    }

    @JacksonXmlElementWrapper(localName="javaImplInfos")
    @JacksonXmlProperty(localName="javaImplInfo")
    public Set<JavaImplInfo> getJavaImplInfos() {
        return this.javaImplInfos;
    }

    public void setKeymasterConfParamOps(String keymasterConfParamOps) {
        this.keymasterConfParamOps = keymasterConfParamOps;
    }

    public void setKeymasterServiceOps(String keymasterServiceOps) {
        this.keymasterServiceOps = keymasterServiceOps;
    }

    public void setSelfRegAllowed(boolean selfRegAllowed) {
        this.selfRegAllowed = selfRegAllowed;
    }

    public void setPwdResetAllowed(boolean pwdResetAllowed) {
        this.pwdResetAllowed = pwdResetAllowed;
    }

    public void setPwdResetRequiringSecurityQuestions(boolean pwdResetRequiringSecurityQuestions) {
        this.pwdResetRequiringSecurityQuestions = pwdResetRequiringSecurityQuestions;
    }

    public static class PersistenceInfo
    implements BaseBean {
        private static final long serialVersionUID = 2902980556801069487L;
        private String entityFactory;
        private String plainSchemaDAO;
        private String plainAttrDAO;
        private String plainAttrValueDAO;
        private String anySearchDAO;
        private String userDAO;
        private String groupDAO;
        private String anyObjectDAO;

        public String getEntityFactory() {
            return this.entityFactory;
        }

        public void setEntityFactory(String entityFactory) {
            this.entityFactory = entityFactory;
        }

        public String getPlainSchemaDAO() {
            return this.plainSchemaDAO;
        }

        public void setPlainSchemaDAO(String plainSchemaDAO) {
            this.plainSchemaDAO = plainSchemaDAO;
        }

        public String getPlainAttrDAO() {
            return this.plainAttrDAO;
        }

        public void setPlainAttrDAO(String plainAttrDAO) {
            this.plainAttrDAO = plainAttrDAO;
        }

        public String getPlainAttrValueDAO() {
            return this.plainAttrValueDAO;
        }

        public void setPlainAttrValueDAO(String plainAttrValueDAO) {
            this.plainAttrValueDAO = plainAttrValueDAO;
        }

        public String getAnySearchDAO() {
            return this.anySearchDAO;
        }

        public void setAnySearchDAO(String anySearchDAO) {
            this.anySearchDAO = anySearchDAO;
        }

        public String getUserDAO() {
            return this.userDAO;
        }

        public void setUserDAO(String userDAO) {
            this.userDAO = userDAO;
        }

        public String getGroupDAO() {
            return this.groupDAO;
        }

        public void setGroupDAO(String groupDAO) {
            this.groupDAO = groupDAO;
        }

        public String getAnyObjectDAO() {
            return this.anyObjectDAO;
        }

        public void setAnyObjectDAO(String anyObjectDAO) {
            this.anyObjectDAO = anyObjectDAO;
        }
    }

    public static class WorkflowInfo
    implements BaseBean {
        private static final long serialVersionUID = 6736937721099195324L;
        private String anyObjectWorkflowAdapter;
        private String userWorkflowAdapter;
        private String groupWorkflowAdapter;

        public String getAnyObjectWorkflowAdapter() {
            return this.anyObjectWorkflowAdapter;
        }

        public void setAnyObjectWorkflowAdapter(String anyObjectWorkflowAdapter) {
            this.anyObjectWorkflowAdapter = anyObjectWorkflowAdapter;
        }

        public String getUserWorkflowAdapter() {
            return this.userWorkflowAdapter;
        }

        public void setUserWorkflowAdapter(String userWorkflowAdapter) {
            this.userWorkflowAdapter = userWorkflowAdapter;
        }

        public String getGroupWorkflowAdapter() {
            return this.groupWorkflowAdapter;
        }

        public void setGroupWorkflowAdapter(String groupWorkflowAdapter) {
            this.groupWorkflowAdapter = groupWorkflowAdapter;
        }
    }

    public static class ProvisioningInfo
    implements BaseBean {
        private static final long serialVersionUID = 533340357732839568L;
        private String propagationTaskExecutor;
        private String virAttrCache;
        private String anyObjectProvisioningManager;
        private String userProvisioningManager;
        private String groupProvisioningManager;
        private String notificationManager;
        private String auditManager;

        public String getPropagationTaskExecutor() {
            return this.propagationTaskExecutor;
        }

        public void setPropagationTaskExecutor(String propagationTaskExecutor) {
            this.propagationTaskExecutor = propagationTaskExecutor;
        }

        public String getVirAttrCache() {
            return this.virAttrCache;
        }

        public void setVirAttrCache(String virAttrCache) {
            this.virAttrCache = virAttrCache;
        }

        public String getAnyObjectProvisioningManager() {
            return this.anyObjectProvisioningManager;
        }

        public void setAnyObjectProvisioningManager(String anyObjectProvisioningManager) {
            this.anyObjectProvisioningManager = anyObjectProvisioningManager;
        }

        public String getUserProvisioningManager() {
            return this.userProvisioningManager;
        }

        public void setUserProvisioningManager(String userProvisioningManager) {
            this.userProvisioningManager = userProvisioningManager;
        }

        public String getGroupProvisioningManager() {
            return this.groupProvisioningManager;
        }

        public void setGroupProvisioningManager(String groupProvisioningManager) {
            this.groupProvisioningManager = groupProvisioningManager;
        }

        public String getNotificationManager() {
            return this.notificationManager;
        }

        public void setNotificationManager(String notificationManager) {
            this.notificationManager = notificationManager;
        }

        public String getAuditManager() {
            return this.auditManager;
        }

        public void setAuditManager(String auditManager) {
            this.auditManager = auditManager;
        }
    }
}

