/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.refreshtoken;

import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.services.RegisteredServiceOAuthRefreshTokenExpirationPolicy;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.UniqueTicketIdGenerator;
import org.apereo.cas.ticket.refreshtoken.OAuth20DefaultRefreshToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshTokenExpirationPolicy;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshTokenFactory;
import org.apereo.cas.util.DefaultUniqueTicketIdGenerator;

public class OAuth20DefaultRefreshTokenFactory
implements OAuth20RefreshTokenFactory {
    protected final UniqueTicketIdGenerator refreshTokenIdGenerator;
    protected final ExpirationPolicyBuilder<OAuth20RefreshToken> expirationPolicy;
    protected final ServicesManager servicesManager;

    public OAuth20DefaultRefreshTokenFactory(ExpirationPolicyBuilder<OAuth20RefreshToken> expirationPolicy, ServicesManager servicesManager) {
        this((UniqueTicketIdGenerator)new DefaultUniqueTicketIdGenerator(), expirationPolicy, servicesManager);
    }

    public OAuth20RefreshToken create(Service service, Authentication authentication, TicketGrantingTicket ticketGrantingTicket, Collection<String> scopes, String clientId, String accessToken, Map<String, Map<String, Object>> requestClaims, OAuth20ResponseTypes responseType, OAuth20GrantTypes grantType) {
        String codeId = this.refreshTokenIdGenerator.getNewTicketId("RT");
        ExpirationPolicy expirationPolicyToUse = this.determineExpirationPolicyForService(clientId);
        OAuth20DefaultRefreshToken rt = new OAuth20DefaultRefreshToken(codeId, service, authentication, expirationPolicyToUse, ticketGrantingTicket, scopes, clientId, accessToken, requestClaims, responseType, grantType);
        if (ticketGrantingTicket != null) {
            ticketGrantingTicket.getDescendantTickets().add(rt.getId());
        }
        return rt;
    }

    private ExpirationPolicy determineExpirationPolicyForService(String clientId) {
        RegisteredServiceOAuthRefreshTokenExpirationPolicy policy;
        String timeToKill;
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, clientId);
        if (registeredService != null && registeredService.getRefreshTokenExpirationPolicy() != null && StringUtils.isNotBlank((CharSequence)(timeToKill = (policy = registeredService.getRefreshTokenExpirationPolicy()).getTimeToKill()))) {
            return new OAuth20RefreshTokenExpirationPolicy(Beans.newDuration((String)timeToKill).getSeconds());
        }
        return this.expirationPolicy.buildTicketExpirationPolicy();
    }

    public Class<? extends Ticket> getTicketType() {
        return OAuth20RefreshToken.class;
    }

    @Generated
    public OAuth20DefaultRefreshTokenFactory(UniqueTicketIdGenerator refreshTokenIdGenerator, ExpirationPolicyBuilder<OAuth20RefreshToken> expirationPolicy, ServicesManager servicesManager) {
        this.refreshTokenIdGenerator = refreshTokenIdGenerator;
        this.expirationPolicy = expirationPolicy;
        this.servicesManager = servicesManager;
    }
}

