/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.callback;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.OAuth20AuthorizationRequest;
import org.apereo.cas.support.oauth.web.response.accesstoken.OAuth20TokenGeneratedResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.ext.AccessTokenRequestContext;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.support.oauth.web.response.callback.BaseOAuth20AuthorizationResponseBuilder;
import org.apereo.cas.support.oauth.web.response.callback.OAuth20AuthorizationModelAndViewBuilder;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;

public class OAuth20TokenAuthorizationResponseBuilder<T extends OAuth20ConfigurationContext>
extends BaseOAuth20AuthorizationResponseBuilder<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20TokenAuthorizationResponseBuilder.class);

    public OAuth20TokenAuthorizationResponseBuilder(T configurationContext, OAuth20AuthorizationModelAndViewBuilder authorizationModelAndViewBuilder) {
        super(configurationContext, authorizationModelAndViewBuilder);
    }

    public ModelAndView build(AccessTokenRequestContext holder) throws Exception {
        LOGGER.debug("Authorize request verification successful for client [{}] with redirect uri [{}]", (Object)holder.getClientId(), (Object)holder.getRedirectUri());
        OAuth20TokenGeneratedResult result = this.configurationContext.getAccessTokenGenerator().generate(holder);
        OAuth20AccessToken accessToken = result.getAccessToken().orElse(null);
        OAuth20RefreshToken refreshToken = result.getRefreshToken().orElse(null);
        LOGGER.debug("Generated OAuth access token: [{}]", (Object)accessToken);
        return this.buildCallbackUrlResponseType(holder, accessToken, new ArrayList<NameValuePair>(0), refreshToken);
    }

    public boolean supports(OAuth20AuthorizationRequest context) {
        return StringUtils.equalsIgnoreCase((CharSequence)context.getResponseType(), (CharSequence)OAuth20ResponseTypes.TOKEN.getType());
    }

    protected ModelAndView buildCallbackUrlResponseType(AccessTokenRequestContext holder, OAuth20AccessToken accessToken, List<NameValuePair> params, OAuth20RefreshToken refreshToken) throws Exception {
        Map attributes = holder.getAuthentication().getAttributes();
        String state = ((List)attributes.get("state")).get(0).toString();
        String nonce = ((List)attributes.get("nonce")).get(0).toString();
        URIBuilder builder = new URIBuilder(holder.getRedirectUri());
        StringBuilder stringBuilder = new StringBuilder();
        String encodedAccessToken = (String)((OAuth20JwtAccessTokenEncoder.OAuth20JwtAccessTokenEncoderBuilder)((OAuth20JwtAccessTokenEncoder.OAuth20JwtAccessTokenEncoderBuilder)((OAuth20JwtAccessTokenEncoder.OAuth20JwtAccessTokenEncoderBuilder)((OAuth20JwtAccessTokenEncoder.OAuth20JwtAccessTokenEncoderBuilder)((OAuth20JwtAccessTokenEncoder.OAuth20JwtAccessTokenEncoderBuilder)OAuth20JwtAccessTokenEncoder.builder().accessToken(accessToken)).registeredService((RegisteredService)holder.getRegisteredService())).service(holder.getService())).accessTokenJwtBuilder(this.configurationContext.getAccessTokenJwtBuilder())).casProperties(this.configurationContext.getCasProperties())).build().encode((Object)accessToken.getId());
        long expiresIn = accessToken.getExpiresIn();
        stringBuilder.append("access_token").append('=').append(encodedAccessToken).append('&').append("token_type").append('=').append("Bearer").append('&').append("expires_in").append('=').append(expiresIn);
        if (refreshToken != null) {
            stringBuilder.append('&').append("refresh_token").append('=').append(refreshToken.getId());
        }
        params.forEach(p -> stringBuilder.append('&').append(p.getName()).append('=').append(p.getValue()));
        if (StringUtils.isNotBlank((CharSequence)state)) {
            stringBuilder.append('&').append("state").append('=').append(state);
        }
        if (StringUtils.isNotBlank((CharSequence)nonce)) {
            stringBuilder.append('&').append("nonce").append('=').append(nonce);
        }
        builder.setFragment(stringBuilder.toString());
        String url = builder.toString();
        LOGGER.debug("Redirecting to URL [{}]", (Object)url);
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.configurationContext.getServicesManager(), accessToken.getClientId());
        return this.build(registeredService, holder.getResponseMode(), url, new LinkedHashMap<String, String>());
    }
}

