/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.endpoints;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.BaseOAuth20Controller;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.support.oauth.web.response.introspection.BaseOAuth20IntrospectionAccessTokenResponse;
import org.apereo.cas.support.oauth.web.response.introspection.OAuth20IntrospectionAccessTokenFailureResponse;
import org.apereo.cas.support.oauth.web.response.introspection.OAuth20IntrospectionAccessTokenSuccessResponse;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.LoggingUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.extractor.BasicAuthExtractor;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

public class OAuth20IntrospectionEndpointController<T extends OAuth20ConfigurationContext>
extends BaseOAuth20Controller<T> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20IntrospectionEndpointController.class);

    public OAuth20IntrospectionEndpointController(T oAuthConfigurationContext) {
        super(oAuthConfigurationContext);
    }

    private static ResponseEntity<OAuth20IntrospectionAccessTokenFailureResponse> buildUnauthorizedResponseEntity(String code, boolean isAuthenticationFailure) {
        OAuth20IntrospectionAccessTokenFailureResponse response = new OAuth20IntrospectionAccessTokenFailureResponse();
        response.setError(code);
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        if (isAuthenticationFailure) {
            headers.add((Object)"WWW-Authenticate", (Object)"Basic");
        }
        return new ResponseEntity((Object)response, (MultiValueMap)headers, HttpStatus.UNAUTHORIZED);
    }

    private static ResponseEntity<OAuth20IntrospectionAccessTokenFailureResponse> buildBadRequestResponseEntity(String code) {
        OAuth20IntrospectionAccessTokenFailureResponse response = new OAuth20IntrospectionAccessTokenFailureResponse();
        response.setError(code);
        return new ResponseEntity((Object)response, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/oauth2.0/introspect"})
    public ResponseEntity<? extends BaseOAuth20IntrospectionAccessTokenResponse> handleRequest(HttpServletRequest request, HttpServletResponse response) {
        return this.handlePostRequest(request, response);
    }

    @PostMapping(value={"//oauth2.0/introspect"})
    public ResponseEntity<? extends BaseOAuth20IntrospectionAccessTokenResponse> handlePostRequest(HttpServletRequest request, HttpServletResponse response) {
        ResponseEntity result;
        block7: {
            try {
                BasicAuthExtractor authExtractor = new BasicAuthExtractor();
                JEEContext context = new JEEContext(request, response);
                Optional credentialsResult = authExtractor.extract((WebContext)context, ((OAuth20ConfigurationContext)this.getConfigurationContext()).getSessionStore());
                if (credentialsResult.isEmpty()) {
                    LOGGER.warn("Unable to locate and extract credentials from the request");
                    return OAuth20IntrospectionEndpointController.buildUnauthorizedResponseEntity("invalid_client", true);
                }
                UsernamePasswordCredentials credentials = (UsernamePasswordCredentials)credentialsResult.get();
                OAuthRegisteredService service = OAuth20Utils.getRegisteredOAuthServiceByClientId(((OAuth20ConfigurationContext)this.getConfigurationContext()).getServicesManager(), credentials.getUsername());
                if (service == null) {
                    LOGGER.warn("Unable to locate service definition by client id [{}]", (Object)credentials.getUsername());
                    return OAuth20IntrospectionEndpointController.buildUnauthorizedResponseEntity("invalid_client", true);
                }
                Optional<ResponseEntity<BaseOAuth20IntrospectionAccessTokenResponse>> validationError = this.validateIntrospectionRequest(service, credentials, request);
                if (validationError.isPresent()) {
                    result = validationError.get();
                    break block7;
                }
                String accessToken = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("token"), (CharSequence)request.getParameter("access_token"));
                LOGGER.debug("Located access token [{}] in the request", (Object)accessToken);
                OAuth20Token ticket = null;
                try {
                    String token = this.extractAccessTokenFrom(accessToken);
                    ticket = (OAuth20Token)((OAuth20ConfigurationContext)this.getConfigurationContext()).getTicketRegistry().getTicket(token, OAuth20Token.class);
                }
                catch (InvalidTicketException e) {
                    LOGGER.trace(e.getMessage(), (Throwable)e);
                    LOGGER.info("Unable to fetch access token [{}]: [{}]", (Object)accessToken, (Object)e.getMessage());
                }
                OAuth20IntrospectionAccessTokenSuccessResponse introspect = this.createIntrospectionValidResponse(accessToken, ticket);
                introspect.setToken(accessToken);
                result = new ResponseEntity((Object)introspect, HttpStatus.OK);
            }
            catch (Exception e) {
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
                result = OAuth20IntrospectionEndpointController.buildBadRequestResponseEntity("invalid_request");
            }
        }
        return result;
    }

    protected OAuth20IntrospectionAccessTokenSuccessResponse createIntrospectionValidResponse(String accessTokenId, OAuth20Token ticket) {
        OAuth20IntrospectionAccessTokenSuccessResponse introspect = new OAuth20IntrospectionAccessTokenSuccessResponse();
        introspect.setScope("CAS");
        if (ticket != null) {
            introspect.setClientId(ticket.getClientId());
            introspect.setAud(ticket.getService().getId());
            introspect.setActive(true);
            Authentication authentication = ticket.getAuthentication();
            String subject = authentication.getPrincipal().getId();
            introspect.setSub(subject);
            introspect.setUniqueSecurityName(subject);
            introspect.setIat(ticket.getCreationTime().toInstant().getEpochSecond());
            introspect.setExp(introspect.getIat() + ticket.getExpirationPolicy().getTimeToLive());
            List methods = (List)authentication.getAttributes().get("authenticationMethod");
            String realmNames = CollectionUtils.toCollection((Object)methods).stream().map(Object::toString).collect(Collectors.joining(","));
            introspect.setRealmName(realmNames);
            String tokenType = ticket.getAuthentication().containsAttribute("DPoPConfirmation") ? "DPoP" : "Bearer";
            introspect.setTokenType(tokenType);
            List grant = authentication.getAttributes().getOrDefault("grant_type", new ArrayList(0));
            if (!grant.isEmpty()) {
                introspect.setGrantType(grant.get(0).toString().toLowerCase());
            }
        } else {
            introspect.setActive(false);
        }
        return introspect;
    }

    private Optional<ResponseEntity<? extends BaseOAuth20IntrospectionAccessTokenResponse>> validateIntrospectionRequest(OAuthRegisteredService registeredService, UsernamePasswordCredentials credentials, HttpServletRequest request) {
        boolean tokenExists;
        boolean bl = tokenExists = HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"token") || HttpRequestUtils.doesParameterExist((HttpServletRequest)request, (String)"access_token");
        if (!tokenExists) {
            LOGGER.warn("Access token cannot be found in the request");
            return Optional.of(OAuth20IntrospectionEndpointController.buildBadRequestResponseEntity("missing_accessToken"));
        }
        if (((OAuth20ConfigurationContext)this.getConfigurationContext()).getClientSecretValidator().validate(registeredService, credentials.getPassword())) {
            WebApplicationService service = (WebApplicationService)((OAuth20ConfigurationContext)this.getConfigurationContext()).getWebApplicationServiceServiceFactory().createService(registeredService.getServiceId());
            AuditableContext audit = AuditableContext.builder().service((Service)service).registeredService((RegisteredService)registeredService).build();
            AuditableExecutionResult accessResult = ((OAuth20ConfigurationContext)this.getConfigurationContext()).getRegisteredServiceAccessStrategyEnforcer().execute(audit);
            return accessResult.isExecutionFailure() ? Optional.of(OAuth20IntrospectionEndpointController.buildUnauthorizedResponseEntity("unauthorized_client", false)) : Optional.empty();
        }
        LOGGER.warn("Unable to match client secret for registered service [{}] with client id [{}]", (Object)registeredService.getName(), (Object)registeredService.getClientId());
        return Optional.of(OAuth20IntrospectionEndpointController.buildUnauthorizedResponseEntity("invalid_client", true));
    }
}

