/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.CookieUtils;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20TicketGrantingTicketAwareSecurityLogic
extends DefaultSecurityLogic {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20TicketGrantingTicketAwareSecurityLogic.class);
    private final CasCookieBuilder ticketGrantingTicketCookieGenerator;
    private final TicketRegistry ticketRegistry;

    protected List<UserProfile> loadProfiles(ProfileManager manager, WebContext context, SessionStore sessionStore, List<Client> clients) {
        TicketGrantingTicket ticketGrantingTicket = CookieUtils.getTicketGrantingTicketFromRequest((CasCookieBuilder)this.ticketGrantingTicketCookieGenerator, (TicketRegistry)this.ticketRegistry, (HttpServletRequest)((JEEContext)context).getNativeRequest());
        if (ticketGrantingTicket == null) {
            try {
                ticketGrantingTicket = sessionStore.get(context, "ticketGrantingTicketId").map(ticketId -> (TicketGrantingTicket)this.ticketRegistry.getTicket(ticketId.toString(), TicketGrantingTicket.class)).orElse(null);
            }
            catch (Exception e) {
                LOGGER.trace("Cannot find active ticket-granting-ticket: [{}]", (Object)e.getMessage());
            }
        }
        if (ticketGrantingTicket == null) {
            LOGGER.debug("No ticket-granting-ticket/SSO session => return no pac4j user profiles to be in sync");
            return new ArrayList<UserProfile>();
        }
        return super.loadProfiles(manager, context, sessionStore, clients);
    }

    @Generated
    public OAuth20TicketGrantingTicketAwareSecurityLogic(CasCookieBuilder ticketGrantingTicketCookieGenerator, TicketRegistry ticketRegistry) {
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.ticketRegistry = ticketRegistry;
    }
}

