/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.profile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.profile.OAuth20UserProfileDataCreator;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.inspektr.audit.annotation.Audit;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;

public class DefaultOAuth20UserProfileDataCreator<T extends OAuth20ConfigurationContext>
implements OAuth20UserProfileDataCreator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultOAuth20UserProfileDataCreator.class);
    private final ObjectProvider<T> configurationContext;

    @Audit(action="OAUTH2_USER_PROFILE", actionResolverName="OAUTH2_USER_PROFILE_ACTION_RESOLVER", resourceResolverName="OAUTH2_USER_PROFILE_RESOURCE_RESOLVER")
    public Map<String, Object> createFrom(OAuth20AccessToken accessToken, JEEContext context) {
        OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(((OAuth20ConfigurationContext)this.configurationContext.getObject()).getServicesManager(), accessToken.getClientId());
        Principal principal = this.getAccessTokenAuthenticationPrincipal(accessToken, context, (RegisteredService)registeredService);
        HashMap<String, Object> modelAttributes = new HashMap<String, Object>();
        modelAttributes.put("id", principal.getId());
        modelAttributes.put("client_id", accessToken.getClientId());
        modelAttributes.put("attributes", this.collectAttributes(principal, (RegisteredService)registeredService));
        this.finalizeProfileResponse(accessToken, modelAttributes, principal, (RegisteredService)registeredService);
        return modelAttributes;
    }

    protected Map<String, List<Object>> collectAttributes(Principal principal, RegisteredService registeredService) {
        return principal.getAttributes();
    }

    protected Principal getAccessTokenAuthenticationPrincipal(OAuth20AccessToken accessToken, JEEContext context, RegisteredService registeredService) {
        Principal currentPrincipal = accessToken.getAuthentication().getPrincipal();
        LOGGER.debug("Preparing user profile response based on CAS principal [{}]", (Object)currentPrincipal);
        Principal principal = ((OAuth20ConfigurationContext)this.configurationContext.getObject()).getProfileScopeToAttributesFilter().filter(accessToken.getService(), currentPrincipal, registeredService, accessToken);
        LOGGER.debug("Created CAS principal [{}] based on requested/authorized scopes", (Object)principal);
        return principal;
    }

    protected void finalizeProfileResponse(OAuth20AccessToken accessTokenTicket, Map<String, Object> modelAttributes, Principal principal, RegisteredService registeredService) {
        if (registeredService instanceof OAuthRegisteredService) {
            Service service = accessTokenTicket.getService();
            modelAttributes.put("service", service.getId());
        }
    }

    @Generated
    public DefaultOAuth20UserProfileDataCreator(ObjectProvider<T> configurationContext) {
        this.configurationContext = configurationContext;
    }

    @Generated
    public ObjectProvider<T> getConfigurationContext() {
        return this.configurationContext;
    }
}

