/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.authenticator;

import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAccessStrategyUtils;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.support.oauth.validator.OAuth20ClientSecretValidator;
import org.apereo.cas.support.oauth.web.OAuth20RequestParameterResolver;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.UsernamePasswordCredentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.profile.CommonProfile;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20UsernamePasswordAuthenticator
implements Authenticator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20UsernamePasswordAuthenticator.class);
    private final AuthenticationSystemSupport authenticationSystemSupport;
    private final ServicesManager servicesManager;
    private final ServiceFactory webApplicationServiceFactory;
    private final SessionStore sessionStore;
    private final OAuth20RequestParameterResolver requestParameterResolver;
    private final OAuth20ClientSecretValidator clientSecretValidator;

    public void validate(Credentials credentials, WebContext webContext, SessionStore sessionStore) throws CredentialsException {
        try {
            UsernamePasswordCredentials upc = (UsernamePasswordCredentials)credentials;
            UsernamePasswordCredential casCredential = new UsernamePasswordCredential(upc.getUsername(), upc.getPassword());
            Pair clientIdAndSecret = this.requestParameterResolver.resolveClientIdAndClientSecret(webContext, this.sessionStore);
            if (StringUtils.isBlank((CharSequence)((CharSequence)clientIdAndSecret.getKey()))) {
                throw new CredentialsException("No client credentials could be identified in this request");
            }
            String clientId = (String)clientIdAndSecret.getKey();
            OAuthRegisteredService registeredService = OAuth20Utils.getRegisteredOAuthServiceByClientId(this.servicesManager, clientId);
            RegisteredServiceAccessStrategyUtils.ensureServiceAccessIsAllowed((RegisteredService)registeredService);
            String clientSecret = (String)clientIdAndSecret.getRight();
            if (!this.clientSecretValidator.validate(registeredService, clientSecret)) {
                throw new CredentialsException("Client Credentials provided is not valid for registered service: " + Objects.requireNonNull(registeredService).getName());
            }
            String redirectUri = webContext.getRequestParameter("redirect_uri").map(String::valueOf).orElse("");
            Service service = StringUtils.isNotBlank((CharSequence)redirectUri) ? this.webApplicationServiceFactory.createService(redirectUri) : null;
            AuthenticationResult authenticationResult = this.authenticationSystemSupport.finalizeAuthenticationTransaction(service, new Credential[]{casCredential});
            if (authenticationResult == null) {
                throw new CredentialsException("Could not authenticate the provided credentials");
            }
            Authentication authentication = authenticationResult.getAuthentication();
            Principal principal = authentication.getPrincipal();
            RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)registeredService).service(service).principal(principal).build();
            Map attributes = Objects.requireNonNull(registeredService).getAttributeReleasePolicy().getAttributes(context);
            CommonProfile profile = new CommonProfile();
            String id = registeredService.getUsernameAttributeProvider().resolveUsername(principal, service, (RegisteredService)registeredService);
            LOGGER.debug("Created profile id [{}]", (Object)id);
            profile.setId(id);
            profile.addAttributes(attributes);
            LOGGER.debug("Authenticated user profile [{}]", (Object)profile);
            credentials.setUserProfile((UserProfile)profile);
        }
        catch (Exception e) {
            throw new CredentialsException("Cannot login user using CAS internal authentication", (Throwable)e);
        }
    }

    @Generated
    public OAuth20UsernamePasswordAuthenticator(AuthenticationSystemSupport authenticationSystemSupport, ServicesManager servicesManager, ServiceFactory webApplicationServiceFactory, SessionStore sessionStore, OAuth20RequestParameterResolver requestParameterResolver, OAuth20ClientSecretValidator clientSecretValidator) {
        this.authenticationSystemSupport = authenticationSystemSupport;
        this.servicesManager = servicesManager;
        this.webApplicationServiceFactory = webApplicationServiceFactory;
        this.sessionStore = sessionStore;
        this.requestParameterResolver = requestParameterResolver;
        this.clientSecretValidator = clientSecretValidator;
    }
}

