/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.okta;

import java.util.Arrays;
import java.util.List;
import net.tirasa.connid.bundles.okta.OktaConnector;
import net.tirasa.connid.bundles.okta.utils.OktaFilter;
import net.tirasa.connid.bundles.okta.utils.OktaFilterOp;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.filter.AbstractFilterTranslator;
import org.identityconnectors.framework.common.objects.filter.AttributeFilter;
import org.identityconnectors.framework.common.objects.filter.ContainsFilter;
import org.identityconnectors.framework.common.objects.filter.EndsWithFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsFilter;
import org.identityconnectors.framework.common.objects.filter.EqualsIgnoreCaseFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanFilter;
import org.identityconnectors.framework.common.objects.filter.GreaterThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanFilter;
import org.identityconnectors.framework.common.objects.filter.LessThanOrEqualFilter;
import org.identityconnectors.framework.common.objects.filter.StartsWithFilter;

public class OktaFilterTranslator
extends AbstractFilterTranslator<OktaFilter> {
    private static final Log LOG = Log.getLog(OktaFilterTranslator.class);
    private final ObjectClass objectClass;

    public OktaFilterTranslator(ObjectClass objectClass) {
        this.objectClass = objectClass;
    }

    public OktaFilter createAndExpression(OktaFilter leftExpression, OktaFilter rightExpression) {
        return this.createOktaFilter(OktaFilterOp.AND, null, false, Arrays.asList(leftExpression, rightExpression), false);
    }

    public OktaFilter createOrExpression(OktaFilter leftExpression, OktaFilter rightExpression) {
        return this.createOktaFilter(OktaFilterOp.OR, null, false, Arrays.asList(leftExpression, rightExpression), false);
    }

    public OktaFilter createContainsExpression(ContainsFilter filter, boolean not) {
        return this.createOktaFilter(OktaFilterOp.CONTAINS, (AttributeFilter)filter, true, null, not);
    }

    public OktaFilter createEndsWithExpression(EndsWithFilter filter, boolean not) {
        return this.createOktaFilter(OktaFilterOp.ENDS_WITH, (AttributeFilter)filter, true, null, not);
    }

    public OktaFilter createStartsWithExpression(StartsWithFilter filter, boolean not) {
        return this.createOktaFilter(OktaFilterOp.STARTS_WITH, (AttributeFilter)filter, true, null, not);
    }

    public OktaFilter createGreaterThanExpression(GreaterThanFilter filter, boolean not) {
        return this.createOktaFilter(OktaFilterOp.GREATER_THAN, (AttributeFilter)filter, true, null, not);
    }

    public OktaFilter createGreaterThanOrEqualExpression(GreaterThanOrEqualFilter filter, boolean not) {
        return this.createOktaFilter(OktaFilterOp.GREATER_OR_EQUAL, (AttributeFilter)filter, true, null, not);
    }

    public OktaFilter createLessThanExpression(LessThanFilter filter, boolean not) {
        return this.createOktaFilter(OktaFilterOp.LESS_THAN, (AttributeFilter)filter, true, null, not);
    }

    public OktaFilter createLessThanOrEqualExpression(LessThanOrEqualFilter filter, boolean not) {
        return this.createOktaFilter(OktaFilterOp.LESS_OR_EQUAL, (AttributeFilter)filter, true, null, not);
    }

    public OktaFilter createEqualsExpression(EqualsFilter filter, boolean not) {
        return this.createOktaFilter(OktaFilterOp.EQUALS, (AttributeFilter)filter, true, null, not);
    }

    public OktaFilter createEqualsIgnoreCaseExpression(EqualsIgnoreCaseFilter filter, boolean not) {
        return this.createOktaFilter(OktaFilterOp.EQUALS, (AttributeFilter)filter, true, null, not);
    }

    private OktaFilter createOktaFilter(OktaFilterOp type, AttributeFilter filter, boolean quote, List<OktaFilter> filters, boolean not) {
        this.checkIfNot(not);
        return filter == null ? new OktaFilter(type, null, null, quote, filters) : new OktaFilter(type, this.getFilterName(filter), this.getFilterValue(filter), quote, filters);
    }

    private String getFilterName(AttributeFilter filter) {
        String name = filter.getName();
        if (ObjectClass.ACCOUNT.equals((Object)this.objectClass)) {
            if (OktaFilter.ID_ATTRS.contains(name)) {
                return "id";
            }
            if (OktaFilter.USER_NAME_ATTRS.contains(name)) {
                return "profile.login";
            }
            return "profile." + filter.getName();
        }
        if (OktaConnector.APPLICATION.equals((Object)this.objectClass)) {
            if (OktaFilter.ID_ATTRS.contains(name) || Name.NAME.equals(name)) {
                return "id";
            }
            return filter.getName();
        }
        if (ObjectClass.GROUP.equals((Object)this.objectClass)) {
            if (OktaFilter.ID_ATTRS.contains(name)) {
                return "id";
            }
            if (OktaFilter.GROUP_NAME_ATTRS.contains(name)) {
                return "profile.name";
            }
            return "profile." + filter.getName();
        }
        LOG.warn("Search of type {0} is not supported", new Object[]{this.objectClass.getObjectClassValue()});
        throw new UnsupportedOperationException("Search of type" + this.objectClass.getObjectClassValue() + " is not supported");
    }

    private String getFilterValue(AttributeFilter filter) {
        Object attrValue = AttributeUtil.getSingleValue((Attribute)filter.getAttribute());
        if (attrValue == null) {
            return null;
        }
        return attrValue.toString();
    }

    private void checkIfNot(boolean not) {
        if (not) {
            LOG.info("Search with not is not supported by Okta", new Object[0]);
        }
    }
}

