/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.spring;

import java.util.Map;
import org.flowable.common.engine.impl.cfg.SpringBeanFactoryProxyMap;
import org.flowable.eventregistry.impl.EventRegistryEngine;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.spring.SpringEventRegistryEngineConfiguration;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class EventRegistryFactoryBean
implements FactoryBean<EventRegistryEngine>,
DisposableBean,
ApplicationContextAware {
    protected EventRegistryEngineConfiguration eventEngineConfiguration;
    protected ApplicationContext applicationContext;
    protected EventRegistryEngine eventRegistryEngine;

    public void destroy() throws Exception {
        if (this.eventRegistryEngine != null) {
            this.eventRegistryEngine.close();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public EventRegistryEngine getObject() throws Exception {
        this.configureExternallyManagedTransactions();
        if (this.eventEngineConfiguration.getBeans() == null) {
            this.eventEngineConfiguration.setBeans((Map)new SpringBeanFactoryProxyMap((BeanFactory)this.applicationContext));
        }
        this.eventRegistryEngine = this.eventEngineConfiguration.buildEventRegistryEngine();
        return this.eventRegistryEngine;
    }

    protected void configureExternallyManagedTransactions() {
        SpringEventRegistryEngineConfiguration engineConfiguration;
        if (this.eventEngineConfiguration instanceof SpringEventRegistryEngineConfiguration && (engineConfiguration = (SpringEventRegistryEngineConfiguration)this.eventEngineConfiguration).getTransactionManager() != null) {
            this.eventEngineConfiguration.setTransactionsExternallyManaged(true);
        }
    }

    public Class<EventRegistryEngine> getObjectType() {
        return EventRegistryEngine.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public EventRegistryEngineConfiguration getEventEngineConfiguration() {
        return this.eventEngineConfiguration;
    }

    public void setEventEngineConfiguration(EventRegistryEngineConfiguration eventEngineConfiguration) {
        this.eventEngineConfiguration = eventEngineConfiguration;
    }
}

