/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.flowable.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.WorkflowTask;
import org.apache.syncope.common.lib.to.WorkflowTaskExecInput;
import org.apache.syncope.common.lib.types.ResourceOperation;
import org.apache.syncope.core.flowable.api.UserRequestHandler;
import org.apache.syncope.core.flowable.api.WorkflowTaskManager;
import org.apache.syncope.core.flowable.impl.FlowableRuntimeUtils;
import org.apache.syncope.core.flowable.support.DomainProcessEngine;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.PropagationByResource;
import org.apache.syncope.core.provisioning.api.UserWorkflowResult;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.event.AnyLifecycleEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.workflow.api.WorkflowException;
import org.apache.syncope.core.workflow.java.AbstractUserWorkflowAdapter;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.springframework.beans.BeanUtils;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class FlowableUserWorkflowAdapter
extends AbstractUserWorkflowAdapter
implements WorkflowTaskManager {
    protected final DomainProcessEngine engine;
    protected final UserRequestHandler userRequestHandler;
    protected final ApplicationEventPublisher publisher;

    public FlowableUserWorkflowAdapter(UserDataBinder dataBinder, UserDAO userDAO, EntityFactory entityFactory, DomainProcessEngine engine, UserRequestHandler userRequestHandler, ApplicationEventPublisher publisher) {
        super(dataBinder, userDAO, entityFactory);
        this.engine = engine;
        this.userRequestHandler = userRequestHandler;
        this.publisher = publisher;
    }

    public String getPrefix() {
        return "ACT_";
    }

    @Override
    public <T> T getVariable(String executionId, String variableName, Class<T> variableClass) {
        return (T)this.engine.getRuntimeService().getVariable(executionId, variableName, variableClass);
    }

    @Override
    public void setVariable(String executionId, String variableName, Object value) {
        this.engine.getRuntimeService().setVariable(executionId, variableName, value);
    }

    protected User lazyLoad(User user) {
        BeanUtils.copyProperties((Object)user, (Object)this.entityFactory.newEntity(User.class));
        return user;
    }

    protected UserWorkflowResult<Pair<String, Boolean>> doCreate(UserCR userCR, boolean disablePwdPolicyCheck, Boolean enabled, String creator, String context) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("wfExecutor", AuthContextUtils.getUsername());
        variables.put("userCR", userCR);
        variables.put("enabled", enabled);
        ProcessInstance procInst = null;
        try {
            procInst = this.engine.getRuntimeService().startProcessInstanceByKey("userWorkflow", variables);
        }
        catch (FlowableException e) {
            FlowableRuntimeUtils.throwException(e, "While starting userWorkflow instance");
        }
        this.engine.getRuntimeService().removeVariable(Objects.requireNonNull(procInst).getProcessInstanceId(), "wfExecutor");
        this.engine.getRuntimeService().removeVariable(procInst.getProcessInstanceId(), "userCR");
        this.engine.getRuntimeService().removeVariable(procInst.getProcessInstanceId(), "userTO");
        User user = (User)this.engine.getRuntimeService().getVariable(procInst.getProcessInstanceId(), "user", User.class);
        this.engine.getRuntimeService().removeVariable(procInst.getProcessInstanceId(), "user");
        Boolean updatedEnabled = (Boolean)this.engine.getRuntimeService().getVariable(procInst.getProcessInstanceId(), "enabled", Boolean.class);
        this.engine.getRuntimeService().removeVariable(procInst.getProcessInstanceId(), "enabled");
        if (updatedEnabled != null) {
            user.setSuspended(Boolean.valueOf(updatedEnabled == false));
        }
        if (disablePwdPolicyCheck) {
            user.removeClearPassword();
        }
        this.metadata((Any)user, creator, context);
        FlowableRuntimeUtils.updateStatus(this.engine, procInst.getProcessInstanceId(), user);
        User created = (User)this.userDAO.save((Any)user);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.CREATE, (Any)created, AuthContextUtils.getDomain()));
        this.engine.getRuntimeService().updateBusinessKey(procInst.getProcessInstanceId(), FlowableRuntimeUtils.getWFProcBusinessKey(created.getKey()));
        Boolean propagateEnable = (Boolean)this.engine.getRuntimeService().getVariable(procInst.getProcessInstanceId(), "propagateEnable", Boolean.class);
        this.engine.getRuntimeService().removeVariable(procInst.getProcessInstanceId(), "propagateEnable");
        if (propagateEnable == null) {
            propagateEnable = enabled;
        }
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(ResourceOperation.CREATE, this.userDAO.findAllResourceKeys(created.getKey()));
        PropagationByResource propByLinkedAccount = new PropagationByResource();
        user.getLinkedAccounts().forEach(account -> propByLinkedAccount.add(ResourceOperation.CREATE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue())));
        FlowableRuntimeUtils.saveForFormSubmit(this.engine, procInst.getProcessInstanceId(), this.dataBinder.getUserTO(created, true), userCR.getPassword(), enabled, (PropagationByResource<String>)propByRes, (PropagationByResource<Pair<String, String>>)propByLinkedAccount);
        Set<String> tasks = FlowableRuntimeUtils.getPerformedTasks(this.engine, procInst.getProcessInstanceId());
        return new UserWorkflowResult((Object)Pair.of((Object)created.getKey(), (Object)propagateEnable), propByRes, propByLinkedAccount, tasks);
    }

    protected Set<String> doExecuteNextTask(String procInstID, User user, Map<String, Object> moreVariables) {
        Set<String> preTasks = FlowableRuntimeUtils.getPerformedTasks(this.engine, procInstID);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("wfExecutor", AuthContextUtils.getUsername());
        variables.put("user", this.lazyLoad(user));
        if (moreVariables != null && !moreVariables.isEmpty()) {
            variables.putAll(moreVariables);
        }
        List tasks = ((TaskQuery)this.engine.getTaskService().createTaskQuery().processInstanceId(procInstID)).list();
        String task = null;
        if (tasks.size() == 1) {
            try {
                this.engine.getTaskService().complete(((Task)tasks.get(0)).getId(), variables);
                task = ((Task)tasks.get(0)).getTaskDefinitionKey();
            }
            catch (FlowableException e) {
                FlowableRuntimeUtils.throwException(e, "While completing task '" + ((Task)tasks.get(0)).getName() + "' for " + user);
            }
        } else {
            LOG.warn("Expected a single task, found {}", (Object)tasks.size());
        }
        Set<String> postTasks = FlowableRuntimeUtils.getPerformedTasks(this.engine, procInstID);
        postTasks.removeAll(preTasks);
        if (task != null) {
            postTasks.add(task);
        }
        return postTasks;
    }

    protected UserWorkflowResult<String> doActivate(User user, String token, String updater, String context) {
        String procInstID = FlowableRuntimeUtils.getWFProcInstID(this.engine, user.getKey());
        HashMap<String, Object> variables = new HashMap<String, Object>(2);
        variables.put("token", token);
        variables.put("task", "activate");
        Set<String> tasks = this.doExecuteNextTask(procInstID, user, variables);
        this.metadata((Any)user, updater, context);
        FlowableRuntimeUtils.updateStatus(this.engine, procInstID, user);
        User updated = (User)this.userDAO.save((Any)user);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Any)updated, AuthContextUtils.getDomain()));
        variables.keySet().forEach(key -> this.engine.getRuntimeService().removeVariable(procInstID, key));
        this.engine.getRuntimeService().removeVariable(procInstID, "user");
        this.engine.getRuntimeService().removeVariable(procInstID, "wfExecutor");
        return new UserWorkflowResult((Object)updated.getKey(), null, null, tasks);
    }

    protected UserWorkflowResult<Pair<UserUR, Boolean>> doUpdate(User user, UserUR userUR, String updater, String context) {
        String procInstID = FlowableRuntimeUtils.getWFProcInstID(this.engine, user.getKey());
        UserUR beforeUpdate = (UserUR)this.engine.getRuntimeService().getVariable(procInstID, "userUR", UserUR.class);
        PropagationByResource propByResBeforeUpdate = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstID, "propByResource", PropagationByResource.class);
        PropagationByResource propByLinkedAccountBeforeUpdate = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstID, "propByLinkedAccount", PropagationByResource.class);
        boolean inFormTask = FlowableRuntimeUtils.getFormTask(this.engine, procInstID) != null;
        HashMap<String, Object> variables = new HashMap<String, Object>(2);
        variables.put("userUR", userUR);
        variables.put("task", "update");
        Set<String> tasks = this.doExecuteNextTask(procInstID, user, variables);
        this.metadata((Any)user, updater, context);
        FlowableRuntimeUtils.updateStatus(this.engine, procInstID, user);
        User updated = (User)this.userDAO.save((Any)user);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Any)updated, AuthContextUtils.getDomain()));
        this.engine.getRuntimeService().removeVariable(procInstID, "user");
        this.engine.getRuntimeService().removeVariable(procInstID, "wfExecutor");
        this.engine.getRuntimeService().removeVariable(procInstID, "task");
        if (inFormTask) {
            if (beforeUpdate == null) {
                this.engine.getRuntimeService().removeVariable(procInstID, "userUR");
            } else {
                this.engine.getRuntimeService().setVariable(procInstID, "userUR", (Object)beforeUpdate);
            }
        }
        boolean bl = inFormTask = FlowableRuntimeUtils.getFormTask(this.engine, procInstID) != null;
        if (!inFormTask) {
            this.engine.getRuntimeService().removeVariable(procInstID, "userUR");
        }
        PropagationByResource propByRes = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstID, "propByResource", PropagationByResource.class);
        this.engine.getRuntimeService().removeVariable(procInstID, "propByResource");
        PropagationByResource propByLinkedAccount = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstID, "propByLinkedAccount", PropagationByResource.class);
        this.engine.getRuntimeService().removeVariable(procInstID, "propByLinkedAccount");
        FlowableRuntimeUtils.saveForFormSubmit(this.engine, procInstID, this.dataBinder.getUserTO(updated, true), userUR.getPassword() == null ? null : (String)userUR.getPassword().getValue(), null, (PropagationByResource<String>)Optional.ofNullable(propByResBeforeUpdate).orElse(propByRes), (PropagationByResource<Pair<String, String>>)Optional.ofNullable(propByLinkedAccountBeforeUpdate).orElse(propByLinkedAccount));
        Boolean propagateEnable = (Boolean)this.engine.getRuntimeService().getVariable(procInstID, "propagateEnable", Boolean.class);
        this.engine.getRuntimeService().removeVariable(procInstID, "propagateEnable");
        return new UserWorkflowResult((Object)Pair.of((Object)userUR, (Object)propagateEnable), propByRes, propByLinkedAccount, tasks);
    }

    protected UserWorkflowResult<String> doSuspend(User user, String updater, String context) {
        String procInstID = FlowableRuntimeUtils.getWFProcInstID(this.engine, user.getKey());
        Set<String> performedTasks = this.doExecuteNextTask(procInstID, user, Map.of("task", "suspend"));
        this.metadata((Any)user, updater, context);
        FlowableRuntimeUtils.updateStatus(this.engine, procInstID, user);
        User updated = (User)this.userDAO.save((Any)user);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Any)updated, AuthContextUtils.getDomain()));
        PropagationByResource propByRes = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstID, "propByResource", PropagationByResource.class);
        this.engine.getRuntimeService().removeVariable(procInstID, "propByResource");
        PropagationByResource propByLinkedAccount = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstID, "propByLinkedAccount", PropagationByResource.class);
        this.engine.getRuntimeService().removeVariable(procInstID, "propByLinkedAccount");
        this.engine.getRuntimeService().removeVariable(procInstID, "task");
        this.engine.getRuntimeService().removeVariable(procInstID, "user");
        this.engine.getRuntimeService().removeVariable(procInstID, "wfExecutor");
        this.engine.getRuntimeService().removeVariable(procInstID, "propByResource");
        this.engine.getRuntimeService().removeVariable(procInstID, "propByLinkedAccount");
        return new UserWorkflowResult((Object)updated.getKey(), propByRes, propByLinkedAccount, performedTasks);
    }

    protected UserWorkflowResult<String> doReactivate(User user, String updater, String context) {
        String procInstID = FlowableRuntimeUtils.getWFProcInstID(this.engine, user.getKey());
        Set<String> performedTasks = this.doExecuteNextTask(procInstID, user, Map.of("task", "reactivate"));
        this.metadata((Any)user, updater, context);
        FlowableRuntimeUtils.updateStatus(this.engine, procInstID, user);
        User updated = (User)this.userDAO.save((Any)user);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Any)updated, AuthContextUtils.getDomain()));
        PropagationByResource propByRes = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstID, "propByResource", PropagationByResource.class);
        this.engine.getRuntimeService().removeVariable(procInstID, "propByResource");
        PropagationByResource propByLinkedAccount = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstID, "propByLinkedAccount", PropagationByResource.class);
        this.engine.getRuntimeService().removeVariable(procInstID, "propByLinkedAccount");
        this.engine.getRuntimeService().removeVariable(procInstID, "task");
        this.engine.getRuntimeService().removeVariable(procInstID, "user");
        this.engine.getRuntimeService().removeVariable(procInstID, "wfExecutor");
        this.engine.getRuntimeService().removeVariable(procInstID, "propByResource");
        this.engine.getRuntimeService().removeVariable(procInstID, "propByLinkedAccount");
        return new UserWorkflowResult((Object)updated.getKey(), propByRes, propByLinkedAccount, performedTasks);
    }

    protected void doRequestPasswordReset(User user, String updater, String context) {
        HashMap<String, Object> variables = new HashMap<String, Object>(3);
        variables.put("userTO", this.dataBinder.getUserTO(user, true));
        variables.put("task", "requestPasswordReset");
        variables.put("event", "requestPasswordReset");
        String procInstID = FlowableRuntimeUtils.getWFProcInstID(this.engine, user.getKey());
        this.doExecuteNextTask(procInstID, user, variables);
        this.metadata((Any)user, updater, context);
        User updated = (User)this.userDAO.save((Any)user);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Any)updated, AuthContextUtils.getDomain()));
        variables.keySet().forEach(key -> this.engine.getRuntimeService().removeVariable(procInstID, key));
        this.engine.getRuntimeService().removeVariable(procInstID, "user");
        this.engine.getRuntimeService().removeVariable(procInstID, "wfExecutor");
    }

    protected UserWorkflowResult<Pair<UserUR, Boolean>> doConfirmPasswordReset(User user, String token, String password, String updater, String context) {
        HashMap<String, Object> variables = new HashMap<String, Object>(5);
        variables.put("token", token);
        variables.put("password", password);
        variables.put("userTO", this.dataBinder.getUserTO(user, true));
        variables.put("task", "confirmPasswordReset");
        variables.put("event", "confirmPasswordReset");
        String procInstID = FlowableRuntimeUtils.getWFProcInstID(this.engine, user.getKey());
        Set<String> tasks = this.doExecuteNextTask(procInstID, user, variables);
        this.metadata((Any)user, updater, context);
        User updated = (User)this.userDAO.save((Any)user);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Any)updated, AuthContextUtils.getDomain()));
        variables.keySet().forEach(key -> this.engine.getRuntimeService().removeVariable(procInstID, key));
        this.engine.getRuntimeService().removeVariable(procInstID, "user");
        this.engine.getRuntimeService().removeVariable(procInstID, "wfExecutor");
        PropagationByResource propByRes = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstID, "propByResource", PropagationByResource.class);
        this.engine.getRuntimeService().removeVariable(procInstID, "propByResource");
        PropagationByResource propByLinkedAccount = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstID, "propByLinkedAccount", PropagationByResource.class);
        this.engine.getRuntimeService().removeVariable(procInstID, "propByLinkedAccount");
        UserUR updatedReq = (UserUR)this.engine.getRuntimeService().getVariable(procInstID, "userUR", UserUR.class);
        this.engine.getRuntimeService().removeVariable(procInstID, "userUR");
        Boolean propagateEnable = (Boolean)this.engine.getRuntimeService().getVariable(procInstID, "propagateEnable", Boolean.class);
        this.engine.getRuntimeService().removeVariable(procInstID, "propagateEnable");
        return new UserWorkflowResult((Object)Pair.of((Object)updatedReq, (Object)propagateEnable), propByRes, propByLinkedAccount, tasks);
    }

    protected void doDelete(User user, String eraser, String context) {
        String procInstID = FlowableRuntimeUtils.getWFProcInstID(this.engine, user.getKey());
        this.doExecuteNextTask(procInstID, user, Map.of("task", "delete"));
        PropagationByResource propByRes = new PropagationByResource();
        propByRes.set(ResourceOperation.DELETE, this.userDAO.findAllResourceKeys(user.getKey()));
        PropagationByResource propByLinkedAccount = new PropagationByResource();
        user.getLinkedAccounts().forEach(account -> propByLinkedAccount.add(ResourceOperation.DELETE, (Serializable)Pair.of((Object)account.getResource().getKey(), (Object)account.getConnObjectKeyValue())));
        if (this.engine.getRuntimeService().createProcessInstanceQuery().processInstanceId(procInstID).active().list().isEmpty()) {
            this.userDAO.delete(user.getKey());
            this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.DELETE, (Any)user, AuthContextUtils.getDomain()));
            if (!this.engine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(procInstID).list().isEmpty()) {
                this.engine.getHistoryService().deleteHistoricProcessInstance(procInstID);
            }
        } else {
            FlowableRuntimeUtils.saveForFormSubmit(this.engine, procInstID, this.dataBinder.getUserTO(user, true), null, null, (PropagationByResource<String>)propByRes, (PropagationByResource<Pair<String, String>>)propByLinkedAccount);
            FlowableRuntimeUtils.updateStatus(this.engine, procInstID, user);
            this.metadata((Any)user, eraser, context);
            User updated = (User)this.userDAO.save((Any)user);
            this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Any)updated, AuthContextUtils.getDomain()));
            this.engine.getRuntimeService().removeVariable(procInstID, "task");
            this.engine.getRuntimeService().removeVariable(procInstID, "user");
            this.engine.getRuntimeService().removeVariable(procInstID, "wfExecutor");
        }
    }

    @Override
    public UserWorkflowResult<String> executeNextTask(WorkflowTaskExecInput workflowTaskExecInput) {
        User user = (User)this.userDAO.authFind(workflowTaskExecInput.getUserKey());
        String procInstID = FlowableRuntimeUtils.getWFProcInstID(this.engine, user.getKey());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("userTO", this.dataBinder.getUserTO(user, true));
        variables.putAll(workflowTaskExecInput.getVariables());
        Set<String> performedTasks = this.doExecuteNextTask(procInstID, user, variables);
        FlowableRuntimeUtils.updateStatus(this.engine, procInstID, user);
        user = (User)this.userDAO.save((Any)user);
        this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Any)user, AuthContextUtils.getDomain()));
        this.engine.getRuntimeService().setVariable(procInstID, "userTO", (Object)this.dataBinder.getUserTO(user, true));
        if (this.engine.getRuntimeService().createProcessInstanceQuery().processInstanceId(procInstID).active().list().isEmpty()) {
            this.userDAO.delete(user.getKey());
            this.publisher.publishEvent((ApplicationEvent)new AnyLifecycleEvent((Object)this, SyncDeltaType.DELETE, (Any)user, AuthContextUtils.getDomain()));
            if (!this.engine.getHistoryService().createHistoricProcessInstanceQuery().processInstanceId(procInstID).list().isEmpty()) {
                this.engine.getHistoryService().deleteHistoricProcessInstance(procInstID);
            }
        } else {
            PropagationByResource propByRes = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstID, "propByResource", PropagationByResource.class);
            PropagationByResource propByLinkedAccount = (PropagationByResource)this.engine.getRuntimeService().getVariable(procInstID, "propByLinkedAccount", PropagationByResource.class);
            FlowableRuntimeUtils.saveForFormSubmit(this.engine, procInstID, this.dataBinder.getUserTO(user, true), null, null, (PropagationByResource<String>)propByRes, (PropagationByResource<Pair<String, String>>)propByLinkedAccount);
        }
        return new UserWorkflowResult((Object)user.getKey(), null, null, performedTasks);
    }

    protected static void navigateAvailableTasks(FlowElement flow, List<String> availableTasks) {
        if (flow instanceof Gateway) {
            ((Gateway)flow).getOutgoingFlows().forEach(subflow -> FlowableUserWorkflowAdapter.navigateAvailableTasks((FlowElement)subflow, availableTasks));
        } else if (flow instanceof SequenceFlow) {
            FlowableUserWorkflowAdapter.navigateAvailableTasks(((SequenceFlow)flow).getTargetFlowElement(), availableTasks);
        } else if (flow instanceof org.flowable.bpmn.model.Task) {
            availableTasks.add(flow.getId());
        } else {
            LOG.debug("Unexpected flow found: {}", (Object)flow);
        }
    }

    @Override
    public List<WorkflowTask> getAvailableTasks(String userKey) {
        String procInstID = FlowableRuntimeUtils.getWFProcInstID(this.engine, userKey);
        ArrayList availableTasks = new ArrayList();
        try {
            Task currentTask = (Task)((TaskQuery)this.engine.getTaskService().createTaskQuery().processInstanceId(procInstID)).singleResult();
            Process process = (Process)this.engine.getRepositoryService().getBpmnModel(FlowableRuntimeUtils.getLatestProcDefByKey(this.engine, "userWorkflow").getId()).getProcesses().get(0);
            process.getFlowElements().stream().filter(SequenceFlow.class::isInstance).map(SequenceFlow.class::cast).filter(flow -> flow.getSourceRef().equals(currentTask.getTaskDefinitionKey())).forEach(flow -> FlowableUserWorkflowAdapter.navigateAvailableTasks(flow.getTargetFlowElement(), availableTasks));
        }
        catch (FlowableException e) {
            throw new WorkflowException("While reading available tasks for workflow instance " + procInstID, (Throwable)e);
        }
        return availableTasks.stream().map(input -> {
            WorkflowTask workflowTaskTO = new WorkflowTask();
            workflowTaskTO.setName(input);
            return workflowTaskTO;
        }).collect(Collectors.toList());
    }
}

