/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.impl.parser;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.util.io.InputStreamSource;
import org.flowable.common.engine.impl.util.io.StreamSource;
import org.flowable.common.engine.impl.util.io.StringStreamSource;
import org.flowable.common.engine.impl.util.io.UrlStreamSource;
import org.flowable.eventregistry.impl.EventRegistryEngineConfiguration;
import org.flowable.eventregistry.impl.io.ResourceStreamSource;
import org.flowable.eventregistry.impl.persistence.entity.ChannelDefinitionEntity;
import org.flowable.eventregistry.impl.persistence.entity.EventDeploymentEntity;
import org.flowable.eventregistry.json.converter.ChannelJsonConverter;
import org.flowable.eventregistry.model.ChannelModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelDefinitionParse {
    protected static final Logger LOGGER = LoggerFactory.getLogger(ChannelDefinitionParse.class);
    protected String name;
    protected StreamSource streamSource;
    protected String sourceSystemId;
    protected ChannelModel channelModel;
    protected EventDeploymentEntity deployment;
    protected List<ChannelDefinitionEntity> channelDefinitions = new ArrayList<ChannelDefinitionEntity>();

    public ChannelDefinitionParse deployment(EventDeploymentEntity deployment) {
        this.deployment = deployment;
        return this;
    }

    public ChannelDefinitionParse execute(EventRegistryEngineConfiguration eventEngineConfig) {
        String encoding = eventEngineConfig.getXmlEncoding();
        ChannelJsonConverter converter = eventEngineConfig.getChannelJsonConverter();
        try (InputStreamReader in = this.newInputStreamReaderForSource(encoding);){
            String channelJson = IOUtils.toString((Reader)in);
            this.channelModel = converter.convertToChannelModel(channelJson);
            if (this.channelModel != null && this.channelModel.getKey() != null) {
                ChannelDefinitionEntity channelDefinitionEntity = (ChannelDefinitionEntity)eventEngineConfig.getChannelDefinitionEntityManager().create();
                channelDefinitionEntity.setCreateTime(new Date());
                channelDefinitionEntity.setKey(this.channelModel.getKey());
                channelDefinitionEntity.setCategory(this.channelModel.getCategory());
                channelDefinitionEntity.setName(this.channelModel.getName());
                channelDefinitionEntity.setDescription(this.channelModel.getDescription());
                channelDefinitionEntity.setType(this.channelModel.getChannelType());
                channelDefinitionEntity.setImplementation(this.channelModel.getType());
                channelDefinitionEntity.setResourceName(this.name);
                channelDefinitionEntity.setDeploymentId(this.deployment.getId());
                this.channelDefinitions.add(channelDefinitionEntity);
            }
        }
        catch (Exception e) {
            throw new FlowableException("Error parsing channel definition JSON", (Throwable)e);
        }
        return this;
    }

    private InputStreamReader newInputStreamReaderForSource(String encoding) throws UnsupportedEncodingException {
        if (encoding != null) {
            return new InputStreamReader(this.streamSource.getInputStream(), encoding);
        }
        return new InputStreamReader(this.streamSource.getInputStream());
    }

    public ChannelDefinitionParse name(String name) {
        this.name = name;
        return this;
    }

    public ChannelDefinitionParse sourceInputStream(InputStream inputStream) {
        if (this.name == null) {
            this.name("inputStream");
        }
        this.setStreamSource((StreamSource)new InputStreamSource(inputStream));
        return this;
    }

    public String getSourceSystemId() {
        return this.sourceSystemId;
    }

    public ChannelDefinitionParse setSourceSystemId(String sourceSystemId) {
        this.sourceSystemId = sourceSystemId;
        return this;
    }

    public ChannelDefinitionParse sourceUrl(URL url) {
        if (this.name == null) {
            this.name(url.toString());
        }
        this.setStreamSource((StreamSource)new UrlStreamSource(url));
        return this;
    }

    public ChannelDefinitionParse sourceUrl(String url) {
        try {
            return this.sourceUrl(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new FlowableException("malformed url: " + url, (Throwable)e);
        }
    }

    public ChannelDefinitionParse sourceResource(String resource) {
        if (this.name == null) {
            this.name(resource);
        }
        this.setStreamSource(new ResourceStreamSource(resource));
        return this;
    }

    public ChannelDefinitionParse sourceString(String string) {
        if (this.name == null) {
            this.name("string");
        }
        this.setStreamSource((StreamSource)new StringStreamSource(string));
        return this;
    }

    protected void setStreamSource(StreamSource streamSource) {
        if (this.streamSource != null) {
            throw new FlowableException("invalid: multiple sources " + this.streamSource + " and " + streamSource);
        }
        this.streamSource = streamSource;
    }

    public List<ChannelDefinitionEntity> getChannelDefinitions() {
        return this.channelDefinitions;
    }

    public EventDeploymentEntity getDeployment() {
        return this.deployment;
    }

    public void setDeployment(EventDeploymentEntity deployment) {
        this.deployment = deployment;
    }

    public ChannelModel getChannelModel() {
        return this.channelModel;
    }

    public void setChannelModel(ChannelModel channelModel) {
        this.channelModel = channelModel;
    }
}

