/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.layout.LinkedAccountForm;
import org.apache.syncope.client.console.layout.LinkedAccountFormLayoutInfo;
import org.apache.syncope.client.console.rest.UserRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.console.wizards.any.LinkedAccountCredentialsPanel;
import org.apache.syncope.client.console.wizards.any.LinkedAccountDetailsPanel;
import org.apache.syncope.client.console.wizards.any.LinkedAccountPlainAttrsPanel;
import org.apache.syncope.client.console.wizards.any.LinkedAccountPrivilegesPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.any.EntityWrapper;
import org.apache.syncope.common.lib.request.LinkedAccountUR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.LinkedAccountTO;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.model.IModel;

public class LinkedAccountWizardBuilder
extends BaseAjaxWizardBuilder<LinkedAccountTO>
implements LinkedAccountForm {
    private static final long serialVersionUID = -9142332740863374891L;
    private final UserRestClient userRestClient = new UserRestClient();
    private final IModel<UserTO> model;
    protected LinkedAccountFormLayoutInfo formLayoutInfo;

    public LinkedAccountWizardBuilder(IModel<UserTO> model, LinkedAccountFormLayoutInfo formLayoutInfo, PageReference pageRef) {
        super((Serializable)new LinkedAccountTO(), pageRef);
        this.model = model;
        this.formLayoutInfo = formLayoutInfo;
    }

    public AjaxWizard<LinkedAccountTO> build(String id, AjaxWizard.Mode mode) {
        return super.build(id, mode);
    }

    protected WizardModel buildModelSteps(LinkedAccountTO modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new LinkedAccountDetailsPanel(modelObject));
        if (this.formLayoutInfo.isCredentials()) {
            wizardModel.add((IWizardStep)new LinkedAccountCredentialsPanel((EntityWrapper<LinkedAccountTO>)new EntityWrapper((EntityTO)modelObject), this.formLayoutInfo.getWhichCredentials()));
        }
        if (this.formLayoutInfo.isPlainAttrs()) {
            wizardModel.add((IWizardStep)new LinkedAccountPlainAttrsPanel((EntityWrapper<LinkedAccountTO>)new EntityWrapper((EntityTO)modelObject), (UserTO)this.model.getObject(), this.formLayoutInfo.getWhichPlainAttrs()));
        }
        if (this.formLayoutInfo.isPrivileges()) {
            wizardModel.add((IWizardStep)new LinkedAccountPrivilegesPanel(modelObject));
        }
        return wizardModel;
    }

    protected Serializable onApplyInternal(LinkedAccountTO modelObject) {
        this.fixPlainAttrs(modelObject);
        LinkedAccountUR linkedAccountPatch = (LinkedAccountUR)new LinkedAccountUR.Builder().linkedAccountTO(modelObject).build();
        linkedAccountPatch.setLinkedAccountTO(modelObject);
        UserUR req = new UserUR();
        req.setKey(((UserTO)this.model.getObject()).getKey());
        req.getLinkedAccounts().add(linkedAccountPatch);
        this.model.setObject((Object)((UserTO)this.userRestClient.update(((UserTO)this.model.getObject()).getETagValue(), req).getEntity()));
        return modelObject;
    }

    private void fixPlainAttrs(LinkedAccountTO linkedAccountTO) {
        HashSet validAttrs = new HashSet(linkedAccountTO.getPlainAttrs().stream().filter(attr -> !attr.getValues().isEmpty()).collect(Collectors.toSet()));
        linkedAccountTO.getPlainAttrs().clear();
        linkedAccountTO.getPlainAttrs().addAll(validAttrs);
    }

    protected Serializable getCreateCustomPayloadEvent(Serializable afterObject, AjaxRequestTarget target) {
        LinkedAccountTO linkedAccountTO = (LinkedAccountTO)LinkedAccountTO.class.cast(afterObject);
        return new CreateEvent(linkedAccountTO.getConnObjectKeyValue(), (UserTO)this.model.getObject(), target);
    }

    private static class CreateEvent
    extends BaseModal.ModalEvent {
        private static final long serialVersionUID = 6416834092156281986L;
        private final String key;
        private final UserTO userTO;

        CreateEvent(String key, UserTO userTO, AjaxRequestTarget target) {
            super(target);
            this.key = key;
            this.userTO = userTO;
        }

        public String getKey() {
            return this.key;
        }

        public UserTO getUserTO() {
            return this.userTO;
        }
    }
}

