/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.panels.CSVConfPanel;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.ReconciliationRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.AjaxDownloadBehavior;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.rest.ResponseHolder;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.common.rest.api.beans.AbstractCSVSpec;
import org.apache.syncope.common.rest.api.beans.AnyQuery;
import org.apache.syncope.common.rest.api.beans.CSVPushSpec;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.request.cycle.RequestCycle;

public class CSVPushWizardBuilder
extends BaseAjaxWizardBuilder<CSVPushSpec> {
    private static final long serialVersionUID = -8890710681835661962L;
    private final AnyQuery query;
    private final AjaxDownloadBehavior downloadBehavior;

    public CSVPushWizardBuilder(CSVPushSpec defaultItem, AnyQuery query, AjaxDownloadBehavior downloadBehavior, PageReference pageRef) {
        super((Serializable)defaultItem, pageRef);
        this.query = query;
        this.downloadBehavior = downloadBehavior;
    }

    public CSVPushWizardBuilder setEventSink(IEventSink eventSink) {
        super.setEventSink(eventSink);
        return this;
    }

    protected Serializable onApplyInternal(CSVPushSpec modelObject) {
        return RequestCycle.get().find(AjaxRequestTarget.class).map(target -> {
            try {
                this.downloadBehavior.setResponse(new ResponseHolder(ReconciliationRestClient.push(this.query, modelObject)));
                this.downloadBehavior.initiate(target);
                return "operation_succeeded";
            }
            catch (Exception e) {
                LOG.error("While dowloading CSV export", (Throwable)e);
                return e;
            }
        }).orElse((Serializable)((Object)"error"));
    }

    protected WizardModel buildModelSteps(CSVPushSpec modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Details(modelObject));
        wizardModel.add((IWizardStep)new PushTask(modelObject));
        return wizardModel;
    }

    public static class PushTask
    extends WizardStep {
        private static final long serialVersionUID = -2747583614435078452L;
        private final IModel<List<String>> propActions = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 4659376149825914247L;

            protected List<String> load() {
                return ImplementationRestClient.list((String)"PROPAGATION_ACTIONS").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
            }
        };
        private final IModel<List<String>> pushActions = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 4659376149825914247L;

            protected List<String> load() {
                return ImplementationRestClient.list((String)"PUSH_ACTIONS").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
            }
        };

        public PushTask(CSVPushSpec spec) {
            AjaxCheckBoxPanel ignorePaging = new AjaxCheckBoxPanel("ignorePaging", "ignorePaging", (IModel)new PropertyModel((Object)spec, "ignorePaging"), true);
            this.add(new Component[]{ignorePaging});
            AjaxPalettePanel propagationActions = new AjaxPalettePanel.Builder().build("propagationActions", (IModel)new PropertyModel((Object)spec, "propagationActions"), (IModel)new ListModel((List)this.propActions.getObject()));
            this.add(new Component[]{propagationActions});
            AjaxDropDownChoicePanel matchingRule = new AjaxDropDownChoicePanel("matchingRule", "matchingRule", (IModel)new PropertyModel((Object)spec, "matchingRule"), false);
            matchingRule.setChoices(List.of(MatchingRule.values()));
            this.add(new Component[]{matchingRule});
            AjaxDropDownChoicePanel unmatchingRule = new AjaxDropDownChoicePanel("unmatchingRule", "unmatchingRule", (IModel)new PropertyModel((Object)spec, "unmatchingRule"), false);
            unmatchingRule.setChoices(List.of(UnmatchingRule.values()));
            this.add(new Component[]{unmatchingRule});
            AjaxPalettePanel provisioningActions = new AjaxPalettePanel.Builder().build("provisioningActions", (IModel)new PropertyModel((Object)spec, "provisioningActions"), (IModel)new ListModel((List)this.pushActions.getObject()));
            this.add(new Component[]{provisioningActions});
        }
    }

    public class Details
    extends WizardStep {
        private static final long serialVersionUID = -2368995286051427297L;

        public Details(CSVPushSpec spec) {
            this.add(new Component[]{new CSVConfPanel("csvconf", (AbstractCSVSpec)spec)});
        }
    }
}

