/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.status;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.rest.ReconciliationRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxSearchFieldPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.to.ProvisioningTaskTO;
import org.apache.syncope.common.lib.to.PullTaskTO;
import org.apache.syncope.common.lib.to.PushTaskTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.common.lib.types.MatchingRule;
import org.apache.syncope.common.lib.types.UnmatchingRule;
import org.apache.syncope.common.rest.api.beans.RealmQuery;
import org.apache.syncope.common.rest.api.beans.ReconQuery;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconTaskPanel
extends MultilevelPanel.SecondLevel {
    private static final long serialVersionUID = 5870444905957760434L;
    protected static final Logger LOG = LoggerFactory.getLogger(ReconTaskPanel.class);
    private final IModel<List<String>> pullActions = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return ImplementationRestClient.list((String)"PULL_ACTIONS").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
        }
    };
    private final IModel<List<String>> pushActions = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return ImplementationRestClient.list((String)"PUSH_ACTIONS").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
        }
    };

    public ReconTaskPanel(String resource, ProvisioningTaskTO taskTO, String anyType, String anyKey, boolean isOnSyncope, MultilevelPanel multiLevelPanelRef, PageReference pageRef) {
        this(resource, taskTO, anyType, anyKey, null, isOnSyncope, multiLevelPanelRef, pageRef);
    }

    public ReconTaskPanel(final String resource, final ProvisioningTaskTO taskTO, final String anyType, final String anyKey, final String fiql, boolean isOnSyncope, final MultilevelPanel multiLevelPanelRef, final PageReference pageRef) {
        final Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)taskTO));
        this.add(new Component[]{form});
        if (taskTO instanceof PushTaskTO) {
            form.add(new Component[]{new Label("realm", (Serializable)((Object)""))});
            form.add(new Component[]{new Label("remediation", (Serializable)((Object)""))});
        } else {
            final boolean isSearchEnabled = RealmsUtils.isSearchEnabled();
            AutoCompleteSettings settings = new AutoCompleteSettings();
            settings.setShowCompleteListOnFocusGain(!isSearchEnabled);
            settings.setShowListOnEmptyInput(!isSearchEnabled);
            AjaxSearchFieldPanel realm = new AjaxSearchFieldPanel("realm", "destinationRealm", (IModel)new PropertyModel((Object)taskTO, "destinationRealm"), settings){
                private static final long serialVersionUID = -6390474600233486704L;

                protected Iterator<String> getChoices(String input) {
                    return (RealmsUtils.checkInput((String)input) ? (isSearchEnabled ? RealmRestClient.search((RealmQuery)RealmsUtils.buildQuery((String)input)).getResult() : RealmRestClient.list((String)"/")) : List.of()).stream().sorted(Comparator.comparing(RealmTO::getName)).map(RealmTO::getFullPath).collect(Collectors.toList()).iterator();
                }
            };
            realm.addRequiredLabel();
            realm.setOutputMarkupId(true);
            if (StringUtils.isBlank((CharSequence)((PullTaskTO)PullTaskTO.class.cast(taskTO)).getDestinationRealm())) {
                realm.getField().setModelObject((Object)"/");
            }
            if (isOnSyncope) {
                realm.setEnabled(false);
            }
            form.add(new Component[]{realm});
            form.add(new Component[]{new AjaxCheckBoxPanel("remediation", "remediation", (IModel)new PropertyModel((Object)taskTO, "remediation"), false)});
        }
        AjaxPalettePanel actions = new AjaxPalettePanel.Builder().setAllowMoveAll(true).setAllowOrder(true).build("actions", (IModel)new PropertyModel((Object)taskTO, "actions"), (IModel)new ListModel(taskTO instanceof PushTaskTO ? (List)this.pushActions.getObject() : (List)this.pullActions.getObject()));
        actions.setOutputMarkupId(true);
        form.add(new Component[]{actions});
        AjaxDropDownChoicePanel matchingRule = new AjaxDropDownChoicePanel("matchingRule", "matchingRule", (IModel)new PropertyModel((Object)taskTO, "matchingRule"), false);
        matchingRule.setChoices(List.of(MatchingRule.values()));
        form.add(new Component[]{matchingRule});
        AjaxDropDownChoicePanel unmatchingRule = new AjaxDropDownChoicePanel("unmatchingRule", "unmatchingRule", (IModel)new PropertyModel((Object)taskTO, "unmatchingRule"), false);
        unmatchingRule.setChoices(List.of(UnmatchingRule.values()));
        form.add(new Component[]{unmatchingRule});
        taskTO.setPerformCreate(true);
        AjaxCheckBoxPanel performCreate = new AjaxCheckBoxPanel("performCreate", "performCreate", (IModel)new PropertyModel((Object)taskTO, "performCreate"), false);
        form.add(new Component[]{performCreate});
        taskTO.setPerformUpdate(true);
        AjaxCheckBoxPanel performUpdate = new AjaxCheckBoxPanel("performUpdate", "performUpdate", (IModel)new PropertyModel((Object)taskTO, "performUpdate"), false);
        form.add(new Component[]{performUpdate});
        taskTO.setPerformDelete(true);
        AjaxCheckBoxPanel performDelete = new AjaxCheckBoxPanel("performDelete", "performDelete", (IModel)new PropertyModel((Object)taskTO, "performDelete"), false);
        form.add(new Component[]{performDelete});
        taskTO.setSyncStatus(true);
        AjaxCheckBoxPanel syncStatus = new AjaxCheckBoxPanel("syncStatus", "syncStatus", (IModel)new PropertyModel((Object)taskTO, "syncStatus"), false);
        form.add(new Component[]{syncStatus});
        form.add(new Component[]{new AjaxSubmitLink("reconcile"){
            private static final long serialVersionUID = -817438685948164787L;

            protected void onSubmit(AjaxRequestTarget target) {
                ReconQuery reconQuery = new ReconQuery.Builder(anyType, resource).anyKey(anyKey).fiql(fiql).build();
                try {
                    if (taskTO instanceof PushTaskTO) {
                        ReconciliationRestClient.push(reconQuery, (PushTaskTO)form.getModelObject());
                    } else {
                        ReconciliationRestClient.pull(reconQuery, (PullTaskTO)form.getModelObject());
                    }
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                }
                catch (Exception e) {
                    LOG.error("While attempting reconciliation using query {} on {}", new Object[]{reconQuery, form.getModelObject(), e});
                    SyncopeConsoleSession.get().onException(e);
                }
                multiLevelPanelRef.prev(target);
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }});
    }
}

