/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.oidc;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.RealmMember;
import org.apache.syncope.common.lib.oidc.OIDCLoginResponse;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.OIDCC4UIProvider;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.IntAttrName;
import org.apache.syncope.core.provisioning.api.IntAttrNameParser;
import org.apache.syncope.core.provisioning.api.OIDCC4UIProviderActions;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.java.pushpull.InboundMatcher;
import org.apache.syncope.core.provisioning.java.utils.MappingUtils;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class OIDCUserManager {
    protected static final Logger LOG = LoggerFactory.getLogger(OIDCUserManager.class);
    protected static final String OIDC_CLIENT_CONTEXT = "OIDC Client";
    protected final InboundMatcher inboundMatcher;
    protected final UserDAO userDAO;
    protected final ImplementationDAO implementationDAO;
    protected final IntAttrNameParser intAttrNameParser;
    protected final TemplateUtils templateUtils;
    protected final UserProvisioningManager provisioningManager;
    protected final UserDataBinder binder;
    protected final Map<String, OIDCC4UIProviderActions> perContextActions = new ConcurrentHashMap<String, OIDCC4UIProviderActions>();

    public OIDCUserManager(InboundMatcher inboundMatcher, UserDAO userDAO, ImplementationDAO implementationDAO, IntAttrNameParser intAttrNameParser, TemplateUtils templateUtils, UserProvisioningManager provisioningManager, UserDataBinder binder) {
        this.inboundMatcher = inboundMatcher;
        this.userDAO = userDAO;
        this.implementationDAO = implementationDAO;
        this.intAttrNameParser = intAttrNameParser;
        this.templateUtils = templateUtils;
        this.provisioningManager = provisioningManager;
        this.binder = binder;
    }

    @Transactional(readOnly=true)
    public List<String> findMatchingUser(String connObjectKeyValue, Item connObjectKeyItem) {
        return this.inboundMatcher.matchByConnObjectKeyValue(connObjectKeyItem, connObjectKeyValue, AnyTypeKind.USER, false, null).stream().filter(match -> match.getAny() != null).map(match -> ((User)match.getAny()).getUsername()).collect(Collectors.toList());
    }

    protected List<OIDCC4UIProviderActions> getActions(OIDCC4UIProvider op) {
        ArrayList<OIDCC4UIProviderActions> result = new ArrayList<OIDCC4UIProviderActions>();
        op.getActions().forEach(impl -> {
            try {
                result.add((OIDCC4UIProviderActions)ImplementationManager.build((Implementation)impl, () -> this.perContextActions.get(impl.getKey()), instance -> this.perContextActions.put(impl.getKey(), (OIDCC4UIProviderActions)instance)));
            }
            catch (Exception e) {
                LOG.warn("While building {}", impl, (Object)e);
            }
        });
        return result;
    }

    protected List<Implementation> getTransformers(Item item) {
        return item.getTransformers().stream().map(arg_0 -> ((ImplementationDAO)this.implementationDAO).find(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public void fill(OIDCC4UIProvider op, OIDCLoginResponse loginResponse, UserTO userTO) {
        op.getItems().forEach(item -> {
            block19: {
                IntAttrName intAttrName;
                ArrayList<String> values;
                block18: {
                    values = new ArrayList<String>();
                    Optional oidcAttr = loginResponse.getAttr(item.getExtAttrName());
                    if (oidcAttr.isPresent() && !((Attr)oidcAttr.get()).getValues().isEmpty()) {
                        values.addAll(((Attr)oidcAttr.get()).getValues());
                        List transformed = new ArrayList(values);
                        for (ItemTransformer transformer : MappingUtils.getItemTransformers((Item)item, this.getTransformers((Item)item))) {
                            transformed = transformer.beforePull(null, (EntityTO)userTO, transformed);
                        }
                        values.clear();
                        for (Object value : transformed) {
                            if (value == null) continue;
                            values.add(value.toString());
                        }
                    }
                    intAttrName = null;
                    try {
                        intAttrName = this.intAttrNameParser.parse(item.getIntAttrName(), AnyTypeKind.USER);
                    }
                    catch (ParseException e) {
                        LOG.error("Invalid intAttrName '{}' specified, ignoring", (Object)item.getIntAttrName(), (Object)e);
                    }
                    if (intAttrName == null || intAttrName.getField() == null) break block18;
                    switch (intAttrName.getField()) {
                        case "username": {
                            if (!values.isEmpty()) {
                                userTO.setUsername((String)values.get(0));
                                break;
                            }
                            break block19;
                        }
                        default: {
                            LOG.warn("Unsupported: {}", (Object)intAttrName.getField());
                            break;
                        }
                    }
                    break block19;
                }
                if (intAttrName != null && intAttrName.getSchemaType() != null) {
                    switch (intAttrName.getSchemaType()) {
                        case PLAIN: {
                            Optional<Attr> attr = userTO.getPlainAttr(intAttrName.getSchema().getKey());
                            if (attr.isPresent()) {
                                ((Attr)attr.get()).getValues().clear();
                            } else {
                                attr = Optional.of(new Attr.Builder(intAttrName.getSchema().getKey()).build());
                                userTO.getPlainAttrs().add(attr.get());
                            }
                            ((Attr)attr.get()).getValues().addAll(values);
                            break;
                        }
                        default: {
                            LOG.warn("Unsupported: {} {}", (Object)intAttrName.getSchemaType(), (Object)intAttrName.getSchema().getKey());
                        }
                    }
                }
            }
        });
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String create(OIDCC4UIProvider op, OIDCLoginResponse responseTO, String defaultUsername) {
        UserCR userCR = new UserCR();
        userCR.setStorePassword(false);
        if (op.getUserTemplate() != null && op.getUserTemplate().get() != null) {
            this.templateUtils.apply((RealmMember)userCR, op.getUserTemplate().get());
        }
        List<OIDCC4UIProviderActions> actions = this.getActions(op);
        for (OIDCC4UIProviderActions action : actions) {
            userCR = action.beforeCreate(userCR, responseTO);
        }
        UserTO userTO = new UserTO();
        this.fill(op, responseTO, userTO);
        EntityTOUtils.toAnyCR((AnyTO)userTO, (AnyCR)userCR);
        if (userCR.getRealm() == null) {
            userCR.setRealm("/");
        }
        if (userCR.getUsername() == null) {
            userCR.setUsername(defaultUsername);
        }
        Pair created = this.provisioningManager.create((AnyCR)userCR, false, userCR.getUsername(), OIDC_CLIENT_CONTEXT);
        userTO = this.binder.getUserTO((String)created.getKey());
        for (OIDCC4UIProviderActions action : actions) {
            userTO = action.afterCreate(userTO, responseTO);
        }
        return userTO.getUsername();
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public String update(String username, OIDCC4UIProvider op, OIDCLoginResponse responseTO) {
        UserTO userTO = this.binder.getUserTO(this.userDAO.findKey(username));
        UserTO original = (UserTO)SerializationUtils.clone((Serializable)userTO);
        this.fill(op, responseTO, userTO);
        UserUR userUR = AnyOperations.diff((UserTO)userTO, (UserTO)original, (boolean)true);
        List<OIDCC4UIProviderActions> actions = this.getActions(op);
        for (OIDCC4UIProviderActions action : actions) {
            userUR = action.beforeUpdate(userUR, responseTO);
        }
        Pair updated = this.provisioningManager.update(userUR, false, userTO.getUsername(), OIDC_CLIENT_CONTEXT);
        userTO = this.binder.getUserTO(((UserUR)updated.getLeft()).getKey());
        for (OIDCC4UIProviderActions action : actions) {
            userTO = action.afterUpdate(userTO, responseTO);
        }
        return userTO.getUsername();
    }
}

