/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.OIDCC4UIProviderTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.logic.oidc.OIDCClientCache;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.OIDCC4UIProviderDAO;
import org.apache.syncope.core.persistence.api.entity.OIDCC4UIProvider;
import org.apache.syncope.core.provisioning.api.data.OIDCC4UIProviderDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class OIDCC4UIProviderLogic
extends AbstractTransactionalLogic<OIDCC4UIProviderTO> {
    protected final OIDCClientCache oidcClientClientCache;
    protected final OIDCC4UIProviderDAO opDAO;
    protected final OIDCC4UIProviderDataBinder binder;

    public OIDCC4UIProviderLogic(OIDCClientCache oidcClientClientCache, OIDCC4UIProviderDAO opDAO, OIDCC4UIProviderDataBinder binder) {
        this.oidcClientClientCache = oidcClientClientCache;
        this.opDAO = opDAO;
        this.binder = binder;
    }

    @PreAuthorize(value="hasRole('OP_CREATE')")
    public String createFromDiscovery(OIDCC4UIProviderTO opTO) {
        OIDCClientCache.importMetadata(opTO);
        return this.create(opTO);
    }

    @PreAuthorize(value="hasRole('OP_CREATE')")
    public String create(OIDCC4UIProviderTO opTO) {
        if (opTO.getConnObjectKeyItem() == null) {
            Item connObjectKeyItem = new Item();
            connObjectKeyItem.setIntAttrName("username");
            connObjectKeyItem.setExtAttrName("email");
            opTO.setConnObjectKeyItem(connObjectKeyItem);
        }
        OIDCC4UIProvider provider = this.binder.create(opTO);
        return provider.getKey();
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public List<OIDCC4UIProviderTO> list() {
        return this.opDAO.findAll().stream().map(arg_0 -> ((OIDCC4UIProviderDataBinder)this.binder).getOIDCProviderTO(arg_0)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('OP_READ')")
    @Transactional(readOnly=true)
    public OIDCC4UIProviderTO read(String key) {
        OIDCC4UIProvider op = this.opDAO.find(key);
        if (op == null) {
            throw new NotFoundException("OIDC Provider '" + key + "'");
        }
        return this.binder.getOIDCProviderTO(op);
    }

    @PreAuthorize(value="hasRole('OP_UPDATE')")
    public void update(OIDCC4UIProviderTO opTO) {
        OIDCC4UIProvider op = this.opDAO.find(opTO.getKey());
        if (op == null) {
            throw new NotFoundException("OIDC Provider '" + opTO.getKey() + "'");
        }
        if (!op.getIssuer().equals(opTO.getIssuer())) {
            LOG.error("Issuers do not match: expected {}, found {}", (Object)op.getIssuer(), (Object)opTO.getIssuer());
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidEntity);
            sce.getElements().add("Issuers do not match");
            throw sce;
        }
        String opName = op.getName();
        this.binder.update(op, opTO);
        this.oidcClientClientCache.removeAll(opName);
    }

    @PreAuthorize(value="hasRole('OP_DELETE')")
    public void delete(String key) {
        OIDCC4UIProvider op = this.opDAO.find(key);
        if (op == null) {
            throw new NotFoundException("OIDC Provider '" + key + "'");
        }
        String opName = op.getName();
        this.opDAO.delete(key);
        this.oidcClientClientCache.removeAll(opName);
    }

    protected OIDCC4UIProviderTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof OIDCC4UIProviderTO)) continue;
                key = ((OIDCC4UIProviderTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getOIDCProviderTO(this.opDAO.find(key));
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

