/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.panels.SAML2IdPsDirectoryPanel;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.SAML2IdPsRestClient;
import org.apache.syncope.client.console.wizards.mapping.ItemTransformersTogglePanel;
import org.apache.syncope.client.console.wizards.mapping.JEXLTransformersTogglePanel;
import org.apache.syncope.client.console.wizards.mapping.SAML2IdPMappingPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizardBuilder;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.SAML2SP4UIIdPTO;
import org.apache.syncope.common.lib.types.SAML2BindingType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.model.util.ListModel;

public class SAML2IdPWizardBuilder
extends AjaxWizardBuilder<SAML2SP4UIIdPTO> {
    private static final long serialVersionUID = 5952696913893950460L;
    private final SAML2IdPsDirectoryPanel directoryPanel;
    private final IModel<List<String>> idpActions = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected List<String> load() {
            return ImplementationRestClient.list((String)"IDP_ACTIONS").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
        }
    };
    private final IModel<List<String>> requestedAuthnContextProviders = new LoadableDetachableModel<List<String>>(){
        private static final long serialVersionUID = 4659376149825914247L;

        protected List<String> load() {
            return ImplementationRestClient.list((String)"REQUESTED_AUTHN_CONTEXT_PROVIDER").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
        }
    };

    public SAML2IdPWizardBuilder(SAML2IdPsDirectoryPanel directoryPanel, SAML2SP4UIIdPTO idpTO, PageReference pageRef) {
        super((Serializable)idpTO, pageRef);
        this.directoryPanel = directoryPanel;
    }

    protected WizardModel buildModelSteps(SAML2SP4UIIdPTO modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new IdP(modelObject));
        Mapping mapping = new Mapping();
        mapping.setOutputMarkupId(true);
        ItemTransformersTogglePanel mapItemTransformers = new ItemTransformersTogglePanel((WebMarkupContainer)mapping, this.pageRef);
        this.addOuterObject(new Component[]{mapItemTransformers});
        JEXLTransformersTogglePanel jexlTransformers = new JEXLTransformersTogglePanel((WebMarkupContainer)mapping, this.pageRef);
        this.addOuterObject(new Component[]{jexlTransformers});
        mapping.add(new Component[]{new SAML2IdPMappingPanel("mapping", modelObject, mapItemTransformers, jexlTransformers)});
        wizardModel.add((IWizardStep)mapping);
        return wizardModel;
    }

    protected long getMaxWaitTimeInSeconds() {
        return SyncopeWebApplication.get().getMaxWaitTimeInSeconds();
    }

    protected void sendError(Exception exception) {
        SyncopeConsoleSession.get().onException(exception);
    }

    protected void sendWarning(String message) {
        SyncopeConsoleSession.get().warn((Serializable)((Object)message));
    }

    protected Future<Pair<Serializable, Serializable>> execute(Callable<Pair<Serializable, Serializable>> future) {
        return SyncopeConsoleSession.get().execute(future);
    }

    protected Serializable onApplyInternal(SAML2SP4UIIdPTO modelObject) {
        long connObjectKeyCount = modelObject.getItems().stream().filter(Item::isConnObjectKey).count();
        if (connObjectKeyCount != 1L) {
            throw new IllegalArgumentException(new StringResourceModel("connObjectKeyValidation", (Component)this.directoryPanel).getString());
        }
        SAML2IdPsRestClient.update(modelObject);
        return modelObject;
    }

    private static final class Mapping
    extends WizardStep {
        private static final long serialVersionUID = 3454904947720856253L;

        Mapping() {
            this.setTitleModel((IModel)Model.of((Serializable)((Object)"Mapping")));
            this.setSummaryModel((IModel)Model.of((Serializable)((Object)"")));
        }
    }

    private final class IdP
    extends WizardStep {
        private static final long serialVersionUID = 854012593185195024L;

        IdP(SAML2SP4UIIdPTO idpTO) {
            super("", "");
            ArrayList<Object> fields = new ArrayList<Object>();
            AjaxTextFieldPanel name = new AjaxTextFieldPanel("field", "name", (IModel)new PropertyModel((Object)idpTO, "name"), false);
            name.setRequired(true);
            fields.add(name);
            AjaxCheckBoxPanel createUnmatching = new AjaxCheckBoxPanel("field", "createUnmatching", (IModel)new PropertyModel((Object)idpTO, "createUnmatching"), false);
            fields.add(createUnmatching);
            AjaxCheckBoxPanel selfRegUnmatching = new AjaxCheckBoxPanel("field", "selfRegUnmatching", (IModel)new PropertyModel((Object)idpTO, "selfRegUnmatching"), false);
            fields.add(selfRegUnmatching);
            AjaxCheckBoxPanel updateMatching = new AjaxCheckBoxPanel("field", "updateMatching", (IModel)new PropertyModel((Object)idpTO, "updateMatching"), false);
            fields.add(updateMatching);
            AjaxDropDownChoicePanel bindingType = new AjaxDropDownChoicePanel("field", "bindingType", (IModel)new PropertyModel((Object)idpTO, "bindingType"), false);
            bindingType.setChoices(List.of(SAML2BindingType.values()));
            fields.add(bindingType);
            AjaxTextFieldPanel requestedAuthnContextProvider = new AjaxTextFieldPanel("field", "requestedAuthnContextProvider", (IModel)new PropertyModel((Object)idpTO, "requestedAuthnContextProvider"));
            requestedAuthnContextProvider.setChoices((List)SAML2IdPWizardBuilder.this.requestedAuthnContextProviders.getObject());
            fields.add(requestedAuthnContextProvider);
            AjaxPalettePanel actions = new AjaxPalettePanel.Builder().setAllowMoveAll(true).setAllowOrder(true).setName(new StringResourceModel("actions", (Component)SAML2IdPWizardBuilder.this.directoryPanel).getString()).build("field", (IModel)new PropertyModel((Object)idpTO, "actions"), (IModel)new ListModel((List)SAML2IdPWizardBuilder.this.idpActions.getObject()));
            actions.setOutputMarkupId(true);
            fields.add(actions);
            this.add(new Component[]{new ListView<Component>("fields", fields){
                private static final long serialVersionUID = -9180479401817023838L;

                protected void populateItem(ListItem<Component> item) {
                    item.add(new Component[]{(Component)item.getModelObject()});
                }
            }});
        }
    }
}

