/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.googleapps;

import com.google.api.services.admin.directory.Directory;
import com.google.api.services.admin.directory.model.OrgUnit;
import java.io.IOException;
import java.util.Set;
import net.tirasa.connid.bundles.googleapps.GoogleAppsConnector;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.exceptions.InvalidAttributeValueException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.PredefinedAttributeInfos;
import org.identityconnectors.framework.common.objects.PredefinedAttributes;
import org.identityconnectors.framework.common.objects.Uid;

public class OrgunitsHandler {
    private static final Log LOG = Log.getLog(OrgunitsHandler.class);

    public static ObjectClassInfo getOrgunitClassInfo() {
        ObjectClassInfoBuilder builder = new ObjectClassInfoBuilder();
        builder.setType(GoogleAppsConnector.ORG_UNIT.getObjectClassValue());
        builder.setContainer(true);
        builder.addAttributeInfo(Name.INFO);
        builder.addAttributeInfo(AttributeInfoBuilder.define((String)"parentOrgUnitPath").setRequired(true).build());
        builder.addAttributeInfo(PredefinedAttributeInfos.DESCRIPTION);
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"orgUnitPath"));
        builder.addAttributeInfo(AttributeInfoBuilder.build((String)"blockInheritance", Boolean.class));
        return builder.build();
    }

    public static Directory.Orgunits.Insert createOrgunit(Directory.Orgunits service, AttributesAccessor attributes) {
        OrgUnit resource = new OrgUnit();
        resource.setParentOrgUnitPath(OrgunitsHandler.getParentOrgUnitPath(attributes));
        resource.setName(OrgunitsHandler.getOrgUnitNameFromPath(attributes.getName()));
        resource.setBlockInheritance(attributes.findBoolean("blockInheritance"));
        resource.setDescription(attributes.findString(PredefinedAttributes.DESCRIPTION));
        try {
            return service.insert("my_customer", resource).setFields("orgUnitPath,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Groups#Insert", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static Directory.Orgunits.Patch updateOrgunit(Directory.Orgunits service, String orgUnitPath, AttributesAccessor attributes) {
        Attribute blockInheritance;
        Attribute description;
        String parentOrgUnitPath;
        OrgUnit resource = null;
        String orgUnitName = OrgunitsHandler.getOrgUnitNameFromPath(attributes.getName());
        if (null != orgUnitName) {
            resource = new OrgUnit();
            resource.setName(orgUnitName);
        }
        if (null != (parentOrgUnitPath = OrgunitsHandler.getParentOrgUnitPath(attributes))) {
            if (null == resource) {
                resource = new OrgUnit();
            }
            resource.setParentOrgUnitPath(parentOrgUnitPath);
        }
        if (null != (description = attributes.find(PredefinedAttributes.DESCRIPTION))) {
            String stringValue;
            if (null == resource) {
                resource = new OrgUnit();
            }
            if (null == (stringValue = AttributeUtil.getStringValue((Attribute)description))) {
                stringValue = "";
            }
            resource.setDescription(stringValue);
        }
        if (null != (blockInheritance = attributes.find("blockInheritance"))) {
            Boolean booleanValue;
            if (null == resource) {
                resource = new OrgUnit();
            }
            if (null == (booleanValue = AttributeUtil.getBooleanValue((Attribute)blockInheritance))) {
                booleanValue = Boolean.FALSE;
            }
            resource.setBlockInheritance(booleanValue);
        }
        if (null == resource) {
            return null;
        }
        try {
            return service.patch("my_customer", CollectionUtil.newList((Object[])new String[]{orgUnitPath}), resource).setFields("orgUnitPath,etag");
        }
        catch (IOException e) {
            LOG.warn((Throwable)e, "Failed to initialize Orgunits#Patch", new Object[0]);
            throw ConnectorException.wrap((Throwable)e);
        }
    }

    public static ConnectorObject fromOrgunit(OrgUnit content, Set<String> attributesToGet) {
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(GoogleAppsConnector.ORG_UNIT);
        builder.setUid(OrgunitsHandler.generateOrgUnitId(content));
        builder.setName(content.getName());
        if (null == attributesToGet || attributesToGet.contains(PredefinedAttributes.DESCRIPTION)) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)PredefinedAttributes.DESCRIPTION, (Object[])new Object[]{content.getDescription()})});
        }
        if (null == attributesToGet || attributesToGet.contains("orgUnitPath")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"orgUnitPath", (Object[])new Object[]{content.getOrgUnitPath()})});
        }
        if (null == attributesToGet || attributesToGet.contains("parentOrgUnitPath")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"parentOrgUnitPath", (Object[])new Object[]{content.getParentOrgUnitPath()})});
        }
        if (null == attributesToGet || attributesToGet.contains("blockInheritance")) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.build((String)"blockInheritance", (Object[])new Object[]{content.getBlockInheritance()})});
        }
        return builder.build();
    }

    private static String getParentOrgUnitPath(AttributesAccessor attributes) {
        String parentOrgUnitPath = attributes.findString("parentOrgUnitPath");
        if (StringUtil.isNotBlank((String)parentOrgUnitPath) && parentOrgUnitPath.charAt(0) != '/') {
            parentOrgUnitPath = "/" + parentOrgUnitPath;
        }
        if (parentOrgUnitPath.isEmpty()) {
            throw new InvalidAttributeValueException("Missing required attribute 'parentOrgUnitPath'. The organization unit's parent path. Required when creating an orgunit.");
        }
        return parentOrgUnitPath;
    }

    private static String getOrgUnitNameFromPath(Name name) {
        if (null == name) {
            return null;
        }
        String fullName = name.getNameValue();
        String[] elements = fullName.split("/");
        if (elements.length == 0) {
            return fullName;
        }
        return elements[elements.length - 1];
    }

    public static Uid generateOrgUnitId(OrgUnit content) {
        String orgUnitPath = content.getOrgUnitPath();
        if (orgUnitPath.startsWith("/")) {
            orgUnitPath = orgUnitPath.substring(1);
        }
        Uid uid = null != content.getEtag() ? new Uid(orgUnitPath, content.getEtag()) : new Uid(orgUnitPath);
        return uid;
    }
}

