/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.commons.GroupHelper;
import net.tirasa.connid.bundles.ldap.commons.LdapConstants;
import net.tirasa.connid.bundles.ldap.commons.LdapEntry;
import net.tirasa.connid.bundles.ldap.commons.LdapUtil;
import net.tirasa.connid.bundles.ldap.commons.StatusManagement;
import net.tirasa.connid.bundles.ldap.schema.LdapSchemaMapping;
import net.tirasa.connid.bundles.ldap.search.LdapFilter;
import net.tirasa.connid.bundles.ldap.search.LdapInternalSearch;
import net.tirasa.connid.bundles.ldap.search.LdapSearchResultsHandler;
import net.tirasa.connid.bundles.ldap.search.LdapSearchStrategy;
import net.tirasa.connid.bundles.ldap.search.LdapSearches;
import net.tirasa.connid.bundles.ldap.search.PagedSearchStrategy;
import net.tirasa.connid.bundles.ldap.search.VlvIndexSearchStrategy;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.QualifiedUid;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.spi.SearchResultsHandler;

public class LdapSearch {
    private static final Log LOG = Log.getLog(LdapSearch.class);
    private final LdapConnection conn;
    private final ObjectClass oclass;
    private final LdapFilter filter;
    private final OperationOptions options;
    private final GroupHelper groupHelper;
    private final String[] baseDNs;
    private final ResultsHandler handler;

    public static Set<String> getAttributesReturnedByDefault(LdapConnection conn, ObjectClass oclass) {
        if (oclass.equals((Object)LdapSchemaMapping.ANY_OBJECT_CLASS)) {
            return CollectionUtil.newSet((Object[])new String[]{Name.NAME});
        }
        SortedSet result = CollectionUtil.newCaseInsensitiveSet();
        ObjectClassInfo oci = conn.getSchemaMapping().schema().findObjectClassInfo(oclass.getObjectClassValue());
        if (oci != null) {
            for (AttributeInfo info : oci.getAttributeInfo()) {
                if (!info.isReturnedByDefault()) continue;
                result.add(info.getName());
            }
        }
        return result;
    }

    public LdapSearch(LdapConnection conn, ObjectClass oclass, LdapFilter filter, ResultsHandler handler, OperationOptions options) {
        this(conn, oclass, filter, handler, options, conn.getConfiguration().getBaseContexts());
    }

    public LdapSearch(LdapConnection conn, ObjectClass oclass, LdapFilter filter, ResultsHandler handler, OperationOptions options, String ... baseDNs) {
        this.conn = conn;
        this.oclass = oclass;
        this.filter = filter;
        this.options = options;
        this.baseDNs = baseDNs;
        this.groupHelper = new GroupHelper(conn);
        this.handler = handler;
    }

    public final void execute() {
        final String[] attrsToGetOption = this.options.getAttributesToGet();
        final Set<String> attrsToGet = this.getAttributesToGet(attrsToGetOption);
        LdapInternalSearch search = this.getInternalSearch(attrsToGet);
        search.execute(new LdapSearchResultsHandler(){

            @Override
            public boolean handle(String baseDN, SearchResult result) throws NamingException {
                return LdapSearch.this.handler.handle(LdapSearch.this.createConnectorObject(baseDN, result, attrsToGet, attrsToGetOption != null));
            }
        });
    }

    public final ConnectorObject getSingleResult() {
        final String[] attrsToGetOption = this.options.getAttributesToGet();
        final Set<String> attrsToGet = this.getAttributesToGet(attrsToGetOption);
        final ConnectorObject[] results = new ConnectorObject[]{null};
        LdapInternalSearch search = this.getInternalSearch(attrsToGet);
        search.execute(new LdapSearchResultsHandler(){

            @Override
            public boolean handle(String baseDN, SearchResult result) throws NamingException {
                results[0] = LdapSearch.this.createConnectorObject(baseDN, result, attrsToGet, attrsToGetOption != null);
                return false;
            }
        });
        return results[0];
    }

    private LdapInternalSearch getInternalSearch(Set<String> attrsToGet) {
        int searchScope;
        List<String> dns;
        LdapSearchStrategy strategy;
        String filterEntryDN;
        String string = filterEntryDN = this.filter == null ? null : this.filter.getEntryDN();
        if (filterEntryDN == null) {
            strategy = this.getSearchStrategy();
            dns = this.getBaseDNs();
            searchScope = this.getLdapSearchScope();
        } else {
            strategy = this.conn.getConfiguration().newDefaultSearchStrategy(true);
            dns = Collections.singletonList(filterEntryDN);
            searchScope = 0;
        }
        SearchControls controls = LdapInternalSearch.createDefaultSearchControls();
        Set<String> ldapAttrsToGet = this.getLdapAttributesToGet(attrsToGet);
        controls.setReturningAttributes(ldapAttrsToGet.toArray(new String[ldapAttrsToGet.size()]));
        controls.setSearchScope(searchScope);
        String optionsFilter = LdapConstants.getSearchFilter(this.options);
        String searchFilter = null;
        if (this.oclass.equals((Object)ObjectClass.ACCOUNT)) {
            searchFilter = this.conn.getConfiguration().getAccountSearchFilter();
        } else if (this.oclass.equals((Object)ObjectClass.GROUP)) {
            searchFilter = this.conn.getConfiguration().getGroupSearchFilter();
        }
        String nativeFilter = this.filter == null ? null : this.filter.getNativeFilter();
        return new LdapInternalSearch(this.conn, this.getSearchFilter(optionsFilter, nativeFilter, searchFilter), dns, strategy, controls);
    }

    private Set<String> getLdapAttributesToGet(Set<String> attrsToGet) {
        SortedSet cleanAttrsToGet = CollectionUtil.newCaseInsensitiveSet();
        cleanAttrsToGet.addAll(attrsToGet);
        cleanAttrsToGet.remove("ldapGroups");
        boolean posixGroups = cleanAttrsToGet.remove("posixGroups");
        Set<String> result = this.conn.getSchemaMapping().getLdapAttributes(this.oclass, cleanAttrsToGet, true);
        if (posixGroups) {
            result.add(GroupHelper.getPosixRefAttribute());
        }
        result.addAll(StatusManagement.getInstance(this.conn.getConfiguration().getStatusManagementClass()).getOperationalAttributes());
        result.removeAll(LdapEntry.ENTRY_DN_ATTRS);
        return result;
    }

    private ConnectorObject createConnectorObject(String baseDN, SearchResult result, Set<String> attrsToGet, boolean emptyAttrWhenNotFound) {
        LdapEntry entry = LdapEntry.create(baseDN, result);
        ConnectorObjectBuilder builder = new ConnectorObjectBuilder();
        builder.setObjectClass(this.oclass);
        builder.setUid(this.conn.getSchemaMapping().createUid(this.oclass, entry));
        builder.setName(this.conn.getSchemaMapping().createName(this.oclass, entry));
        ArrayList<String> ldapGroups = new ArrayList<String>();
        ArrayList<String> posixGroups = new ArrayList<String>();
        for (String attrName : attrsToGet) {
            Attribute attribute;
            if (LdapConstants.isLdapGroups(attrName)) {
                ldapGroups.addAll(this.groupHelper.getLdapGroups(entry.getDN().toString()));
                attribute = AttributeBuilder.build((String)"ldapGroups", ldapGroups);
            } else if (LdapConstants.isPosixGroups(attrName)) {
                Set<String> posixRefAttrs = LdapUtil.getStringAttrValues(entry.getAttributes(), GroupHelper.getPosixRefAttribute());
                posixGroups.addAll(this.groupHelper.getPosixGroups(posixRefAttrs));
                attribute = AttributeBuilder.build((String)"posixGroups", posixGroups);
            } else {
                attribute = LdapConstants.PASSWORD.is(attrName) && !this.conn.getConfiguration().getRetrievePasswordsWithSearch() ? AttributeBuilder.build((String)attrName, (Object[])new Object[]{new GuardedString()}) : this.conn.getSchemaMapping().createAttribute(this.oclass, attrName, entry, emptyAttrWhenNotFound);
            }
            if (attribute == null) continue;
            builder.addAttribute(new Attribute[]{attribute});
        }
        Boolean status = StatusManagement.getInstance(this.conn.getConfiguration().getStatusManagementClass()).getStatus(result.getAttributes(), posixGroups, ldapGroups);
        if (status != null) {
            builder.addAttribute(new Attribute[]{AttributeBuilder.buildEnabled((boolean)status)});
        }
        return builder.build();
    }

    private String getSearchFilter(String ... optionalFilters) {
        StringBuilder builder = new StringBuilder();
        String ocFilter = this.getObjectClassFilter();
        int nonBlank = StringUtil.isBlank((String)ocFilter) ? 0 : 1;
        for (String optionalFilter : optionalFilters) {
            nonBlank += StringUtil.isBlank((String)optionalFilter) ? 0 : 1;
        }
        if (nonBlank > 1) {
            builder.append("(&");
        }
        LdapSearch.appendFilter(ocFilter, builder);
        for (String optionalFilter : optionalFilters) {
            LdapSearch.appendFilter(optionalFilter, builder);
        }
        if (nonBlank > 1) {
            builder.append(')');
        }
        return builder.toString();
    }

    private String getObjectClassFilter() {
        boolean and;
        StringBuilder builder = new StringBuilder();
        List<String> ldapClasses = this.conn.getSchemaMapping().getLdapClasses(this.oclass);
        boolean bl = and = ldapClasses.size() > 1;
        if (and) {
            builder.append("(&");
        }
        for (String ldapClass : ldapClasses) {
            builder.append("(objectClass=");
            builder.append(ldapClass);
            builder.append(')');
        }
        if (and) {
            builder.append(')');
        }
        return builder.toString();
    }

    private static void appendFilter(String filter, StringBuilder toBuilder) {
        if (!StringUtil.isBlank((String)filter)) {
            boolean enclose;
            String trimmedUserFilter = filter.trim();
            boolean bl = enclose = filter.charAt(0) != '(';
            if (enclose) {
                toBuilder.append('(');
            }
            toBuilder.append(trimmedUserFilter);
            if (enclose) {
                toBuilder.append(')');
            }
        }
    }

    private List<String> getBaseDNs() {
        QualifiedUid container = this.options.getContainer();
        List<String> result = container != null ? Collections.singletonList(LdapSearches.findEntryDN(this.conn, container.getObjectClass(), container.getUid())) : Arrays.asList(this.baseDNs);
        assert (result != null);
        return result;
    }

    private LdapSearchStrategy getSearchStrategy() {
        LdapSearchStrategy result = this.conn.getConfiguration().newDefaultSearchStrategy(false);
        if (this.options.getPageSize() != null) {
            if (this.conn.getConfiguration().isUseVlvControls() && this.conn.supportsControl("2.16.840.1.113730.3.4.9")) {
                String vlvSortAttr = this.conn.getConfiguration().getVlvSortAttribute();
                result = new VlvIndexSearchStrategy(vlvSortAttr, this.options.getPageSize());
            } else if (this.conn.supportsControl("1.2.840.113556.1.4.319")) {
                result = new PagedSearchStrategy(this.options.getPageSize(), this.options.getPagedResultsCookie(), this.options.getPagedResultsOffset(), this.handler instanceof SearchResultsHandler ? (SearchResultsHandler)this.handler : null, this.options.getSortKeys());
            }
        }
        return result;
    }

    private Set<String> getAttributesToGet(String[] attributesToGet) {
        Set<Object> result;
        if (attributesToGet != null) {
            result = CollectionUtil.newCaseInsensitiveSet();
            result.addAll(Arrays.asList(attributesToGet));
            this.removeNonReadableAttributes(result);
            result.add(Name.NAME);
        } else {
            result = LdapSearch.getAttributesReturnedByDefault(this.conn, this.oclass);
        }
        result.add(Uid.NAME);
        if (!this.conn.getConfiguration().getRetrievePasswordsWithSearch() && result.contains(OperationalAttributes.PASSWORD_NAME)) {
            LOG.warn("Reading passwords not supported", new Object[0]);
        }
        return result;
    }

    private void removeNonReadableAttributes(Set<String> attributes) {
        boolean ldapGroups = attributes.remove("ldapGroups");
        boolean posixGroups = attributes.remove("posixGroups");
        this.conn.getSchemaMapping().removeNonReadableAttributes(this.oclass, attributes);
        if (ldapGroups) {
            attributes.add("ldapGroups");
        }
        if (posixGroups) {
            attributes.add("posixGroups");
        }
    }

    private int getLdapSearchScope() {
        String scope = this.options.getScope();
        if ("object".equals(scope)) {
            return 0;
        }
        if ("onelevel".equals(scope)) {
            return 1;
        }
        if ("subtree".equals(scope) || scope == null) {
            return 2;
        }
        throw new IllegalArgumentException("Invalid search scope " + scope);
    }
}

