/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.subject;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.enc.SamlIdPObjectEncrypter;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.EncryptedID;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlProfileSamlSubjectBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<Subject> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlSubjectBuilder.class);
    private static final long serialVersionUID = 4782621942035583007L;
    private final SamlProfileObjectBuilder<SAMLObject> ssoPostProfileSamlNameIdBuilder;
    private final CasConfigurationProperties casProperties;
    private final transient SamlIdPObjectEncrypter samlObjectEncrypter;

    public SamlProfileSamlSubjectBuilder(OpenSamlConfigBean configBean, SamlProfileObjectBuilder<SAMLObject> ssoPostProfileSamlNameIdBuilder, CasConfigurationProperties casProperties, SamlIdPObjectEncrypter samlObjectEncrypter) {
        super(configBean);
        this.ssoPostProfileSamlNameIdBuilder = ssoPostProfileSamlNameIdBuilder;
        this.samlObjectEncrypter = samlObjectEncrypter;
        this.casProperties = casProperties;
    }

    @Override
    public Subject build(SamlProfileBuilderContext context) throws Exception {
        return this.buildSubject(context);
    }

    private Subject buildSubject(SamlProfileBuilderContext context) throws Exception {
        SAMLObject subjectConfNameId;
        ZonedDateTime validFromDate = ZonedDateTime.now(ZoneOffset.UTC);
        LOGGER.trace("Locating the assertion consumer service url for binding [{}]", (Object)context.getBinding());
        Endpoint acs = SamlIdPUtils.determineEndpointForRequest((Pair)Pair.of((Object)context.getSamlRequest(), (Object)context.getMessageContext()), (SamlRegisteredServiceServiceProviderMetadataFacade)context.getAdaptor(), (String)context.getBinding());
        String location = StringUtils.isBlank((CharSequence)acs.getResponseLocation()) ? acs.getLocation() : acs.getResponseLocation();
        SAMLObject subjectNameId = this.getNameIdForService(context);
        SAMLObject sAMLObject = subjectConfNameId = context.getRegisteredService().isSkipGeneratingSubjectConfirmationNameId() ? null : this.getNameIdForService(context);
        ZonedDateTime notOnOrAfter = context.getRegisteredService().isSkipGeneratingSubjectConfirmationNotOnOrAfter() ? null : validFromDate.plusSeconds(context.getRegisteredService().getSkewAllowance() > 0 ? (long)context.getRegisteredService().getSkewAllowance() : Beans.newDuration((String)this.casProperties.getAuthn().getSamlIdp().getResponse().getSkewAllowance()).toSeconds());
        SAMLObject finalSubjectNameId = this.encryptNameIdIfNecessary(subjectNameId, context);
        SAMLObject finalSubjectConfigNameId = this.encryptNameIdIfNecessary(subjectConfNameId, context);
        Subject subject = this.newSubject(finalSubjectNameId, finalSubjectConfigNameId, context.getRegisteredService().isSkipGeneratingSubjectConfirmationRecipient() ? null : location, notOnOrAfter, context.getRegisteredService().isSkipGeneratingSubjectConfirmationInResponseTo() ? null : context.getSamlRequest().getID(), context.getRegisteredService().isSkipGeneratingSubjectConfirmationNotBefore() ? null : ZonedDateTime.now(ZoneOffset.UTC));
        LOGGER.debug("Created SAML subject [{}]", (Object)subject);
        return subject;
    }

    private SAMLObject getNameIdForService(SamlProfileBuilderContext context) throws Exception {
        if (context.getRegisteredService().isSkipGeneratingAssertionNameId()) {
            LOGGER.warn("Assertion will skip assigning/generating a nameId based on service [{}]", (Object)context.getRegisteredService());
            return null;
        }
        return this.ssoPostProfileSamlNameIdBuilder.build(context);
    }

    private SAMLObject encryptNameIdIfNecessary(SAMLObject subjectNameId, SamlProfileBuilderContext context) {
        if (!(subjectNameId instanceof EncryptedID) && subjectNameId instanceof NameID && "urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted".equalsIgnoreCase(((NameID)subjectNameId).getFormat())) {
            return this.samlObjectEncrypter.encode((NameID)subjectNameId, context.getRegisteredService(), context.getAdaptor());
        }
        return subjectNameId;
    }
}

