/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.builders.authn;

import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.util.AbstractSaml20ObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileObjectBuilder;
import org.apereo.cas.support.saml.web.idp.profile.builders.authn.SamlProfileAuthnContextClassRefBuilder;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.SubjectLocality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlProfileSamlAuthNStatementBuilder
extends AbstractSaml20ObjectBuilder
implements SamlProfileObjectBuilder<AuthnStatement> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlProfileSamlAuthNStatementBuilder.class);
    private static final long serialVersionUID = 8761566449790497226L;
    private final SamlProfileAuthnContextClassRefBuilder authnContextClassRefBuilder;
    private final CasConfigurationProperties casProperties;

    public SamlProfileSamlAuthNStatementBuilder(OpenSamlConfigBean configBean, SamlProfileAuthnContextClassRefBuilder authnContextClassRefBuilder, CasConfigurationProperties casProperties) {
        super(configBean);
        this.authnContextClassRefBuilder = authnContextClassRefBuilder;
        this.casProperties = casProperties;
    }

    @Override
    public AuthnStatement build(SamlProfileBuilderContext context) throws Exception {
        return this.buildAuthnStatement(context);
    }

    protected SubjectLocality buildSubjectLocality(SamlProfileBuilderContext context) throws SamlException {
        SubjectLocality subjectLocality = (SubjectLocality)SamlUtils.newSamlObject(SubjectLocality.class);
        String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)context.getSamlRequest());
        String clientRemoteIpAddr = Optional.ofNullable(ClientInfoHolder.getClientInfo()).map(ClientInfo::getClientIpAddress).orElse("");
        String hostAddress = StringUtils.defaultString((String)context.getRegisteredService().getSubjectLocality(), (String)clientRemoteIpAddr);
        LOGGER.debug("Built SAML2 subject locality address [{}] for [{}]", (Object)hostAddress, (Object)issuer);
        subjectLocality.setAddress(hostAddress);
        return subjectLocality;
    }

    private AuthnStatement buildAuthnStatement(SamlProfileBuilderContext context) throws Exception {
        String authenticationMethod = this.authnContextClassRefBuilder.build(context);
        Object id = Optional.ofNullable(context.getHttpRequest()).map(request -> request.getParameter("ticket")).filter(StringUtils::isNotBlank).orElse("");
        if (StringUtils.isBlank((CharSequence)id)) {
            LOGGER.info("Unable to locate service ticket as the session index; Generating random identifier instead...");
            id = "_" + String.valueOf(RandomUtils.nextLong());
        }
        AuthnStatement statement = this.newAuthnStatement(authenticationMethod, DateTimeUtils.zonedDateTimeOf((TemporalAccessor)context.getAuthenticatedAssertion().getAuthenticationDate()), (String)id);
        ZonedDateTime dt = DateTimeUtils.zonedDateTimeOf((TemporalAccessor)context.getAuthenticatedAssertion().getValidUntilDate());
        long skewAllowance = context.getRegisteredService().getSkewAllowance() > 0 ? (long)context.getRegisteredService().getSkewAllowance() : Beans.newDuration((String)this.casProperties.getAuthn().getSamlIdp().getResponse().getSkewAllowance()).toSeconds();
        statement.setSessionNotOnOrAfter(dt.plusSeconds(skewAllowance).toInstant());
        SubjectLocality subjectLocality = this.buildSubjectLocality(context);
        if (subjectLocality != null) {
            statement.setSubjectLocality(subjectLocality);
        }
        return statement;
    }
}

