/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile;

import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.net.URLBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditableContext;
import org.apereo.cas.audit.AuditableExecutionResult;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.PrincipalException;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPCoreProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlIdPUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceServiceProviderMetadataFacade;
import org.apereo.cas.support.saml.services.idp.metadata.cache.SamlRegisteredServiceCachingMetadataResolver;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.AuthenticatedAssertionContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.ServiceTicketFactory;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketValidator;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.DigestUtils;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.web.BrowserSessionStorage;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;
import org.apereo.cas.web.flow.SingleSignOnParticipationStrategy;
import org.apereo.cas.web.support.WebUtils;
import org.jooq.lambda.fi.util.function.CheckedSupplier;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXMLMessageDecoder;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.BindingDescriptor;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPSOAP11Decoder;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public abstract class AbstractSamlIdPProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSamlIdPProfileHandlerController.class);
    @Generated
    private final Object $lock = new Object[0];
    protected final SamlProfileHandlerConfigurationContext configurationContext;

    protected static void logCasValidationAssertion(TicketValidator.ValidationResult assertion) {
        LOGGER.debug("CAS Assertion Principal: [{}]", (Object)assertion.getPrincipal());
        LOGGER.debug("CAS Assertion Authentication Attributes: [{}]", (Object)assertion.getAttributes());
        LOGGER.debug("CAS Assertion Service: [{}]", (Object)assertion.getService());
    }

    protected static MessageContext bindRelayStateParameter(HttpServletRequest request, HttpServletResponse response, org.apache.commons.lang3.tuple.Pair<? extends RequestAbstractType, MessageContext> authnContext, String relayState) {
        MessageContext messageContext = (MessageContext)authnContext.getValue();
        LOGGER.trace("Relay state is [{}]", (Object)relayState);
        SAMLBindingSupport.setRelayState((MessageContext)messageContext, (String)relayState);
        return messageContext;
    }

    @ExceptionHandler(value={PrincipalException.class, UnauthorizedServiceException.class, SamlException.class})
    public ModelAndView handleUnauthorizedServiceException(HttpServletRequest req, Exception ex) {
        return WebUtils.produceUnauthorizedErrorView((Exception)ex);
    }

    protected Optional<SamlRegisteredServiceServiceProviderMetadataFacade> getSamlMetadataFacadeFor(SamlRegisteredService registeredService, RequestAbstractType authnRequest) {
        return SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.configurationContext.getSamlRegisteredServiceCachingMetadataResolver(), (SamlRegisteredService)registeredService, (RequestAbstractType)authnRequest);
    }

    protected Optional<SamlRegisteredServiceServiceProviderMetadataFacade> getSamlMetadataFacadeFor(SamlRegisteredService registeredService, String entityId) {
        return SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.configurationContext.getSamlRegisteredServiceCachingMetadataResolver(), (SamlRegisteredService)registeredService, (String)entityId);
    }

    protected SamlRegisteredService verifySamlRegisteredService(String serviceId) {
        if (StringUtils.isBlank((CharSequence)serviceId)) {
            throw new UnauthorizedServiceException("screen.service.error.message", "Could not verify/locate SAML registered service since no serviceId is provided");
        }
        WebApplicationService service = (WebApplicationService)this.configurationContext.getWebApplicationServiceFactory().createService(serviceId);
        service.getAttributes().put("entityId", CollectionUtils.wrapList((Object[])new Object[]{serviceId}));
        LOGGER.debug("Checking service access in CAS service registry for [{}]", (Object)service);
        SamlRegisteredService registeredService = (SamlRegisteredService)this.configurationContext.getServicesManager().findServiceBy((Service)service, SamlRegisteredService.class);
        if (registeredService == null || !registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            LOGGER.warn("[{}] is not found in the registry or service access is denied.", (Object)serviceId);
            throw new UnauthorizedServiceException("screen.service.error.message");
        }
        LOGGER.debug("Located SAML service in the registry as [{}] with the metadata location of [{}]", (Object)registeredService.getServiceId(), (Object)registeredService.getMetadataLocation());
        return registeredService;
    }

    protected AuthenticatedAssertionContext buildCasAssertion(Authentication authentication, Service service, RegisteredService registeredService, Map<String, List<Object>> attributesToCombine) {
        RegisteredServiceAttributeReleasePolicyContext context = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService(registeredService).service(service).principal(authentication.getPrincipal()).build();
        Map attributes = registeredService.getAttributeReleasePolicy().getAttributes(context);
        String principalId = registeredService.getUsernameAttributeProvider().resolveUsername(authentication.getPrincipal(), service, registeredService);
        attributes.putAll(attributesToCombine);
        Map authnAttributes = this.configurationContext.getAuthenticationAttributeReleasePolicy().getAuthenticationAttributesForRelease(authentication, null, Map.of(), registeredService);
        return ((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)AuthenticatedAssertionContext.builder().name(principalId)).authenticationDate(DateTimeUtils.zonedDateTimeOf((TemporalAccessor)authentication.getAuthenticationDate()))).validFromDate(DateTimeUtils.zonedDateTimeOf((TemporalAccessor)authentication.getAuthenticationDate()))).attributes(CollectionUtils.merge((Map[])new Map[]{attributes, authnAttributes}))).build();
    }

    protected AuthenticatedAssertionContext buildCasAssertion(String principal, RegisteredService registeredService, Map<String, Object> attributes) {
        return ((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)((AuthenticatedAssertionContext.AuthenticatedAssertionContextBuilder)AuthenticatedAssertionContext.builder().name(principal)).attributes(attributes)).build();
    }

    protected ModelAndView issueAuthenticationRequestRedirect(org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> pair, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuthnRequest authnRequest = (AuthnRequest)pair.getLeft();
        String serviceUrl = this.constructServiceUrl(request, response, pair);
        LOGGER.debug("Created service url [{}]", (Object)DigestUtils.abbreviate((String)serviceUrl));
        CasConfigurationProperties properties = this.configurationContext.getCasProperties();
        String urlToRedirectTo = AbstractSamlIdPProfileHandlerController.constructRedirectUrl(properties.getServer().getLoginUrl(), serviceUrl, authnRequest.isForceAuthn(), authnRequest.isPassive());
        LOGGER.debug("Redirecting SAML authN request to [{}]", (Object)urlToRedirectTo);
        SamlIdPCoreProperties.SessionStorageTypes type = properties.getAuthn().getSamlIdp().getCore().getSessionStorageType();
        if (type == SamlIdPCoreProperties.SessionStorageTypes.BROWSER_SESSION_STORAGE) {
            JEEContext context = new JEEContext(request, response);
            BrowserSessionStorage sessionStorage = this.configurationContext.getSessionStore().getTrackableSession((WebContext)context).map(BrowserSessionStorage.class::cast).orElseThrow(() -> new IllegalStateException("Unable to determine trackable session for storage"));
            sessionStorage.setDestinationUrl(urlToRedirectTo);
            return new ModelAndView("storage/casSessionStorageWriteView", "sessionStorage", (Object)sessionStorage);
        }
        LOGGER.debug("Redirecting SAML authN request to [{}]", (Object)urlToRedirectTo);
        ModelAndView mv = new ModelAndView((View)new RedirectView(urlToRedirectTo));
        mv.setStatus(HttpStatus.FOUND);
        return mv;
    }

    private static String constructRedirectUrl(String casServerLoginUrl, String serviceUrl, boolean renew, boolean gateway) {
        return casServerLoginUrl + "?service=" + EncodingUtils.urlEncode((String)serviceUrl) + (renew ? "&renew=true" : "") + (gateway ? "&gateway=true" : "");
    }

    protected String constructServiceUrl(HttpServletRequest request, HttpServletResponse response, org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> pair) throws Exception {
        AuthnRequest authnRequest = (AuthnRequest)pair.getLeft();
        URLBuilder builder = new URLBuilder(this.configurationContext.getCallbackService().getId());
        builder.getQueryParams().add(new Pair((Object)"entityId", (Object)SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest)));
        this.storeAuthenticationRequest(request, response, pair);
        String url = builder.buildURL();
        LOGGER.trace("Built service callback url [{}]", (Object)url);
        return url;
    }

    protected ModelAndView initiateAuthenticationRequest(org.apache.commons.lang3.tuple.Pair<? extends RequestAbstractType, MessageContext> pair, HttpServletResponse response, HttpServletRequest request) throws Exception {
        this.autoConfigureCookiePath(request);
        this.verifySamlAuthenticationRequest(pair, request);
        Optional<TicketGrantingTicket> sso = this.singleSignOnSessionExists(pair, request, response);
        if (sso.isEmpty()) {
            return this.issueAuthenticationRequestRedirect(pair, request, response);
        }
        this.buildResponseBasedSingleSignOnSession(pair, sso.get(), request, response);
        return null;
    }

    protected void buildResponseBasedSingleSignOnSession(org.apache.commons.lang3.tuple.Pair<? extends RequestAbstractType, MessageContext> context, TicketGrantingTicket ticketGrantingTicket, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AuthnRequest authnRequest = (AuthnRequest)context.getLeft();
        String id = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest);
        WebApplicationService service = (WebApplicationService)this.configurationContext.getWebApplicationServiceFactory().createService(id);
        service.getAttributes().put("entityId", CollectionUtils.wrapList((Object[])new Object[]{id}));
        SamlRegisteredService registeredService = (SamlRegisteredService)this.configurationContext.getServicesManager().findServiceBy((Service)service, SamlRegisteredService.class);
        AuditableContext audit = AuditableContext.builder().service((Service)service).authentication(ticketGrantingTicket.getAuthentication()).registeredService((RegisteredService)registeredService).httpRequest((Object)request).httpResponse((Object)response).build();
        AuditableExecutionResult accessResult = this.configurationContext.getRegisteredServiceAccessStrategyEnforcer().execute(audit);
        accessResult.throwExceptionIfNeeded();
        AuthenticatedAssertionContext assertion = this.buildCasAssertion(ticketGrantingTicket.getAuthentication(), (Service)service, (RegisteredService)registeredService, Map.of());
        org.apache.commons.lang3.tuple.Pair<? extends RequestAbstractType, MessageContext> authenticationContext = this.buildAuthenticationContextPair(request, response, context);
        String binding = this.determineProfileBinding(authenticationContext);
        MessageContext messageContext = (MessageContext)authenticationContext.getRight();
        String relayState = SAMLBindingSupport.getRelayState((MessageContext)messageContext);
        SAMLBindingSupport.setRelayState((MessageContext)((MessageContext)authenticationContext.getRight()), (String)relayState);
        response.reset();
        ServiceTicketFactory factory = (ServiceTicketFactory)this.getConfigurationContext().getTicketFactory().get(ServiceTicket.class);
        ServiceTicket st = (ServiceTicket)factory.create(ticketGrantingTicket, (Service)service, false, ServiceTicket.class);
        this.getConfigurationContext().getTicketRegistry().addTicket((Ticket)st);
        this.getConfigurationContext().getTicketRegistry().updateTicket((Ticket)ticketGrantingTicket);
        this.buildSamlResponse(response, request, authenticationContext, assertion, binding);
    }

    protected void buildSamlResponse(HttpServletResponse response, HttpServletRequest request, org.apache.commons.lang3.tuple.Pair<? extends RequestAbstractType, MessageContext> authenticationContext, AuthenticatedAssertionContext casAssertion, String binding) throws Exception {
        AuthnRequest authnRequest = (AuthnRequest)AuthnRequest.class.cast(authenticationContext.getKey());
        org.apache.commons.lang3.tuple.Pair<SamlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade> pair = this.getRegisteredServiceAndFacade(authnRequest);
        String entityId = ((SamlRegisteredServiceServiceProviderMetadataFacade)pair.getValue()).getEntityId();
        LOGGER.debug("Preparing SAML2 response for [{}]", (Object)entityId);
        Object buildContext = ((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)SamlProfileBuilderContext.builder().samlRequest((RequestAbstractType)authnRequest)).httpRequest(request)).httpResponse(response)).authenticatedAssertion(casAssertion)).registeredService((SamlRegisteredService)pair.getKey())).adaptor((SamlRegisteredServiceServiceProviderMetadataFacade)pair.getValue())).binding(binding)).messageContext((MessageContext)authenticationContext.getValue())).build();
        this.configurationContext.getResponseBuilder().build((SamlProfileBuilderContext)buildContext);
        LOGGER.info("Built the SAML2 response for [{}]", (Object)entityId);
    }

    protected org.apache.commons.lang3.tuple.Pair<? extends RequestAbstractType, MessageContext> buildAuthenticationContextPair(HttpServletRequest request, HttpServletResponse response, org.apache.commons.lang3.tuple.Pair<? extends RequestAbstractType, MessageContext> authnContext) {
        String relayState = Optional.ofNullable(SAMLBindingSupport.getRelayState((MessageContext)((MessageContext)authnContext.getValue()))).orElseGet(() -> request.getParameter("RelayState"));
        MessageContext messageContext = AbstractSamlIdPProfileHandlerController.bindRelayStateParameter(request, response, authnContext, relayState);
        return org.apache.commons.lang3.tuple.Pair.of((Object)((RequestAbstractType)authnContext.getLeft()), (Object)messageContext);
    }

    protected Optional<TicketGrantingTicket> singleSignOnSessionExists(org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> pair, HttpServletRequest request, HttpServletResponse response) {
        AuthnRequest authnRequest = (AuthnRequest)AuthnRequest.class.cast(pair.getLeft());
        if (authnRequest.isForceAuthn().booleanValue()) {
            LOGGER.trace("Authentication request asks for forced authn. Ignoring existing single sign-on session, if any");
            return Optional.empty();
        }
        String cookie = this.configurationContext.getTicketGrantingTicketCookieGenerator().retrieveCookieValue(request);
        if (StringUtils.isBlank((CharSequence)cookie)) {
            LOGGER.trace("Single sign-on session cannot be found or determined. Ignoring single sign-on session");
            return Optional.empty();
        }
        TicketGrantingTicket ticketGrantingTicket = this.configurationContext.getTicketRegistrySupport().getTicketGrantingTicket(cookie);
        if (ticketGrantingTicket == null) {
            LOGGER.debug("Authentication transaction linked to single sign-on session cannot determined.");
            return Optional.empty();
        }
        Authentication authentication = ticketGrantingTicket.getAuthentication();
        LOGGER.debug("Located single sign-on authentication for principal [{}]", (Object)authentication.getPrincipal());
        String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest);
        WebApplicationService service = (WebApplicationService)this.configurationContext.getWebApplicationServiceFactory().createService(issuer);
        RegisteredService registeredService = this.configurationContext.getServicesManager().findServiceBy((Service)service);
        SingleSignOnParticipationRequest ssoRequest = SingleSignOnParticipationRequest.builder().httpServletRequest(request).httpServletResponse(response).build().attribute(Service.class.getName(), (Object)service).attribute(RegisteredService.class.getName(), (Object)registeredService).attribute(Issuer.class.getName(), (Object)issuer).attribute(Authentication.class.getName(), (Object)authentication).attribute(TicketGrantingTicket.class.getName(), (Object)cookie).attribute(AuthnRequest.class.getName(), (Object)authnRequest);
        SingleSignOnParticipationStrategy ssoStrategy = this.configurationContext.getSingleSignOnParticipationStrategy();
        LOGGER.debug("Checking for single sign-on participation for issuer [{}]", (Object)issuer);
        boolean ssoAvailable = ssoStrategy.supports(ssoRequest) && ssoStrategy.isParticipating(ssoRequest);
        return ssoAvailable ? Optional.of(ticketGrantingTicket) : Optional.empty();
    }

    protected org.apache.commons.lang3.tuple.Pair<SamlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade> verifySamlAuthenticationRequest(org.apache.commons.lang3.tuple.Pair<? extends RequestAbstractType, MessageContext> authenticationContext, HttpServletRequest request) throws Exception {
        AuthnRequest authnRequest = (AuthnRequest)authenticationContext.getKey();
        String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)authnRequest);
        LOGGER.debug("Located issuer [{}] from authentication request", (Object)issuer);
        SamlRegisteredService registeredService = this.verifySamlRegisteredService(issuer);
        LOGGER.debug("Fetching SAML2 metadata adaptor for [{}]", (Object)issuer);
        Optional adaptor = SamlRegisteredServiceServiceProviderMetadataFacade.get((SamlRegisteredServiceCachingMetadataResolver)this.configurationContext.getSamlRegisteredServiceCachingMetadataResolver(), (SamlRegisteredService)registeredService, (RequestAbstractType)authnRequest);
        if (adaptor.isEmpty()) {
            LOGGER.warn("No metadata could be found for [{}]", (Object)issuer);
            throw new UnauthorizedServiceException("screen.service.error.message", "Cannot find metadata linked to " + issuer);
        }
        SamlRegisteredServiceServiceProviderMetadataFacade facade = (SamlRegisteredServiceServiceProviderMetadataFacade)adaptor.get();
        this.verifyAuthenticationContextSignature(authenticationContext, request, (RequestAbstractType)authnRequest, facade, registeredService);
        String binding = this.determineProfileBinding(authenticationContext);
        Endpoint acs = SamlIdPUtils.determineEndpointForRequest((org.apache.commons.lang3.tuple.Pair)org.apache.commons.lang3.tuple.Pair.of((Object)authnRequest, (Object)((MessageContext)authenticationContext.getRight())), (SamlRegisteredServiceServiceProviderMetadataFacade)facade, (String)binding);
        LOGGER.debug("Determined SAML2 endpoint for authentication request as [{}]", (Object)StringUtils.defaultIfBlank((CharSequence)acs.getResponseLocation(), (CharSequence)acs.getLocation()));
        this.configurationContext.getOpenSamlConfigBean().logObject((XMLObject)authnRequest);
        return org.apache.commons.lang3.tuple.Pair.of((Object)registeredService, (Object)facade);
    }

    protected void verifyAuthenticationContextSignature(org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> authenticationContext, HttpServletRequest request, RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, SamlRegisteredService registeredService) throws Exception {
        MessageContext ctx = (MessageContext)authenticationContext.getValue();
        this.verifyAuthenticationContextSignature(ctx, request, authnRequest, adaptor, registeredService);
    }

    protected void verifyAuthenticationContextSignature(MessageContext ctx, HttpServletRequest request, RequestAbstractType authnRequest, SamlRegisteredServiceServiceProviderMetadataFacade adaptor, SamlRegisteredService registeredService) throws Exception {
        if (!SAMLBindingSupport.isMessageSigned((MessageContext)ctx)) {
            LOGGER.trace("The authentication context is not signed");
            if (adaptor.isAuthnRequestsSigned() && !registeredService.isSkipValidatingAuthnRequest()) {
                LOGGER.error("Metadata for [{}] says authentication requests are signed, yet request is not", (Object)adaptor.getEntityId());
                throw new SAMLException("Request is not signed but should be");
            }
            LOGGER.trace("Request is not signed or validation is skipped, so there is no need to verify its signature.");
        } else if (adaptor.isAuthnRequestsSigned() && !registeredService.isSkipValidatingAuthnRequest()) {
            LOGGER.trace("The authentication context is signed; Proceeding to validate signatures...");
            this.configurationContext.getSamlObjectSignatureValidator().verifySamlProfileRequestIfNeeded(authnRequest, adaptor, request, ctx);
        }
    }

    protected org.apache.commons.lang3.tuple.Pair<SamlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade> getRegisteredServiceAndFacade(AuthnRequest request) {
        String issuer = SamlIdPUtils.getIssuerFromSamlObject((SAMLObject)request);
        LOGGER.debug("Located issuer [{}] from authentication context", (Object)issuer);
        SamlRegisteredService registeredService = this.verifySamlRegisteredService(issuer);
        LOGGER.debug("Located SAML metadata for [{}]", (Object)registeredService.getServiceId());
        Optional<SamlRegisteredServiceServiceProviderMetadataFacade> adaptor = this.getSamlMetadataFacadeFor(registeredService, (RequestAbstractType)request);
        if (adaptor.isEmpty()) {
            throw new UnauthorizedServiceException("screen.service.error.message", "Cannot find metadata linked to " + issuer);
        }
        SamlRegisteredServiceServiceProviderMetadataFacade facade = adaptor.get();
        return org.apache.commons.lang3.tuple.Pair.of((Object)registeredService, (Object)facade);
    }

    protected MessageContext decodeSoapRequest(final HttpServletRequest request) {
        return (MessageContext)FunctionUtils.doAndHandle((CheckedSupplier)new CheckedSupplier<MessageContext>(){

            public MessageContext get() throws Throwable {
                HTTPSOAP11Decoder decoder = new HTTPSOAP11Decoder();
                decoder.setParserPool(AbstractSamlIdPProfileHandlerController.this.configurationContext.getOpenSamlConfigBean().getParserPool());
                decoder.setHttpServletRequest(request);
                BindingDescriptor binding = new BindingDescriptor();
                binding.setId(this.getClass().getName());
                binding.setShortName(this.getClass().getName());
                binding.setSignatureCapable(true);
                binding.setSynchronous(true);
                decoder.setBindingDescriptor(binding);
                decoder.initialize();
                decoder.decode();
                return decoder.getMessageContext();
            }
        }, throwable -> null).get();
    }

    protected void autoConfigureCookiePath(HttpServletRequest request) {
        CasConfigurationProperties casProperties = this.configurationContext.getCasProperties();
        SamlIdPCoreProperties core = casProperties.getAuthn().getSamlIdp().getCore();
        SamlIdPCoreProperties.SessionStorageTypes sessionStorageType = core.getSessionStorageType();
        if (sessionStorageType == SamlIdPCoreProperties.SessionStorageTypes.TICKET_REGISTRY && core.getSessionReplication().getCookie().isAutoConfigureCookiePath()) {
            String contextPath = request.getContextPath();
            Object cookiePath = StringUtils.isNotBlank((CharSequence)contextPath) ? contextPath + "/" : "/";
            CasCookieBuilder cookieBuilder = this.configurationContext.getSamlDistributedSessionCookieGenerator();
            String path = cookieBuilder.getCookiePath();
            if (StringUtils.isBlank((CharSequence)path)) {
                LOGGER.debug("Setting path for cookies for SAML2 distributed session cookie generator to: [{}]", cookiePath);
                cookieBuilder.setCookiePath((String)cookiePath);
            } else {
                LOGGER.trace("SAML2 authentication cookie domain is [{}] with path [{}]", (Object)cookieBuilder.getCookieDomain(), (Object)path);
            }
        }
    }

    protected ModelAndView handleSsoPostProfileRequest(HttpServletResponse response, HttpServletRequest request, BaseHttpServletRequestXMLMessageDecoder decoder) {
        return (ModelAndView)FunctionUtils.doAndHandle(() -> {
            org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> result = this.getConfigurationContext().getSamlHttpRequestExtractor().extract(request, decoder, AuthnRequest.class).orElseThrow(() -> new IllegalArgumentException("Unable to extract SAML request"));
            org.apache.commons.lang3.tuple.Pair context = org.apache.commons.lang3.tuple.Pair.of((Object)((AuthnRequest)AuthnRequest.class.cast(result.getLeft())), (Object)((MessageContext)result.getRight()));
            return this.initiateAuthenticationRequest((org.apache.commons.lang3.tuple.Pair<? extends RequestAbstractType, MessageContext>)context, response, request);
        }, WebUtils::produceErrorView).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final org.apache.commons.lang3.tuple.Pair<? extends RequestAbstractType, MessageContext> retrieveAuthenticationRequest(HttpServletResponse response, HttpServletRequest request) {
        Object object = this.$lock;
        synchronized (object) {
            LOGGER.info("Received SAML callback profile request [{}]", (Object)request.getRequestURI());
            JEEContext webContext = new JEEContext(request, response);
            return (org.apache.commons.lang3.tuple.Pair)SamlIdPUtils.retrieveSamlRequest((WebContext)webContext, (SessionStore)this.configurationContext.getSessionStore(), (OpenSamlConfigBean)this.configurationContext.getOpenSamlConfigBean(), AuthnRequest.class).orElseThrow(() -> new IllegalArgumentException("SAML request or context could not be determined from session store"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeAuthenticationRequest(HttpServletRequest request, HttpServletResponse response, org.apache.commons.lang3.tuple.Pair<? extends SignableSAMLObject, MessageContext> context) throws Exception {
        Object object = this.$lock;
        synchronized (object) {
            JEEContext webContext = new JEEContext(request, response);
            SamlIdPUtils.storeSamlRequest((JEEContext)webContext, (OpenSamlConfigBean)this.configurationContext.getOpenSamlConfigBean(), (SessionStore)this.configurationContext.getSessionStore(), context);
        }
    }

    protected String determineProfileBinding(org.apache.commons.lang3.tuple.Pair<? extends RequestAbstractType, MessageContext> authenticationContext) {
        AuthnRequest authnRequest = (AuthnRequest)AuthnRequest.class.cast(authenticationContext.getKey());
        org.apache.commons.lang3.tuple.Pair<SamlRegisteredService, SamlRegisteredServiceServiceProviderMetadataFacade> pair = this.getRegisteredServiceAndFacade(authnRequest);
        SamlRegisteredServiceServiceProviderMetadataFacade facade = (SamlRegisteredServiceServiceProviderMetadataFacade)pair.getValue();
        String binding = (String)StringUtils.defaultIfBlank((CharSequence)authnRequest.getProtocolBinding(), (CharSequence)"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        LOGGER.debug("Determined authentication request binding is [{}], issued by [{}]", (Object)binding, (Object)authnRequest.getIssuer().getValue());
        String entityId = facade.getEntityId();
        LOGGER.debug("Checking metadata for [{}] to see if binding [{}] is supported", (Object)entityId, (Object)binding);
        AssertionConsumerService svc = facade.getAssertionConsumerService(binding);
        LOGGER.debug("Binding [{}] is supported by [{}]", (Object)svc.getBinding(), (Object)entityId);
        return binding;
    }

    @Generated
    protected AbstractSamlIdPProfileHandlerController(SamlProfileHandlerConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    @Generated
    public SamlProfileHandlerConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }
}

