/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.audit;

import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apereo.inspektr.audit.spi.support.ReturnValueAsStringResourceResolver;
import org.aspectj.lang.JoinPoint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Fault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamlResponseAuditResourceResolver
extends ReturnValueAsStringResourceResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlResponseAuditResourceResolver.class);

    public String[] resolveFrom(JoinPoint joinPoint, Object returnValue) {
        if (returnValue instanceof Response) {
            return this.getPrincipalIdFromSamlResponse((Response)returnValue);
        }
        if (returnValue instanceof Envelope) {
            return this.getPrincipalIdFromSamlEcpResponse((Envelope)returnValue);
        }
        LOGGER.error("Could not determine the SAML response in the returned value");
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    private String[] getPrincipalIdFromSamlEcpResponse(Envelope envelope) {
        List objects = envelope.getBody().getUnknownXMLObjects();
        if (objects.isEmpty()) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        XMLObject object = (XMLObject)objects.get(0);
        if (object instanceof Response) {
            return this.getPrincipalIdFromSamlResponse((Response)object);
        }
        if (object instanceof Fault) {
            return this.getPrincipalIdFromSamlEcpFault((Fault)object);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    private String[] getPrincipalIdFromSamlResponse(Response response) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("issuer", response.getIssuer().getValue());
        values.put("destination", response.getDestination());
        values.put("responseId", response.getID());
        return new String[]{this.auditFormat.serialize(values)};
    }

    private String[] getPrincipalIdFromSamlEcpFault(Fault fault) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("actor", fault.getActor().getURI());
        values.put("message", fault.getMessage().getValue());
        return new String[]{this.auditFormat.serialize(values)};
    }
}

