/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.security;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.AuthDataAccessor;
import org.apache.syncope.core.spring.security.DefaultCredentialChecker;
import org.apache.syncope.core.spring.security.JWTAuthentication;
import org.apache.syncope.core.spring.security.JWTSSOProvider;
import org.apache.syncope.core.spring.security.SyncopeAuthenticationDetailsSource;
import org.apache.syncope.core.spring.security.SyncopeGrantedAuthority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class JWTAuthenticationFilter
extends BasicAuthenticationFilter {
    private static final Logger LOG = LoggerFactory.getLogger(JWTAuthenticationFilter.class);
    private final AuthenticationEntryPoint authenticationEntryPoint;
    private final SyncopeAuthenticationDetailsSource authenticationDetailsSource;
    private final AuthDataAccessor dataAccessor;
    private final DefaultCredentialChecker credentialChecker;

    public JWTAuthenticationFilter(AuthenticationManager authenticationManager, AuthenticationEntryPoint authenticationEntryPoint, SyncopeAuthenticationDetailsSource authenticationDetailsSource, AuthDataAccessor dataAccessor, DefaultCredentialChecker credentialChecker) {
        super(authenticationManager);
        this.authenticationEntryPoint = authenticationEntryPoint;
        this.authenticationDetailsSource = authenticationDetailsSource;
        this.dataAccessor = dataAccessor;
        this.credentialChecker = credentialChecker;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        String auth = request.getHeader("Authorization");
        String[] parts = Optional.ofNullable(auth).map(s -> s.split(" ")).orElse(null);
        if (parts == null || parts.length != 2 || !"Bearer".equals(parts[0])) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String stringToken = parts[1];
        LOG.debug("JWT received: {}", (Object)stringToken);
        try {
            this.credentialChecker.checkIsDefaultJWSKeyInUse();
            SignedJWT jwt = SignedJWT.parse((String)stringToken);
            JWTSSOProvider jwtSSOProvider = this.dataAccessor.getJWTSSOProvider(jwt.getJWTClaimsSet().getIssuer());
            if (!jwt.verify((JWSVerifier)jwtSSOProvider)) {
                throw new BadCredentialsException("Invalid signature found in JWT");
            }
            JWTAuthentication jwtAuthentication = new JWTAuthentication(jwt.getJWTClaimsSet(), this.authenticationDetailsSource.buildDetails(request));
            AuthContextUtils.callAsAdmin(jwtAuthentication.getDetails().getDomain(), () -> {
                Pair<String, Set<SyncopeGrantedAuthority>> authenticated = this.dataAccessor.authenticate(jwtAuthentication);
                jwtAuthentication.setUsername((String)authenticated.getLeft());
                jwtAuthentication.getAuthorities().addAll((Collection)authenticated.getRight());
                return null;
            });
            SecurityContextHolder.getContext().setAuthentication((Authentication)jwtAuthentication);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (JOSEException | ParseException e) {
            SecurityContextHolder.clearContext();
            this.authenticationEntryPoint.commence(request, response, (AuthenticationException)new BadCredentialsException("Invalid JWT: " + stringToken, e));
        }
        catch (AuthenticationException e) {
            SecurityContextHolder.clearContext();
            this.authenticationEntryPoint.commence(request, response, e);
        }
    }
}

