/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.policy;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.policy.DefaultPasswordRuleConf;
import org.apache.syncope.common.lib.policy.PasswordRuleConf;
import org.apache.syncope.core.persistence.api.dao.PasswordRule;
import org.apache.syncope.core.persistence.api.dao.PasswordRuleConfClass;
import org.apache.syncope.core.persistence.api.entity.user.LAPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.spring.policy.PasswordPolicyException;
import org.apache.syncope.core.spring.security.Encryptor;
import org.passay.CharacterData;
import org.passay.CharacterRule;
import org.passay.EnglishCharacterData;
import org.passay.IllegalCharacterRule;
import org.passay.LengthRule;
import org.passay.MessageResolver;
import org.passay.PasswordData;
import org.passay.PasswordValidator;
import org.passay.PropertiesMessageResolver;
import org.passay.RepeatCharactersRule;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.UsernameRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@PasswordRuleConfClass(value=DefaultPasswordRuleConf.class)
public class DefaultPasswordRule
implements PasswordRule {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultPasswordRule.class);
    protected static final Encryptor ENCRYPTOR = Encryptor.getInstance();
    protected DefaultPasswordRuleConf conf;
    protected PasswordValidator passwordValidator;

    public static List<Rule> conf2Rules(final DefaultPasswordRuleConf conf) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        LengthRule lengthRule = new LengthRule();
        if (conf.getMinLength() > 0) {
            lengthRule.setMinimumLength(conf.getMinLength());
        }
        if (conf.getMaxLength() > 0) {
            lengthRule.setMaximumLength(conf.getMaxLength());
        }
        rules.add((Rule)lengthRule);
        if (conf.getAlphabetical() > 0) {
            rules.add((Rule)new CharacterRule((CharacterData)EnglishCharacterData.Alphabetical, conf.getAlphabetical()));
        }
        if (conf.getUppercase() > 0) {
            rules.add((Rule)new CharacterRule((CharacterData)EnglishCharacterData.UpperCase, conf.getUppercase()));
        }
        if (conf.getLowercase() > 0) {
            rules.add((Rule)new CharacterRule((CharacterData)EnglishCharacterData.LowerCase, conf.getLowercase()));
        }
        if (conf.getDigit() > 0) {
            rules.add((Rule)new CharacterRule((CharacterData)EnglishCharacterData.Digit, conf.getDigit()));
        }
        if (conf.getSpecial() > 0) {
            rules.add((Rule)new CharacterRule(new CharacterData(){

                public String getErrorCode() {
                    return "INSUFFICIENT_SPECIAL";
                }

                public String getCharacters() {
                    return new String(ArrayUtils.toPrimitive((Character[])((Character[])conf.getSpecialChars().toArray(Character[]::new))));
                }
            }, conf.getSpecial()));
        }
        if (!conf.getIllegalChars().isEmpty()) {
            rules.add((Rule)new IllegalCharacterRule(ArrayUtils.toPrimitive((Character[])((Character[])conf.getIllegalChars().toArray(Character[]::new)))));
        }
        if (conf.getRepeatSame() > 0) {
            rules.add((Rule)new RepeatCharactersRule(conf.getRepeatSame()));
        }
        if (!conf.isUsernameAllowed()) {
            rules.add((Rule)new UsernameRule(true, true));
        }
        return rules;
    }

    public PasswordRuleConf getConf() {
        return this.conf;
    }

    public void setConf(PasswordRuleConf conf) {
        block9: {
            if (conf instanceof DefaultPasswordRuleConf) {
                this.conf = (DefaultPasswordRuleConf)conf;
                Properties passay = new Properties();
                try (InputStream in = this.getClass().getResourceAsStream("/passay.properties");){
                    passay.load(in);
                    this.passwordValidator = new PasswordValidator((MessageResolver)new PropertiesMessageResolver(passay), DefaultPasswordRule.conf2Rules(this.conf));
                    break block9;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Could not initialize Passay", e);
                }
            }
            throw new IllegalArgumentException(DefaultPasswordRuleConf.class.getName() + " expected, got " + conf.getClass().getName());
        }
    }

    protected void enforce(String clear, String username, Set<String> wordsNotPermitted) {
        RuleResult result = this.passwordValidator.validate(username == null ? new PasswordData(clear) : new PasswordData(username, clear));
        if (!result.isValid()) {
            throw new PasswordPolicyException(this.passwordValidator.getMessages(result).stream().collect(Collectors.joining(",")));
        }
        wordsNotPermitted.stream().filter(word -> StringUtils.containsIgnoreCase((CharSequence)clear, (CharSequence)word)).findFirst().ifPresent(word -> {
            throw new PasswordPolicyException("Used word(s) not permitted");
        });
    }

    @Transactional(readOnly=true)
    public void enforce(User user) {
        if (user.getPassword() != null && user.getClearPassword() != null) {
            HashSet<String> wordsNotPermitted = new HashSet<String>(this.conf.getWordsNotPermitted());
            wordsNotPermitted.addAll(this.conf.getSchemasNotPermitted().stream().map(arg_0 -> ((User)user).getPlainAttr(arg_0)).filter(Optional::isPresent).map(attr -> ((UPlainAttr)attr.get()).getValuesAsStrings()).filter(values -> !CollectionUtils.isEmpty((Collection)values)).flatMap(Collection::stream).collect(Collectors.toSet()));
            this.enforce(user.getClearPassword(), user.getUsername(), wordsNotPermitted);
        }
    }

    @Transactional(readOnly=true)
    public void enforce(LinkedAccount account) {
        this.conf.getWordsNotPermitted().addAll(this.conf.getSchemasNotPermitted().stream().map(arg_0 -> ((LinkedAccount)account).getPlainAttr(arg_0)).filter(Optional::isPresent).map(attr -> ((LAPlainAttr)attr.get()).getValuesAsStrings()).filter(values -> !CollectionUtils.isEmpty((Collection)values)).flatMap(Collection::stream).collect(Collectors.toList()));
        if (account.getPassword() != null) {
            String clear = null;
            if (account.canDecodeSecrets()) {
                try {
                    clear = ENCRYPTOR.decode(account.getPassword(), account.getCipherAlgorithm());
                }
                catch (Exception e) {
                    LOG.error("Could not decode password for {}", (Object)account, (Object)e);
                }
            }
            if (clear != null) {
                HashSet<String> wordsNotPermitted = new HashSet<String>(this.conf.getWordsNotPermitted());
                wordsNotPermitted.addAll(this.conf.getSchemasNotPermitted().stream().map(arg_0 -> ((LinkedAccount)account).getPlainAttr(arg_0)).filter(Optional::isPresent).map(attr -> ((LAPlainAttr)attr.get()).getValuesAsStrings()).filter(values -> !CollectionUtils.isEmpty((Collection)values)).flatMap(Collection::stream).collect(Collectors.toSet()));
                this.enforce(clear, account.getUsername(), wordsNotPermitted);
            }
        }
    }
}

