/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.spring.policy;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.policy.AccountRuleConf;
import org.apache.syncope.common.lib.policy.DefaultAccountRuleConf;
import org.apache.syncope.core.persistence.api.dao.AccountRule;
import org.apache.syncope.core.persistence.api.dao.AccountRuleConfClass;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.user.LAPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.LinkedAccount;
import org.apache.syncope.core.persistence.api.entity.user.UPlainAttr;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.spring.policy.AccountPolicyException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@AccountRuleConfClass(value=DefaultAccountRuleConf.class)
public class DefaultAccountRule
implements AccountRule {
    private DefaultAccountRuleConf conf;

    public void setConf(AccountRuleConf conf) {
        if (!(conf instanceof DefaultAccountRuleConf)) {
            throw new IllegalArgumentException(DefaultAccountRuleConf.class.getName() + " expected, got " + conf.getClass().getName());
        }
        this.conf = (DefaultAccountRuleConf)DefaultAccountRuleConf.class.cast(conf);
    }

    protected void enforce(String username, Set<String> wordsNotPermitted) {
        Pattern pattern;
        if (this.conf.getMinLength() > 0 && this.conf.getMinLength() > username.length()) {
            throw new AccountPolicyException("Username too short");
        }
        if (this.conf.getMaxLength() > 0 && this.conf.getMaxLength() < username.length()) {
            throw new AccountPolicyException("Username too long");
        }
        wordsNotPermitted.stream().filter(word -> StringUtils.containsIgnoreCase((CharSequence)username, (CharSequence)word)).forEach(item -> {
            throw new AccountPolicyException("Used word(s) not permitted");
        });
        if (this.conf.isAllUpperCase() && !username.equals(username.toUpperCase())) {
            throw new AccountPolicyException("No lowercase characters permitted");
        }
        if (this.conf.isAllLowerCase() && !username.equals(username.toLowerCase())) {
            throw new AccountPolicyException("No uppercase characters permitted");
        }
        Pattern pattern2 = pattern = this.conf.getPattern() == null ? Entity.ID_PATTERN : Pattern.compile(this.conf.getPattern());
        if (!pattern.matcher(username).matches()) {
            throw new AccountPolicyException("Username does not match pattern");
        }
        this.conf.getPrefixesNotPermitted().stream().filter(username::startsWith).findAny().ifPresent(item -> {
            throw new AccountPolicyException("Prefix not permitted");
        });
        this.conf.getSuffixesNotPermitted().stream().filter(username::endsWith).findAny().ifPresent(item -> {
            throw new AccountPolicyException("Suffix not permitted");
        });
    }

    @Transactional(readOnly=true)
    public void enforce(User user) {
        HashSet<String> wordsNotPermitted = new HashSet<String>(this.conf.getWordsNotPermitted());
        wordsNotPermitted.addAll(this.conf.getSchemasNotPermitted().stream().map(arg_0 -> ((User)user).getPlainAttr(arg_0)).filter(Optional::isPresent).map(attr -> ((UPlainAttr)attr.get()).getValuesAsStrings()).filter(values -> !CollectionUtils.isEmpty((Collection)values)).flatMap(Collection::stream).collect(Collectors.toSet()));
        this.enforce(user.getUsername(), wordsNotPermitted);
    }

    @Transactional(readOnly=true)
    public void enforce(LinkedAccount account) {
        if (StringUtils.isBlank((CharSequence)account.getUsername())) {
            return;
        }
        HashSet<String> wordsNotPermitted = new HashSet<String>(this.conf.getWordsNotPermitted());
        wordsNotPermitted.addAll(this.conf.getSchemasNotPermitted().stream().map(arg_0 -> ((LinkedAccount)account).getPlainAttr(arg_0)).filter(Optional::isPresent).map(attr -> ((LAPlainAttr)attr.get()).getValuesAsStrings()).filter(values -> !CollectionUtils.isEmpty((Collection)values)).flatMap(Collection::stream).collect(Collectors.toSet()));
        this.enforce(account.getUsername(), wordsNotPermitted);
    }
}

