/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.init;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.rewrite.RewriteAppender;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.core.logic.LogicProperties;
import org.apache.syncope.core.logic.audit.AuditAppender;
import org.apache.syncope.core.logic.audit.JdbcAuditAppender;
import org.apache.syncope.core.logic.init.AuditAccessor;
import org.apache.syncope.core.persistence.api.ImplementationLookup;
import org.apache.syncope.core.persistence.api.SyncopeCoreLoader;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.beans.BeansException;

public class AuditLoader
implements SyncopeCoreLoader {
    protected static final String ROOT_LOGGER = "ROOT";
    protected final AuditAccessor auditAccessor;
    protected final ImplementationLookup implementationLookup;
    protected final LogicProperties props;

    public AuditLoader(AuditAccessor auditAccessor, ImplementationLookup implementationLookup, LogicProperties props) {
        this.auditAccessor = auditAccessor;
        this.implementationLookup = implementationLookup;
        this.props = props;
    }

    public int getOrder() {
        return 300;
    }

    public void load(String domain, DataSource datasource) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        if (this.props.isEnableJDBCAuditAppender()) {
            JdbcAuditAppender jdbcAuditAppender = (JdbcAuditAppender)ApplicationContextProvider.getBeanFactory().createBean(JdbcAuditAppender.class, 2, true);
            jdbcAuditAppender.init(domain);
            LoggerConfig logConf = new LoggerConfig(AuditLoggerName.getAuditLoggerName((String)domain), null, false);
            logConf.addAppender(jdbcAuditAppender.getTargetAppender(), Level.DEBUG, null);
            logConf.setLevel(Level.DEBUG);
            ctx.getConfiguration().addLogger(logConf.getName(), logConf);
        }
        this.auditAppenders(domain).forEach(auditAppender -> auditAppender.getEvents().stream().map(event -> AuditLoggerName.getAuditEventLoggerName((String)domain, (String)event.toAuditKey())).forEach(domainAuditLoggerName -> {
            LoggerConfig eventLogConf = ctx.getConfiguration().getLoggerConfig(domainAuditLoggerName);
            boolean isRootLogConf = "".equals(eventLogConf.getName());
            if (isRootLogConf) {
                eventLogConf = new LoggerConfig(domainAuditLoggerName, null, false);
            }
            AuditLoader.addAppenderToContext(ctx, auditAppender, eventLogConf);
            eventLogConf.setLevel(Level.DEBUG);
            if (isRootLogConf) {
                ctx.getConfiguration().addLogger(domainAuditLoggerName, eventLogConf);
            }
        }));
        AuthContextUtils.callAsAdmin((String)domain, () -> {
            this.auditAccessor.synchronizeLoggingWithAudit(ctx);
            return null;
        });
        ctx.updateLoggers();
    }

    public List<AuditAppender> auditAppenders(String domain) throws BeansException {
        return this.implementationLookup.getAuditAppenderClasses().stream().map(clazz -> {
            AuditAppender auditAppender;
            if (ApplicationContextProvider.getBeanFactory().containsSingleton(clazz.getName())) {
                auditAppender = (AuditAppender)ApplicationContextProvider.getBeanFactory().getSingleton(clazz.getName());
            } else {
                auditAppender = (AuditAppender)ApplicationContextProvider.getBeanFactory().createBean(clazz, 2, true);
                ApplicationContextProvider.getBeanFactory().registerSingleton(clazz.getName(), (Object)auditAppender);
                auditAppender.init(domain);
            }
            return auditAppender;
        }).collect(Collectors.toList());
    }

    public static void addAppenderToContext(LoggerContext ctx, AuditAppender auditAppender, LoggerConfig eventLogConf) {
        Appender targetAppender = ctx.getConfiguration().getAppender(auditAppender.getTargetAppenderName());
        if (targetAppender == null) {
            targetAppender = auditAppender.getTargetAppender();
        }
        targetAppender.start();
        ctx.getConfiguration().addAppender(targetAppender);
        Optional<RewriteAppender> rewriteAppender = auditAppender.getRewriteAppender();
        if (rewriteAppender.isPresent()) {
            rewriteAppender.get().start();
            eventLogConf.addAppender((Appender)rewriteAppender.get(), Level.DEBUG, null);
        } else {
            eventLogConf.addAppender(targetAppender, Level.DEBUG, null);
        }
    }
}

