/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.init;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.syncope.core.persistence.api.dao.AuditConfDAO;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.springframework.transaction.annotation.Transactional;

public class AuditAccessor {
    protected final AuditConfDAO auditConfDAO;

    public AuditAccessor(AuditConfDAO auditConfDAO) {
        this.auditConfDAO = auditConfDAO;
    }

    @Transactional
    public void synchronizeLoggingWithAudit(LoggerContext ctx) {
        Map audits = this.auditConfDAO.findAll().stream().collect(Collectors.toMap(audit -> AuditLoggerName.getAuditEventLoggerName((String)AuthContextUtils.getDomain(), (String)audit.getKey()), Function.identity()));
        audits.forEach((logger, audit) -> {
            LoggerConfig logConf = ctx.getConfiguration().getLoggerConfig(logger);
            logConf.setLevel(audit.isActive() ? Level.DEBUG : Level.OFF);
        });
        ctx.updateLoggers();
    }
}

