/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.audit;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.db.ColumnMapping;
import org.apache.logging.log4j.core.appender.db.jdbc.AbstractConnectionSource;
import org.apache.logging.log4j.core.appender.db.jdbc.ConnectionSource;
import org.apache.logging.log4j.core.appender.db.jdbc.JdbcAppender;
import org.apache.syncope.core.logic.audit.DefaultAuditAppender;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class JdbcAuditAppender
extends DefaultAuditAppender {
    @Autowired
    protected DomainHolder domainHolder;

    @Override
    protected void initTargetAppender() {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        ColumnMapping[] columnMappings = new ColumnMapping[]{ColumnMapping.newBuilder().setConfiguration(ctx.getConfiguration()).setName("EVENT_DATE").setType(Timestamp.class).build(), ColumnMapping.newBuilder().setConfiguration(ctx.getConfiguration()).setName("LOGGER_LEVEL").setPattern("%level").build(), ColumnMapping.newBuilder().setConfiguration(ctx.getConfiguration()).setName("LOGGER").setPattern("%logger").build(), ColumnMapping.newBuilder().setConfiguration(ctx.getConfiguration()).setName("MESSAGE").setPattern("%message").build(), ColumnMapping.newBuilder().setConfiguration(ctx.getConfiguration()).setName("THROWABLE").setPattern("%ex{full}").build()};
        Appender appender = ctx.getConfiguration().getAppender("audit_for_" + this.domain);
        if (appender == null) {
            appender = ((JdbcAppender.Builder)((JdbcAppender.Builder)JdbcAppender.newBuilder().setName("audit_for_" + this.domain)).setIgnoreExceptions(false)).setConnectionSource((ConnectionSource)new DataSourceConnectionSource(this.domain, (DataSource)this.domainHolder.getDomains().get(this.domain))).setBufferSize(0).setTableName("AuditEntry").setColumnMappings(columnMappings).build();
            appender.start();
            ctx.getConfiguration().addAppender(appender);
        }
        this.targetAppender = appender;
    }

    @Override
    public String getTargetAppenderName() {
        return null;
    }

    protected static class DataSourceConnectionSource
    extends AbstractConnectionSource {
        private final String description;
        private final DataSource dataSource;

        DataSourceConnectionSource(String domain, DataSource dataSource) {
            this.description = "dataSource{ domain=" + domain + ", value=" + dataSource + " }";
            this.dataSource = dataSource;
        }

        public Connection getConnection() throws SQLException {
            return DataSourceUtils.getConnection((DataSource)this.dataSource);
        }

        public String toString() {
            return this.description;
        }
    }
}

