/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyCR;
import org.apache.syncope.common.lib.request.AnyUR;
import org.apache.syncope.common.lib.request.BooleanReplacePatchItem;
import org.apache.syncope.common.lib.request.MembershipUR;
import org.apache.syncope.common.lib.request.PasswordPatch;
import org.apache.syncope.common.lib.request.StatusR;
import org.apache.syncope.common.lib.request.StringPatchItem;
import org.apache.syncope.common.lib.request.UserCR;
import org.apache.syncope.common.lib.request.UserUR;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.PropagationStatus;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.UserTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PatchOperation;
import org.apache.syncope.core.logic.AbstractAnyLogic;
import org.apache.syncope.core.logic.SyncopeLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.logic.api.LogicActions;
import org.apache.syncope.core.persistence.api.dao.AccessTokenDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.DelegationDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.dao.search.SearchCond;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.data.UserDataBinder;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;
import org.apache.syncope.core.provisioning.api.utils.RealmUtils;
import org.apache.syncope.core.provisioning.java.utils.TemplateUtils;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.Encryptor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class UserLogic
extends AbstractAnyLogic<UserTO, UserCR, UserUR> {
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final AnySearchDAO searchDAO;
    protected final AccessTokenDAO accessTokenDAO;
    protected final DelegationDAO delegationDAO;
    protected final ConfParamOps confParamOps;
    protected final UserDataBinder binder;
    protected final UserProvisioningManager provisioningManager;
    protected final SyncopeLogic syncopeLogic;

    public UserLogic(RealmDAO realmDAO, AnyTypeDAO anyTypeDAO, TemplateUtils templateUtils, UserDAO userDAO, GroupDAO groupDAO, AnySearchDAO searchDAO, AccessTokenDAO accessTokenDAO, DelegationDAO delegationDAO, ConfParamOps confParamOps, UserDataBinder binder, UserProvisioningManager provisioningManager, SyncopeLogic syncopeLogic) {
        super(realmDAO, anyTypeDAO, templateUtils);
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.searchDAO = searchDAO;
        this.accessTokenDAO = accessTokenDAO;
        this.delegationDAO = delegationDAO;
        this.confParamOps = confParamOps;
        this.binder = binder;
        this.provisioningManager = provisioningManager;
        this.syncopeLogic = syncopeLogic;
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('MUST_CHANGE_PASSWORD'))")
    @Transactional(readOnly=true)
    public Triple<String, String, UserTO> selfRead() {
        UserTO authenticatedUser = this.binder.getAuthenticatedUserTO();
        return Triple.of((Object)POJOHelper.serialize((Object)AuthContextUtils.getAuthorizations()), (Object)POJOHelper.serialize((Object)this.delegationDAO.findValidDelegating(authenticatedUser.getKey())), (Object)authenticatedUser);
    }

    @Override
    @PreAuthorize(value="hasRole('USER_READ')")
    @Transactional(readOnly=true)
    public UserTO read(String key) {
        return this.binder.getUserTO(key);
    }

    @Override
    @PreAuthorize(value="hasRole('USER_SEARCH')")
    @Transactional(readOnly=true)
    public Pair<Integer, List<UserTO>> search(SearchCond searchCond, int page, int size, List<OrderByClause> orderBy, String realm, boolean recursive, boolean details) {
        Realm base = Optional.ofNullable(this.realmDAO.findByFullPath(realm)).orElseThrow(() -> new NotFoundException("Realm " + realm));
        Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_SEARCH")), (String)realm);
        SearchCond effectiveCond = searchCond == null ? this.userDAO.getAllMatchingCond() : searchCond;
        int count = this.searchDAO.count(base, recursive, authRealms, effectiveCond, AnyTypeKind.USER);
        List matching = this.searchDAO.search(base, recursive, authRealms, effectiveCond, page, size, orderBy, AnyTypeKind.USER);
        List result = matching.stream().map(user -> this.binder.getUserTO(user, details)).collect(Collectors.toList());
        return Pair.of((Object)count, result);
    }

    @PreAuthorize(value="isAnonymous() or hasRole('ANONYMOUS')")
    public ProvisioningResult<UserTO> selfCreate(UserCR createReq, boolean nullPriorityAsync) {
        return this.doCreate(createReq, true, nullPriorityAsync);
    }

    @PreAuthorize(value="hasRole('USER_CREATE')")
    public ProvisioningResult<UserTO> create(UserCR createReq, boolean nullPriorityAsync) {
        return this.doCreate(createReq, false, nullPriorityAsync);
    }

    protected ProvisioningResult<UserTO> doCreate(UserCR userCR, boolean self, boolean nullPriorityAsync) {
        Pair<UserCR, List<LogicActions>> before = this.beforeCreate(userCR);
        if (((UserCR)before.getLeft()).getRealm() == null) {
            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRealm);
        }
        if (!self) {
            Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_CREATE")), (String)((UserCR)before.getLeft()).getRealm());
            this.userDAO.securityChecks(authRealms, null, ((UserCR)before.getLeft()).getRealm(), (Collection)((UserCR)before.getLeft()).getMemberships().stream().filter(Objects::nonNull).map(MembershipTO::getGroupKey).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        Pair created = this.provisioningManager.create((AnyCR)((UserCR)before.getLeft()), nullPriorityAsync, AuthContextUtils.getUsername(), "REST");
        return this.afterCreate(this.binder.getUserTO((String)created.getKey()), (List)created.getRight(), (List)before.getRight());
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS')) and not(hasRole('MUST_CHANGE_PASSWORD'))")
    public ProvisioningResult<UserTO> selfUpdate(UserUR userUR, boolean nullPriorityAsync) {
        UserTO userTO = this.binder.getAuthenticatedUserTO();
        userUR.setKey(userTO.getKey());
        ProvisioningResult<UserTO> updated = this.doUpdate(userUR, true, nullPriorityAsync);
        List<String> authStatuses = List.of((String[])this.confParamOps.get(AuthContextUtils.getDomain(), "authentication.statuses", (Object)new String[0], String[].class));
        if (!authStatuses.contains(((UserTO)updated.getEntity()).getStatus())) {
            Optional.ofNullable(this.accessTokenDAO.findByOwner(((UserTO)updated.getEntity()).getUsername())).map(Entity::getKey).ifPresent(arg_0 -> ((AccessTokenDAO)this.accessTokenDAO).delete(arg_0));
        }
        return updated;
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public ProvisioningResult<UserTO> update(UserUR userUR, boolean nullPriorityAsync) {
        return this.doUpdate(userUR, false, nullPriorityAsync);
    }

    protected Set<String> groups(UserTO userTO) {
        return userTO.getMemberships().stream().filter(Objects::nonNull).map(MembershipTO::getGroupKey).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected ProvisioningResult<UserTO> doUpdate(UserUR userUR, boolean self, boolean nullPriorityAsync) {
        UserTO userTO = this.binder.getUserTO(userUR.getKey());
        Pair<UserUR, List<LogicActions>> before = this.beforeUpdate(userUR, userTO.getRealm());
        Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_UPDATE")), (String)userTO.getRealm());
        if (!self) {
            Set<String> groups = this.groups(userTO);
            groups.removeAll(userUR.getMemberships().stream().filter(Objects::nonNull).filter(m -> m.getOperation() == PatchOperation.DELETE).map(MembershipUR::getGroup).filter(Objects::nonNull).collect(Collectors.toSet()));
            this.userDAO.securityChecks(authRealms, ((UserUR)before.getLeft()).getKey(), userTO.getRealm(), groups);
        }
        Pair after = this.provisioningManager.update((UserUR)before.getLeft(), nullPriorityAsync, AuthContextUtils.getUsername(), "REST");
        ProvisioningResult<UserTO> result = this.afterUpdate(this.binder.getUserTO(((UserUR)after.getLeft()).getKey()), (List)after.getRight(), (List)before.getRight());
        return result;
    }

    protected Pair<String, List<PropagationStatus>> setStatusOnWfAdapter(StatusR statusR, boolean nullPriorityAsync) {
        Pair updated;
        switch (statusR.getType()) {
            case SUSPEND: {
                updated = this.provisioningManager.suspend(statusR, nullPriorityAsync, AuthContextUtils.getUsername(), "REST");
                break;
            }
            case REACTIVATE: {
                updated = this.provisioningManager.reactivate(statusR, nullPriorityAsync, AuthContextUtils.getUsername(), "REST");
                break;
            }
            default: {
                updated = this.provisioningManager.activate(statusR, nullPriorityAsync, AuthContextUtils.getUsername(), "REST");
            }
        }
        return updated;
    }

    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public ProvisioningResult<UserTO> status(StatusR statusR, boolean nullPriorityAsync) {
        UserTO toUpdate = this.binder.getUserTO(statusR.getKey());
        Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_UPDATE")), (String)toUpdate.getRealm());
        this.userDAO.securityChecks(authRealms, toUpdate.getKey(), toUpdate.getRealm(), this.groups(toUpdate));
        statusR.setKey(toUpdate.getKey());
        Pair<String, List<PropagationStatus>> updated = this.setStatusOnWfAdapter(statusR, nullPriorityAsync);
        return this.afterUpdate(this.binder.getUserTO((String)updated.getKey()), (List)updated.getRight(), List.of());
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('MUST_CHANGE_PASSWORD'))")
    public ProvisioningResult<UserTO> selfStatus(StatusR statusR, boolean nullPriorityAsync) {
        statusR.setKey(this.userDAO.findKey(AuthContextUtils.getUsername()));
        Pair<String, List<PropagationStatus>> updated = this.setStatusOnWfAdapter(statusR, nullPriorityAsync);
        return this.afterUpdate(this.binder.getUserTO((String)updated.getKey()), (List)updated.getRight(), List.of());
    }

    @PreAuthorize(value="hasRole('MUST_CHANGE_PASSWORD')")
    public ProvisioningResult<UserTO> mustChangePassword(String password, boolean nullPriorityAsync) {
        UserTO userTO = this.binder.getAuthenticatedUserTO();
        UserUR userUR = (UserUR)new UserUR.Builder(userTO.getKey()).password((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().value((Object)password)).onSyncope(true).resources(this.userDAO.findAllResourceKeys(userTO.getKey())).build()).mustChangePassword((BooleanReplacePatchItem)((BooleanReplacePatchItem.Builder)new BooleanReplacePatchItem.Builder().value((Object)false)).build()).build();
        ProvisioningResult<UserTO> result = this.selfUpdate(userUR, nullPriorityAsync);
        Optional.ofNullable(this.accessTokenDAO.findByOwner(((UserTO)result.getEntity()).getUsername())).map(Entity::getKey).ifPresent(arg_0 -> ((AccessTokenDAO)this.accessTokenDAO).delete(arg_0));
        return result;
    }

    @PreAuthorize(value="isAnonymous() or hasRole('ANONYMOUS')")
    @Transactional
    public void requestPasswordReset(String username, String securityAnswer) {
        if (username == null) {
            throw new NotFoundException("Null username");
        }
        User user = this.userDAO.findByUsername(username);
        if (user == null) {
            throw new NotFoundException("User " + username);
        }
        if (this.syncopeLogic.isPwdResetRequiringSecurityQuestions() && (securityAnswer == null || !Encryptor.getInstance().verify(securityAnswer, user.getCipherAlgorithm(), user.getSecurityAnswer()))) {
            throw SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidSecurityAnswer);
        }
        this.provisioningManager.requestPasswordReset(user.getKey(), AuthContextUtils.getUsername(), "REST");
    }

    @PreAuthorize(value="isAnonymous() or hasRole('ANONYMOUS')")
    @Transactional
    public void confirmPasswordReset(String token, String password) {
        User user = this.userDAO.findByToken(token);
        if (user == null) {
            throw new NotFoundException("User with token " + token);
        }
        this.provisioningManager.confirmPasswordReset(user.getKey(), token, password, AuthContextUtils.getUsername(), "REST");
    }

    @PreAuthorize(value="isAuthenticated() and not(hasRole('ANONYMOUS')) and not(hasRole('MUST_CHANGE_PASSWORD'))")
    public ProvisioningResult<UserTO> selfDelete(boolean nullPriorityAsync) {
        return this.doDelete(this.binder.getAuthenticatedUserTO(), true, nullPriorityAsync);
    }

    @Override
    @PreAuthorize(value="hasRole('USER_DELETE')")
    public ProvisioningResult<UserTO> delete(String key, boolean nullPriorityAsync) {
        return this.doDelete(this.binder.getUserTO(key), false, nullPriorityAsync);
    }

    protected ProvisioningResult<UserTO> doDelete(UserTO userTO, boolean self, boolean nullPriorityAsync) {
        UserTO deletedTO;
        List ownedGroups;
        Pair<UserTO, List<LogicActions>> before = this.beforeDelete(userTO);
        if (!self) {
            Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_DELETE")), (String)((UserTO)before.getLeft()).getRealm());
            this.userDAO.securityChecks(authRealms, ((UserTO)before.getLeft()).getKey(), ((UserTO)before.getLeft()).getRealm(), this.groups((UserTO)before.getLeft()));
        }
        if (!(ownedGroups = this.groupDAO.findOwnedByUser(((UserTO)before.getLeft()).getKey())).isEmpty()) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.GroupOwnership);
            sce.getElements().addAll(ownedGroups.stream().map(group -> group.getKey() + " " + group.getName()).collect(Collectors.toList()));
            throw sce;
        }
        List statuses = this.provisioningManager.delete(((UserTO)before.getLeft()).getKey(), nullPriorityAsync, AuthContextUtils.getUsername(), "REST");
        if (this.userDAO.find(((UserTO)before.getLeft()).getKey()) == null) {
            deletedTO = new UserTO();
            deletedTO.setKey(((UserTO)before.getLeft()).getKey());
        } else {
            deletedTO = this.binder.getUserTO(((UserTO)before.getLeft()).getKey());
        }
        return this.afterDelete(deletedTO, statuses, (List)before.getRight());
    }

    protected void updateChecks(String key) {
        User user = (User)this.userDAO.authFind(key);
        Set authRealms = RealmUtils.getEffective((Set)((Set)AuthContextUtils.getAuthorizations().get("USER_UPDATE")), (String)user.getRealm().getFullPath());
        this.userDAO.securityChecks(authRealms, user.getKey(), user.getRealm().getFullPath(), (Collection)user.getMemberships().stream().map(m -> ((Group)m.getRightEnd()).getKey()).collect(Collectors.toSet()));
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public UserTO unlink(String key, Collection<String> resources) {
        this.updateChecks(key);
        UserUR req = (UserUR)((UserUR.Builder)new UserUR.Builder(key).resources((Collection)resources.stream().map(r -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(r)).build()).collect(Collectors.toList()))).build();
        return this.binder.getUserTO(this.provisioningManager.unlink((AnyUR)req, AuthContextUtils.getUsername(), "REST"));
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public UserTO link(String key, Collection<String> resources) {
        this.updateChecks(key);
        UserUR req = (UserUR)((UserUR.Builder)new UserUR.Builder(key).resources((Collection)resources.stream().map(r -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(r)).build()).collect(Collectors.toList()))).build();
        return this.binder.getUserTO(this.provisioningManager.link((AnyUR)req, AuthContextUtils.getUsername(), "REST"));
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public ProvisioningResult<UserTO> unassign(String key, Collection<String> resources, boolean nullPriorityAsync) {
        this.updateChecks(key);
        UserUR req = (UserUR)((UserUR.Builder)new UserUR.Builder(key).resources((Collection)resources.stream().map(r -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.DELETE)).value(r)).build()).collect(Collectors.toList()))).build();
        return this.update(req, nullPriorityAsync);
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public ProvisioningResult<UserTO> assign(String key, Collection<String> resources, boolean changepwd, String password, boolean nullPriorityAsync) {
        this.updateChecks(key);
        UserUR req = (UserUR)((UserUR.Builder)new UserUR.Builder(key).resources((Collection)resources.stream().map(r -> (StringPatchItem)((StringPatchItem.Builder)((StringPatchItem.Builder)new StringPatchItem.Builder().operation(PatchOperation.ADD_REPLACE)).value(r)).build()).collect(Collectors.toList()))).build();
        if (changepwd) {
            req.setPassword((PasswordPatch)((PasswordPatch.Builder)new PasswordPatch.Builder().value((Object)password)).onSyncope(false).resources(resources).build());
        }
        return this.update(req, nullPriorityAsync);
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public ProvisioningResult<UserTO> deprovision(String key, Collection<String> resources, boolean nullPriorityAsync) {
        this.updateChecks(key);
        List statuses = this.provisioningManager.deprovision(key, resources, nullPriorityAsync, AuthContextUtils.getUsername());
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getUserTO(key));
        result.getPropagationStatuses().addAll(statuses);
        return result;
    }

    @Override
    @PreAuthorize(value="hasRole('USER_UPDATE')")
    public ProvisioningResult<UserTO> provision(String key, Collection<String> resources, boolean changePwd, String password, boolean nullPriorityAsync) {
        this.updateChecks(key);
        List statuses = this.provisioningManager.provision(key, changePwd, password, resources, nullPriorityAsync, AuthContextUtils.getUsername());
        ProvisioningResult result = new ProvisioningResult();
        result.setEntity((EntityTO)this.binder.getUserTO(key));
        result.getPropagationStatuses().addAll(statuses);
        return result;
    }

    @Override
    protected UserTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if ("requestPasswordReset".equals(method.getName())) {
            key = this.userDAO.findKey((String)args[0]);
        } else if (!"confirmPasswordReset".equals(method.getName()) && ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (args[i] instanceof UserTO) {
                    key = ((UserTO)args[i]).getKey();
                    continue;
                }
                if (args[i] instanceof UserUR) {
                    key = ((UserUR)args[i]).getKey();
                    continue;
                }
                if (!(args[i] instanceof StatusR)) continue;
                key = ((StatusR)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                return this.binder.getUserTO(key);
            }
            catch (Throwable ignore) {
                LOG.debug("Unresolved reference", ignore);
                throw new UnresolvedReferenceException(ignore);
            }
        }
        throw new UnresolvedReferenceException();
    }
}

