/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.keymaster.client.zookeeper;

import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ZookeeperServiceOps
implements ServiceOps {
    protected static final Logger LOG = LoggerFactory.getLogger(ServiceOps.class);
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected static final String SERVICE_PATH = "/services";
    @Autowired
    protected CuratorFramework client;

    protected static String buildServicePath(NetworkService.Type serviceType, String ... parts) {
        String prefix = "/services/" + serviceType.name();
        Object suffix = "";
        if (parts != null && parts.length > 0) {
            suffix = "/" + String.join((CharSequence)"/", parts);
        }
        return prefix + (String)suffix;
    }

    public void register(NetworkService service) {
        String id = UUID.randomUUID().toString();
        try {
            this.unregister(service);
            if (this.client.checkExists().forPath(ZookeeperServiceOps.buildServicePath(service.getType(), id)) == null) {
                ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentContainersIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(ZookeeperServiceOps.buildServicePath(service.getType(), id));
            }
            this.client.setData().forPath(ZookeeperServiceOps.buildServicePath(service.getType(), id), MAPPER.writeValueAsBytes((Object)service));
        }
        catch (Exception e) {
            LOG.error("While writing {}", (Object)ZookeeperServiceOps.buildServicePath(service.getType(), id), (Object)e);
            throw new KeymasterException((Throwable)e);
        }
    }

    public void unregister(NetworkService service) {
        try {
            if (this.client.checkExists().forPath(ZookeeperServiceOps.buildServicePath(service.getType(), new String[0])) != null) {
                ((List)this.client.getChildren().forPath(ZookeeperServiceOps.buildServicePath(service.getType(), new String[0]))).stream().filter(child -> {
                    try {
                        return ((NetworkService)MAPPER.readValue((byte[])this.client.getData().forPath(ZookeeperServiceOps.buildServicePath(service.getType(), child)), NetworkService.class)).equals((Object)service);
                    }
                    catch (Exception e) {
                        LOG.error("While deregistering {}", (Object)service, (Object)e);
                        throw new KeymasterException((Throwable)e);
                    }
                }).findFirst().ifPresent(child -> {
                    try {
                        this.client.delete().forPath(ZookeeperServiceOps.buildServicePath(service.getType(), child));
                    }
                    catch (Exception e) {
                        LOG.error("While deregistering {}", (Object)service, (Object)e);
                        throw new KeymasterException((Throwable)e);
                    }
                });
            }
        }
        catch (KeymasterException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KeymasterException((Throwable)e);
        }
    }

    public List<NetworkService> list(NetworkService.Type serviceType) {
        try {
            if (this.client.checkExists().forPath(ZookeeperServiceOps.buildServicePath(serviceType, new String[0])) == null) {
                this.client.create().creatingParentContainersIfNeeded().forPath(ZookeeperServiceOps.buildServicePath(serviceType, new String[0]));
            }
            ArrayList<NetworkService> list = new ArrayList<NetworkService>();
            for (String child : (List)this.client.getChildren().forPath(ZookeeperServiceOps.buildServicePath(serviceType, new String[0]))) {
                list.add((NetworkService)MAPPER.readValue((byte[])this.client.getData().forPath(ZookeeperServiceOps.buildServicePath(serviceType, child)), NetworkService.class));
            }
            return list;
        }
        catch (Exception e) {
            throw new KeymasterException((Throwable)e);
        }
    }

    public NetworkService get(NetworkService.Type serviceType) {
        List<NetworkService> list = this.list(serviceType);
        if (list.isEmpty()) {
            throw new KeymasterException("No registered services for type " + serviceType);
        }
        return list.get(0);
    }
}

