/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web.controllers.dynareg;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.oidc.OidcConfigurationContext;
import org.apereo.cas.oidc.dynareg.OidcClientRegistrationRequest;
import org.apereo.cas.services.DefaultRegisteredServiceContact;
import org.apereo.cas.services.DefaultRegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.OidcSubjectTypes;
import org.apereo.cas.services.PairwiseOidcRegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.RegisteredServiceMultifactorPolicy;
import org.apereo.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.hjson.JsonValue;
import org.jose4j.jwk.JsonWebKeySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;

public class OidcClientRegistrationRequestTranslator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcClientRegistrationRequestTranslator.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private static final int GENERATED_CLIENT_NAME_LENGTH = 8;
    private final OidcConfigurationContext context;

    public OidcRegisteredService translate(OidcClientRegistrationRequest registrationRequest, Optional<OidcRegisteredService> givenService) throws Exception {
        boolean containsFragment = registrationRequest.getRedirectUris().stream().anyMatch(uri -> uri.contains("#"));
        if (containsFragment) {
            throw new IllegalArgumentException("Redirect URI cannot contain a fragment");
        }
        ServicesManager servicesManager = this.context.getServicesManager();
        OidcRegisteredService registeredService = givenService.orElseGet(() -> registrationRequest.getRedirectUris().stream().map(uri -> (OidcRegisteredService)OAuth20Utils.getRegisteredOAuthServiceByRedirectUri((ServicesManager)servicesManager, (String)uri)).filter(Objects::nonNull).findFirst().orElseGet(OidcRegisteredService::new));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getClientName())) {
            registeredService.setName(registrationRequest.getClientName());
        } else if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registeredService.getName())) {
            registeredService.setName(RandomUtils.randomAlphabetic((int)8));
        }
        String serviceId = String.join((CharSequence)"|", registrationRequest.getRedirectUris());
        registeredService.setServiceId(serviceId);
        registeredService.setSectorIdentifierUri(registrationRequest.getSectorIdentifierUri());
        registeredService.setSubjectType(registrationRequest.getSubjectType());
        if (org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)OidcSubjectTypes.PAIRWISE.getType(), (CharSequence)registeredService.getSubjectType())) {
            registeredService.setUsernameAttributeProvider((RegisteredServiceUsernameAttributeProvider)new PairwiseOidcRegisteredServiceUsernameAttributeProvider());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getJwksUri())) {
            registeredService.setJwks(registrationRequest.getJwksUri());
        } else {
            JsonWebKeySet jwks = registrationRequest.getJwks();
            if (jwks != null && !jwks.getJsonWebKeys().isEmpty()) {
                jwks.getJsonWebKeys().stream().filter(key -> org.apache.commons.lang3.StringUtils.isBlank((CharSequence)key.getKeyId())).forEach(key -> key.setKeyId(RandomUtils.randomAlphabetic((int)6)));
                registeredService.setJwks(jwks.toJson());
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getTokenEndpointAuthMethod())) {
            registeredService.setTokenEndpointAuthenticationMethod(registrationRequest.getTokenEndpointAuthMethod());
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registeredService.getClientId())) {
            registeredService.setClientId(this.context.getClientIdGenerator().getNewString());
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registeredService.getClientSecret())) {
            registeredService.setClientSecret(this.context.getClientSecretGenerator().getNewString());
        }
        registeredService.setEvaluationOrder(0);
        String urls = StringUtils.collectionToCommaDelimitedString(registrationRequest.getPostLogoutRedirectUris());
        registeredService.setLogoutUrl(urls);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getLogo())) {
            registeredService.setLogo(registrationRequest.getLogo());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getPolicyUri())) {
            registeredService.setInformationUrl(registrationRequest.getPolicyUri());
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getTermsOfUseUri())) {
            registeredService.setPrivacyUrl(registrationRequest.getTermsOfUseUri());
        }
        if (!org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)"none", (CharSequence)registrationRequest.getUserInfoSignedReponseAlg())) {
            registeredService.setUserInfoSigningAlg(registrationRequest.getUserInfoSignedReponseAlg());
        }
        registeredService.setUserInfoEncryptedResponseAlg(registrationRequest.getUserInfoEncryptedResponseAlg());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registeredService.getUserInfoEncryptedResponseAlg())) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)registrationRequest.getUserInfoEncryptedResponseEncoding())) {
                registeredService.setUserInfoEncryptedResponseEncoding("A128CBC-HS256");
            } else {
                registeredService.setUserInfoEncryptedResponseEncoding(registrationRequest.getUserInfoEncryptedResponseEncoding());
            }
        }
        CasConfigurationProperties properties = this.context.getCasProperties();
        HashSet supportedScopes = new HashSet(properties.getAuthn().getOidc().getDiscovery().getScopes());
        registeredService.setScopes(supportedScopes);
        LinkedHashSet processedScopes = new LinkedHashSet(supportedScopes);
        registeredService.setScopes(processedScopes);
        if (!registrationRequest.getDefaultAcrValues().isEmpty()) {
            DefaultRegisteredServiceMultifactorPolicy multifactorPolicy = new DefaultRegisteredServiceMultifactorPolicy();
            multifactorPolicy.setMultifactorAuthenticationProviders(new HashSet<String>(registrationRequest.getDefaultAcrValues()));
            registeredService.setMultifactorAuthenticationPolicy((RegisteredServiceMultifactorPolicy)multifactorPolicy);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getIdTokenSignedResponseAlg())) {
            registeredService.setIdTokenSigningAlg(registrationRequest.getIdTokenSignedResponseAlg());
            registeredService.setSignIdToken(true);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getIdTokenEncryptedResponseAlg())) {
            registeredService.setIdTokenEncryptionAlg(registrationRequest.getIdTokenEncryptedResponseAlg());
            registeredService.setEncryptIdToken(true);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getIdTokenEncryptedResponseEncoding())) {
            registeredService.setIdTokenEncryptionEncoding(registrationRequest.getIdTokenEncryptedResponseEncoding());
            registeredService.setEncryptIdToken(true);
        }
        registeredService.getContacts().clear();
        registrationRequest.getContacts().forEach(c -> {
            DefaultRegisteredServiceContact contact = new DefaultRegisteredServiceContact();
            if (c.contains("@")) {
                contact.setEmail(c);
                contact.setName(c.substring(0, c.indexOf(64)));
            } else {
                contact.setName(c);
            }
            registeredService.getContacts().add(contact);
        });
        long clientSecretExp = Beans.newDuration((String)this.context.getCasProperties().getAuthn().getOidc().getRegistration().getClientSecretExpiration()).toSeconds();
        if (clientSecretExp > 0L && registeredService.getClientSecretExpiration() <= 0L) {
            ZonedDateTime currentTime = ZonedDateTime.now(ZoneOffset.UTC);
            ZonedDateTime expirationDate = currentTime.plusSeconds(clientSecretExp);
            LOGGER.debug("Client secret shall expire at [{}] while now is [{}]", (Object)expirationDate, (Object)currentTime);
            registeredService.setClientSecretExpiration(expirationDate.toEpochSecond());
        }
        registeredService.setDescription("Registered service ".concat(registeredService.getName()));
        this.validate(registrationRequest, registeredService);
        return registeredService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(OidcClientRegistrationRequest registrationRequest, OidcRegisteredService registeredService) throws Exception {
        OidcProperties oidc;
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registeredService.getSectorIdentifierUri())) {
            HttpResponse sectorResponse;
            block6: {
                sectorResponse = null;
                try {
                    HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().method(HttpMethod.GET).url(registeredService.getSectorIdentifierUri()).build();
                    sectorResponse = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
                    if (sectorResponse == null || sectorResponse.getStatusLine().getStatusCode() != 200) break block6;
                    String result = IOUtils.toString((InputStream)sectorResponse.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
                    JavaType expectedType = MAPPER.getTypeFactory().constructParametricType(List.class, new Class[]{String.class});
                    Object urls = MAPPER.readValue(JsonValue.readHjson((String)result).toString(), expectedType);
                    if (urls.equals(registrationRequest.getRedirectUris())) break block6;
                    throw new IllegalArgumentException("Invalid sector identifier uri");
                }
                catch (Throwable throwable) {
                    HttpUtils.close(sectorResponse);
                    throw throwable;
                }
            }
            HttpUtils.close((HttpResponse)sectorResponse);
        }
        if (!(oidc = this.context.getCasProperties().getAuthn().getOidc()).getRegistration().getDynamicClientRegistrationMode().isProtected() && (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getPolicyUri()) || org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getLogo()))) {
            String policy;
            String logo;
            List hosts = registrationRequest.getRedirectUris().stream().map(uri -> (String)FunctionUtils.doUnchecked(() -> new URI((String)uri).getHost())).collect(Collectors.toList());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getLogo()) && !hosts.contains(logo = new URI(registrationRequest.getLogo()).getHost())) {
                throw new IllegalArgumentException("Invalid logo uri from an unknown host");
            }
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)registrationRequest.getPolicyUri()) && !hosts.contains(policy = new URI(registrationRequest.getPolicyUri()).getHost())) {
                throw new IllegalArgumentException("Invalid policy uri from an unknown host");
            }
        }
    }

    @Generated
    public OidcClientRegistrationRequestTranslator(OidcConfigurationContext context) {
        this.context = context;
    }
}

