/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.web;

import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20AccessTokenResponseResult;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20DefaultAccessTokenResponseGenerator;
import org.apereo.cas.support.oauth.web.response.accesstoken.response.OAuth20JwtAccessTokenEncoder;
import org.apereo.cas.ticket.IdTokenGeneratorService;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.token.JwtBuilder;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcAccessTokenResponseGenerator
extends OAuth20DefaultAccessTokenResponseGenerator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcAccessTokenResponseGenerator.class);
    protected final IdTokenGeneratorService idTokenGenerator;
    private final OidcIssuerService oidcIssuerService;

    public OidcAccessTokenResponseGenerator(IdTokenGeneratorService idTokenGenerator, JwtBuilder jwtBuilder, CasConfigurationProperties casProperties, OidcIssuerService oidcIssuerService) {
        super(jwtBuilder, casProperties);
        this.idTokenGenerator = idTokenGenerator;
        this.oidcIssuerService = oidcIssuerService;
    }

    protected OAuth20JwtAccessTokenEncoder.OAuth20JwtAccessTokenEncoderBuilder getAccessTokenBuilder(OAuth20AccessToken accessToken, OAuth20AccessTokenResponseResult result) {
        OAuth20JwtAccessTokenEncoder.OAuth20JwtAccessTokenEncoderBuilder builder = super.getAccessTokenBuilder(accessToken, result);
        Optional<OidcRegisteredService> service = Optional.ofNullable(result.getRegisteredService()).filter(OidcRegisteredService.class::isInstance).map(OidcRegisteredService.class::cast);
        return builder.issuer(this.oidcIssuerService.determineIssuer(service));
    }

    protected Map<String, Object> getAccessTokenResponseModel(OAuth20AccessTokenResponseResult result) {
        Map model = super.getAccessTokenResponseModel(result);
        Optional accessToken = result.getGeneratedToken().getAccessToken();
        accessToken.ifPresent(Unchecked.consumer(token -> {
            if (!token.getScopes().contains("client_registration_scope")) {
                OidcRegisteredService oidcRegisteredService = (OidcRegisteredService)result.getRegisteredService();
                String idToken = this.idTokenGenerator.generate((OAuth20AccessToken)accessToken.get(), result.getUserProfile(), result.getResponseType(), result.getGrantType(), (OAuthRegisteredService)oidcRegisteredService);
                LOGGER.debug("Generated ID token [{}]", (Object)idToken);
                model.put("id_token", idToken);
            }
        }));
        return model;
    }
}

