/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.token;

import com.github.benmanes.caffeine.cache.LoadingCache;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import java.security.Key;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.oidc.issuer.OidcIssuerService;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyCacheKey;
import org.apereo.cas.oidc.jwks.OidcJsonWebKeyUsage;
import org.apereo.cas.oidc.jwks.rotation.OidcJsonWebKeystoreRotationService;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.ticket.BaseTokenSigningAndEncryptionService;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwt.JwtClaims;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseOidcJsonWebKeyTokenSigningAndEncryptionService
extends BaseTokenSigningAndEncryptionService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseOidcJsonWebKeyTokenSigningAndEncryptionService.class);
    protected final LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> defaultJsonWebKeystoreCache;
    protected final LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> serviceJsonWebKeystoreCache;
    protected final OidcIssuerService issuerService;

    public String encode(OAuthRegisteredService service, JwtClaims claims) {
        return (String)FunctionUtils.doUnchecked(() -> {
            LOGGER.trace("Attempting to produce token generated for service [{}] with claims [{}]", (Object)service, (Object)claims.toJson());
            String innerJwt = this.signTokenIfNecessary(claims, service);
            if (this.shouldEncryptToken(service)) {
                innerJwt = this.encryptToken(service, innerJwt);
            }
            return innerJwt;
        });
    }

    public JwtClaims decode(String token, Optional<OAuthRegisteredService> service) {
        return (JwtClaims)Unchecked.supplier(() -> {
            JWT jwt;
            if (service.isPresent() && (jwt = JWTParser.parse((String)token)) instanceof EncryptedJWT) {
                PublicJsonWebKey encryptionKey = this.getJsonWebKeyForEncryption((OAuthRegisteredService)service.get());
                String decoded = EncodingUtils.decryptJwtValue((Key)encryptionKey.getPrivateKey(), (String)token);
                return super.decode(decoded, service);
            }
            return super.decode(token, service);
        }, throwable -> {
            throw new IllegalArgumentException((Throwable)throwable);
        }).get();
    }

    public String resolveIssuer(Optional<OAuthRegisteredService> service) {
        Optional<OidcRegisteredService> filter = service.filter(svc -> svc instanceof OidcRegisteredService).map(OidcRegisteredService.class::cast).stream().findFirst();
        return this.issuerService.determineIssuer(filter);
    }

    protected abstract String encryptToken(OAuthRegisteredService var1, String var2);

    protected PublicJsonWebKey getJsonWebKeySigningKey() {
        String iss = this.issuerService.determineIssuer(Optional.empty());
        LOGGER.trace("Using issuer [{}] to locate JWK signing key", (Object)iss);
        Optional jwks = (Optional)this.defaultJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey(iss, OidcJsonWebKeyUsage.SIGNING));
        if (Objects.requireNonNull(jwks).isEmpty()) {
            throw new IllegalArgumentException("No signing key could be found for issuer " + iss);
        }
        return (PublicJsonWebKey)((JsonWebKeySet)jwks.get()).getJsonWebKeys().get(0);
    }

    protected PublicJsonWebKey getJsonWebKeyForEncryption(OAuthRegisteredService svc) {
        LOGGER.debug("Service [{}] is set to encrypt tokens", (Object)svc);
        Optional jwks = (Optional)this.serviceJsonWebKeystoreCache.get((Object)new OidcJsonWebKeyCacheKey(svc, OidcJsonWebKeyUsage.ENCRYPTION));
        if (Objects.requireNonNull(jwks).isEmpty()) {
            throw new IllegalArgumentException("Service " + svc.getServiceId() + " with client id " + svc.getClientId() + " is configured to encrypt tokens, yet no JSON web key is available to handle encryption");
        }
        JsonWebKey jsonWebKey = ((JsonWebKeySet)jwks.get()).getJsonWebKeys().stream().filter(key -> OidcJsonWebKeystoreRotationService.JsonWebKeyLifecycleStates.getJsonWebKeyState(key).isCurrent()).min(Comparator.comparing(JsonWebKey::getKeyId)).orElseThrow(() -> new IllegalArgumentException("Cannot locate current JSON web key for encryption"));
        LOGGER.debug("Found JSON web key to encrypt the token: [{}]", (Object)jsonWebKey);
        Objects.requireNonNull(jsonWebKey.getKey(), "JSON web key used to encrypt the token has no associated public key");
        return (PublicJsonWebKey)jsonWebKey;
    }

    private String signTokenIfNecessary(JwtClaims claims, OAuthRegisteredService svc) {
        if (this.shouldSignToken(svc)) {
            LOGGER.debug("Fetching JSON web key to sign the token for : [{}]", (Object)svc.getClientId());
            PublicJsonWebKey jsonWebKey = this.getJsonWebKeySigningKey();
            LOGGER.debug("Found JSON web key to sign the token: [{}]", (Object)jsonWebKey);
            Objects.requireNonNull(jsonWebKey.getPrivateKey(), "JSON web key used to sign the token has no associated private key");
            return this.signToken(svc, claims, jsonWebKey);
        }
        JWTClaimsSet claimSet = JwtBuilder.parse((String)claims.toJson());
        return JwtBuilder.buildPlain((JWTClaimsSet)claimSet, Optional.of(svc));
    }

    @Generated
    protected BaseOidcJsonWebKeyTokenSigningAndEncryptionService(LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> defaultJsonWebKeystoreCache, LoadingCache<OidcJsonWebKeyCacheKey, Optional<JsonWebKeySet>> serviceJsonWebKeystoreCache, OidcIssuerService issuerService) {
        this.defaultJsonWebKeystoreCache = defaultJsonWebKeystoreCache;
        this.serviceJsonWebKeystoreCache = serviceJsonWebKeystoreCache;
        this.issuerService = issuerService;
    }
}

