/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.profile;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.oidc.OidcProperties;
import org.apereo.cas.oidc.OidcConstants;
import org.apereo.cas.oidc.claims.BaseOidcScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.claims.OidcCustomScopeAttributeReleasePolicy;
import org.apereo.cas.oidc.scopes.OidcAttributeReleasePolicyFactory;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.support.oauth.profile.DefaultOAuth20ProfileScopeToAttributesFilter;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.util.ReflectionUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class OidcProfileScopeToAttributesFilter
extends DefaultOAuth20ProfileScopeToAttributesFilter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcProfileScopeToAttributesFilter.class);
    private final Map<String, BaseOidcScopeAttributeReleasePolicy> attributeReleasePolicies = new LinkedHashMap<String, BaseOidcScopeAttributeReleasePolicy>();
    private final PrincipalFactory principalFactory;
    private final CasConfigurationProperties casProperties;
    private final Collection<OidcCustomScopeAttributeReleasePolicy> userScopes;

    public OidcProfileScopeToAttributesFilter(PrincipalFactory principalFactory, CasConfigurationProperties casProperties, OidcAttributeReleasePolicyFactory oidcAttributeReleasePolicyFactory) {
        this.principalFactory = principalFactory;
        this.casProperties = casProperties;
        this.userScopes = oidcAttributeReleasePolicyFactory.getUserDefinedScopes();
        this.configureAttributeReleasePoliciesByScope();
    }

    public Principal filter(Service service, Principal profile, RegisteredService registeredService, OAuth20AccessToken accessToken) {
        Principal principal = super.filter(service, profile, registeredService, accessToken);
        if (registeredService instanceof OidcRegisteredService) {
            LinkedHashSet<String> scopes = new LinkedHashSet<String>(accessToken.getScopes());
            if (!scopes.contains(OidcConstants.StandardScopes.OPENID.getScope())) {
                LOGGER.warn("Request does not indicate a scope [{}] that can identify an OpenID Connect request. This is a REQUIRED scope that MUST be present in the request. Given its absence, CAS will not process any attribute claims and will return the authenticated principal as is.", scopes);
                return principal;
            }
            scopes.retainAll(this.casProperties.getAuthn().getOidc().getDiscovery().getScopes());
            LOGGER.debug("Collection of scopes filtered based on discovery settings are [{}]", scopes);
            OidcRegisteredService oidcService = (OidcRegisteredService)registeredService;
            Map<String, List<Object>> attributes = this.getAttributesAllowedForService(scopes, principal, service, oidcService, accessToken);
            LOGGER.debug("Collection of attributes filtered by scopes [{}] are [{}]", scopes, attributes);
            this.filterAttributesByAccessTokenRequestedClaims(oidcService, accessToken, principal, attributes);
            LOGGER.debug("Final collection of attributes are [{}]", attributes);
            return this.principalFactory.createPrincipal(profile.getId(), attributes);
        }
        return principal;
    }

    protected void filterAttributesByAccessTokenRequestedClaims(OidcRegisteredService oidcService, OAuth20AccessToken accessToken, Principal principal, Map<String, List<Object>> attributes) {
        Set userInfo = OAuth20Utils.parseUserInfoRequestClaims((OAuth20Token)accessToken);
        if (userInfo.isEmpty()) {
            LOGGER.trace("No userinfo requested claims are available");
            return;
        }
        Map principalAttributes = accessToken.getTicketGrantingTicket().getAuthentication().getPrincipal().getAttributes();
        LOGGER.debug("Requested user-info claims [{}] are compared against principal attributes [{}]", (Object)userInfo, (Object)principalAttributes);
        userInfo.stream().filter(principalAttributes::containsKey).forEach(key -> attributes.put((String)key, (List)principalAttributes.get(key)));
    }

    protected Map<String, List<Object>> filterAttributesByScope(Collection<String> scopes, Principal principal, Service service, RegisteredService registeredService, OAuth20AccessToken accessToken) {
        if (scopes.isEmpty()) {
            Map attributes = principal.getAttributes();
            LOGGER.trace("No defined scopes are available to instruct attribute release policies for [{}]. CAS will authorize the collection of resolved attributes [{}] for release to [{}]", new Object[]{registeredService.getServiceId(), attributes, service.getId()});
            return attributes;
        }
        LinkedHashMap<String, List<Object>> attributes = new LinkedHashMap<String, List<Object>>();
        scopes.stream().distinct().filter(this.attributeReleasePolicies::containsKey).map(s -> {
            BaseOidcScopeAttributeReleasePolicy policy = this.attributeReleasePolicies.get(s);
            RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService(registeredService).service(service).principal(principal).build();
            Map policyAttr = policy.getAttributes(releasePolicyContext);
            LOGGER.debug("Calculated attributes [{}] via attribute release policy [{}]", (Object)policyAttr, (Object)policy.getName());
            return policyAttr;
        }).forEach(attributes::putAll);
        return attributes;
    }

    protected void configureAttributeReleasePoliciesByScope() {
        OidcProperties oidc = this.casProperties.getAuthn().getOidc();
        String packageName = BaseOidcScopeAttributeReleasePolicy.class.getPackage().getName();
        Collection subTypes = ReflectionUtils.findSubclassesInPackage(BaseOidcScopeAttributeReleasePolicy.class, (String)packageName);
        subTypes.forEach(Unchecked.consumer(t -> {
            if (ClassUtils.hasConstructor((Class)t, (Class[])new Class[0])) {
                BaseOidcScopeAttributeReleasePolicy ex = (BaseOidcScopeAttributeReleasePolicy)t.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (oidc.getDiscovery().getScopes().contains(ex.getScopeType())) {
                    LOGGER.trace("Found standard OpenID Connect scope [{}] to filter attributes", (Object)ex.getScopeType());
                    this.attributeReleasePolicies.put(ex.getScopeType(), ex);
                } else {
                    LOGGER.debug("OpenID Connect scope [{}] is not configured for use and will be ignored", (Object)ex.getScopeType());
                }
            }
        }));
        if (!this.userScopes.isEmpty()) {
            LOGGER.debug("Configuring attributes release policies for user-defined scopes [{}]", this.userScopes);
            this.userScopes.forEach(t -> this.attributeReleasePolicies.put(t.getScopeName(), (BaseOidcScopeAttributeReleasePolicy)t));
        }
    }

    private Map<String, List<Object>> getAttributesAllowedForService(Collection<String> scopes, Principal principal, Service service, OidcRegisteredService oidcService, OAuth20AccessToken accessToken) {
        boolean scopeFree;
        Set serviceScopes = oidcService.getScopes();
        LOGGER.trace("Scopes assigned to service definition [{}] are [{}]", (Object)oidcService.getName(), (Object)serviceScopes);
        boolean bl = scopeFree = serviceScopes.isEmpty() || serviceScopes.size() == 1 && serviceScopes.contains(OidcConstants.StandardScopes.OPENID.getScope());
        if (!scopeFree) {
            scopes.retainAll(serviceScopes);
            LOGGER.trace("Service definition [{}] will filter attributes based on scopes [{}]", (Object)oidcService.getName(), scopes);
            return this.filterAttributesByScope(scopes, principal, service, (RegisteredService)oidcService, accessToken);
        }
        LOGGER.trace("Service definition [{}] invokes the assigned attribute release policy without using scopes", (Object)oidcService.getName());
        RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)oidcService).service(service).principal(principal).build();
        return oidcService.getAttributeReleasePolicy().getAttributes(releasePolicyContext);
    }
}

