/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.eventregistry.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.flowable.eventregistry.model.EventPayload;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EventModel {
    protected String key;
    protected String name;
    protected Map<String, EventPayload> payload = new LinkedHashMap<String, EventPayload>();

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public Collection<EventPayload> getCorrelationParameters() {
        return this.payload.values().stream().filter(EventPayload::isCorrelationParameter).collect(Collectors.toList());
    }

    public EventPayload getPayload(String name) {
        return this.payload.get(name);
    }

    @JsonGetter
    public Collection<EventPayload> getPayload() {
        return this.payload.values();
    }

    @JsonSetter
    public void setPayload(Collection<EventPayload> payload) {
        for (EventPayload eventPayload : payload) {
            this.payload.put(eventPayload.getName(), eventPayload);
        }
    }

    public void addPayload(String name, String type) {
        EventPayload eventPayload = this.payload.get(name);
        if (eventPayload != null) {
            eventPayload.setType(type);
        } else {
            this.payload.put(name, new EventPayload(name, type));
        }
    }

    public void addCorrelation(String name, String type) {
        EventPayload eventPayload = this.payload.get(name);
        if (eventPayload != null) {
            eventPayload.setCorrelationParameter(true);
        } else {
            this.payload.put(name, EventPayload.correlation(name, type));
        }
    }
}

