/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint.change;

import com.datical.liquibase.ext.storedlogic.checkconstraint.CheckConstraint;
import com.datical.liquibase.ext.storedlogic.checkconstraint.change.DropCheckConstraintStatement;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.core.Table;

public class DropCheckConstraintGenerator
extends AbstractSqlGenerator<DropCheckConstraintStatement> {
    @Override
    public boolean supports(DropCheckConstraintStatement dropCheckConstraintStatement, Database database) {
        return database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase && ((MySQLDatabase)database).isMinimumMySQLVersion("8.0.16") || database instanceof AbstractDb2Database || database instanceof PostgresDatabase;
    }

    @Override
    public ValidationErrors validate(DropCheckConstraintStatement dropCheckConstraintStatement, Database object, SqlGeneratorChain sqlGeneratorChain) {
        object = new ValidationErrors();
        ((ValidationErrors)object).checkRequiredField("tableName", dropCheckConstraintStatement.getTableName());
        ((ValidationErrors)object).checkRequiredField("constraintName", dropCheckConstraintStatement.getConstraintName());
        return object;
    }

    @Override
    public Sql[] generateSql(DropCheckConstraintStatement dropCheckConstraintStatement, Database object, SqlGeneratorChain sqlGeneratorChain) {
        object = "ALTER TABLE " + object.escapeTableName(dropCheckConstraintStatement.getCatalogName(), dropCheckConstraintStatement.getSchemaName(), dropCheckConstraintStatement.getTableName()) + " DROP CONSTRAINT " + object.escapeConstraintName(dropCheckConstraintStatement.getConstraintName());
        return new Sql[]{new UnparsedSql((String)object, this.getAffectedCheckConstraint(dropCheckConstraintStatement))};
    }

    protected CheckConstraint getAffectedCheckConstraint(DropCheckConstraintStatement dropCheckConstraintStatement) {
        return new CheckConstraint().setName(dropCheckConstraintStatement.getConstraintName()).setTable((Table)new Table().setName(dropCheckConstraintStatement.getTableName()).setSchema(dropCheckConstraintStatement.getCatalogName(), dropCheckConstraintStatement.getSchemaName()));
    }
}

