/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.validation.entity;

import javax.validation.ConstraintValidatorContext;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.PlainAttrUniqueValue;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.jpa.validation.entity.AbstractValidator;
import org.apache.syncope.core.persistence.jpa.validation.entity.PlainAttrValueCheck;

public class PlainAttrValueValidator
extends AbstractValidator<PlainAttrValueCheck, PlainAttrValue> {
    public boolean isValid(PlainAttrValue value, ConstraintValidatorContext context) {
        boolean isValid;
        context.disableDefaultConstraintViolation();
        if (value == null) {
            isValid = true;
        } else {
            PlainSchema attrSchema;
            PlainSchema uniqueValueSchema;
            int nonNullVales = 0;
            if (value.getBooleanValue() != null) {
                ++nonNullVales;
            }
            if (value.getDateValue() != null) {
                ++nonNullVales;
            }
            if (value.getDoubleValue() != null) {
                ++nonNullVales;
            }
            if (value.getLongValue() != null) {
                ++nonNullVales;
            }
            if (value.getBinaryValue() != null) {
                ++nonNullVales;
            }
            if (value.getStringValue() != null) {
                ++nonNullVales;
            }
            boolean bl = isValid = nonNullVales == 1;
            if (!isValid) {
                LOG.error("More than one non-null value for " + value);
                context.buildConstraintViolationWithTemplate(PlainAttrValueValidator.getTemplate(EntityViolationType.MoreThanOneNonNull, "More than one non-null value found")).addPropertyNode(value.getClass().getSimpleName().replaceAll("\\n", " ")).addConstraintViolation();
            } else if (value instanceof PlainAttrUniqueValue && !(isValid = (uniqueValueSchema = ((PlainAttrUniqueValue)value).getSchema()).equals(attrSchema = value.getAttr().getSchema()))) {
                LOG.error("Unique value schema for " + value + " is " + uniqueValueSchema + ", while owning attribute's schema is " + attrSchema);
                context.buildConstraintViolationWithTemplate(PlainAttrValueValidator.getTemplate(EntityViolationType.InvalidPlainAttr, "Unique value schema is " + uniqueValueSchema + ", while owning attribute's schema is " + attrSchema)).addPropertyNode("schema").addConstraintViolation();
            }
        }
        return isValid;
    }
}

