/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.content;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.core.persistence.api.content.ConfParamLoader;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeymasterConfParamLoader
implements ConfParamLoader {
    protected static final Logger LOG = LoggerFactory.getLogger(KeymasterConfParamLoader.class);
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected final ConfParamOps confParamOps;

    public KeymasterConfParamLoader(ConfParamOps confParamOps) {
        this.confParamOps = confParamOps;
    }

    public int getOrder() {
        return 450;
    }

    public void load(String domain, DataSource datasource) {
        boolean existingData;
        try {
            existingData = !this.confParamOps.list(domain).isEmpty();
        }
        catch (Exception e) {
            LOG.error("[{}] Could not access Keymaster", (Object)domain, (Object)e);
            existingData = true;
        }
        if (existingData) {
            LOG.info("[{}] Data found in Keymaster, leaving untouched", (Object)domain);
        } else {
            LOG.info("[{}] Empty Keymaster found, loading default content", (Object)domain);
            try {
                InputStream contentJSON = (InputStream)ApplicationContextProvider.getBeanFactory().getBean(domain + "KeymasterConfParamsJSON", InputStream.class);
                this.loadDefaultContent(domain, contentJSON);
            }
            catch (Exception e) {
                LOG.error("[{}] While loading default Keymaster content", (Object)domain, (Object)e);
            }
        }
    }

    protected void loadDefaultContent(String domain, InputStream contentJSON) throws IOException {
        try (InputStream inputStream = contentJSON;){
            JsonNode content = MAPPER.readTree(contentJSON);
            Iterator itor = content.fields();
            while (itor.hasNext()) {
                Map.Entry param = (Map.Entry)itor.next();
                Object value = MAPPER.treeToValue((TreeNode)param.getValue(), Object.class);
                if (value == null) continue;
                this.confParamOps.set(domain, (String)param.getKey(), value);
            }
        }
    }
}

