/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.starter.actuate;

import java.sql.Connection;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class DomainsHealthIndicator
implements HealthIndicator {
    protected static final Logger LOG = LoggerFactory.getLogger(DomainsHealthIndicator.class);
    @Autowired
    protected DomainHolder domainHolder;

    public Health health() {
        Health.Builder builder = new Health.Builder();
        AtomicReference<Boolean> anyDown = new AtomicReference<Boolean>(Boolean.FALSE);
        this.domainHolder.getDomains().forEach((key, ds) -> {
            Status status;
            Connection conn = null;
            try {
                conn = DataSourceUtils.getConnection((DataSource)ds);
                status = conn.isValid(0) ? Status.UP : Status.OUT_OF_SERVICE;
            }
            catch (Exception e) {
                status = Status.DOWN;
                LOG.debug("When attempting to connect to Domain {}", key, (Object)e);
            }
            finally {
                if (conn != null) {
                    DataSourceUtils.releaseConnection((Connection)conn, (DataSource)ds);
                }
            }
            builder.withDetail(key, (Object)status);
            if (status != Status.UP) {
                anyDown.set(true);
            }
        });
        builder.status(anyDown.get() != false ? Status.DOWN : Status.UP);
        return builder.build();
    }
}

