/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.starter.actuate;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.syncope.common.keymaster.client.api.ConfParamOps;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.lib.info.JavaImplInfo;
import org.apache.syncope.common.lib.info.NumbersInfo;
import org.apache.syncope.common.lib.info.PlatformInfo;
import org.apache.syncope.common.lib.info.SystemInfo;
import org.apache.syncope.common.lib.types.EntitlementsHolder;
import org.apache.syncope.common.lib.types.ImplementationTypesHolder;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.logic.LogicProperties;
import org.apache.syncope.core.persistence.api.ImplementationLookup;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeClassDAO;
import org.apache.syncope.core.persistence.api.dao.AnyTypeDAO;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.NotificationDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrDAO;
import org.apache.syncope.core.persistence.api.dao.PlainAttrValueDAO;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.dao.RoleDAO;
import org.apache.syncope.core.persistence.api.dao.SecurityQuestionDAO;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.dao.VirSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.AnyType;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.policy.AccountPolicy;
import org.apache.syncope.core.persistence.api.entity.policy.PasswordPolicy;
import org.apache.syncope.core.persistence.jpa.PersistenceProperties;
import org.apache.syncope.core.provisioning.api.AnyObjectProvisioningManager;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.ConnIdBundleManager;
import org.apache.syncope.core.provisioning.api.GroupProvisioningManager;
import org.apache.syncope.core.provisioning.api.UserProvisioningManager;
import org.apache.syncope.core.provisioning.api.cache.VirAttrCache;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.propagation.PropagationTaskExecutor;
import org.apache.syncope.core.provisioning.java.ProvisioningProperties;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.apache.syncope.core.spring.security.PasswordGenerator;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.apache.syncope.core.starter.actuate.SyncopeCoreInfoContributor;
import org.apache.syncope.core.workflow.api.AnyObjectWorkflowAdapter;
import org.apache.syncope.core.workflow.api.GroupWorkflowAdapter;
import org.apache.syncope.core.workflow.api.UserWorkflowAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.boot.actuate.info.Info;
import org.springframework.boot.actuate.info.InfoContributor;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class DefaultSyncopeCoreInfoContributor
implements SyncopeCoreInfoContributor,
InfoContributor {
    protected static final Logger LOG = LoggerFactory.getLogger(DefaultSyncopeCoreInfoContributor.class);
    protected static final Object MONITOR = new Object();
    protected static PlatformInfo PLATFORM_INFO;
    protected static SystemInfo SYSTEM_INFO;
    protected static final Pattern THREADPOOLTASKEXECUTOR_PATTERN;
    private final SecurityProperties securityProperties;
    private final PersistenceProperties persistenceProperties;
    private final ProvisioningProperties provisioningProperties;
    private final LogicProperties logicProperties;
    private final AnyTypeDAO anyTypeDAO;
    private final AnyTypeClassDAO anyTypeClassDAO;
    private final UserDAO userDAO;
    private final GroupDAO groupDAO;
    private final AnyObjectDAO anyObjectDAO;
    private final ExternalResourceDAO resourceDAO;
    private final ConfParamOps confParamOps;
    private final ServiceOps serviceOps;
    private final ConnIdBundleManager bundleManager;
    private final PropagationTaskExecutor propagationTaskExecutor;
    private final AnyObjectWorkflowAdapter awfAdapter;
    private final UserWorkflowAdapter uwfAdapter;
    private final GroupWorkflowAdapter gwfAdapter;
    private final AnyObjectProvisioningManager aProvisioningManager;
    private final UserProvisioningManager uProvisioningManager;
    private final GroupProvisioningManager gProvisioningManager;
    private final VirAttrCache virAttrCache;
    private final NotificationManager notificationManager;
    private final AuditManager auditManager;
    private final PasswordGenerator passwordGenerator;
    private final EntityFactory entityFactory;
    private final PlainSchemaDAO plainSchemaDAO;
    private final PlainAttrDAO plainAttrDAO;
    private final PlainAttrValueDAO plainAttrValueDAO;
    private final AnySearchDAO anySearchDAO;
    private final ImplementationLookup implLookup;
    private final PolicyDAO policyDAO;
    private final NotificationDAO notificationDAO;
    private final TaskDAO taskDAO;
    private final VirSchemaDAO virSchemaDAO;
    private final RoleDAO roleDAO;
    private final SecurityQuestionDAO securityQuestionDAO;
    private final ThreadPoolTaskExecutor asyncConnectorFacadeExecutor;
    private final ThreadPoolTaskExecutor propagationTaskExecutorAsyncExecutor;

    protected static void setTaskExecutorInfo(String toString, NumbersInfo.TaskExecutorInfo info) {
        Matcher matcher = THREADPOOLTASKEXECUTOR_PATTERN.matcher(toString);
        if (matcher.matches() && matcher.groupCount() == 4) {
            try {
                info.setSize(Integer.valueOf(matcher.group(1)).intValue());
            }
            catch (NumberFormatException e) {
                LOG.error("While parsing thread pool size", (Throwable)e);
            }
            try {
                info.setActive(Integer.valueOf(matcher.group(2)).intValue());
            }
            catch (NumberFormatException e) {
                LOG.error("While parsing active threads #", (Throwable)e);
            }
            try {
                info.setQueued(Integer.valueOf(matcher.group(3)).intValue());
            }
            catch (NumberFormatException e) {
                LOG.error("While parsing queued threads #", (Throwable)e);
            }
            try {
                info.setCompleted(Integer.valueOf(matcher.group(4)).intValue());
            }
            catch (NumberFormatException e) {
                LOG.error("While parsing completed threads #", (Throwable)e);
            }
        }
    }

    protected static void initSystemInfo() {
        if (SYSTEM_INFO == null) {
            OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            SYSTEM_INFO = new SystemInfo();
            try {
                SYSTEM_INFO.setHostname(InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e) {
                LOG.error("Could not get host name", (Throwable)e);
            }
            SYSTEM_INFO.setOs(operatingSystemMXBean.getName() + " " + operatingSystemMXBean.getVersion() + " " + operatingSystemMXBean.getArch());
            SYSTEM_INFO.setAvailableProcessors(operatingSystemMXBean.getAvailableProcessors());
            SYSTEM_INFO.setJvm(runtimeMXBean.getVmName() + " " + System.getProperty("java.version") + " " + runtimeMXBean.getVmVendor());
            SYSTEM_INFO.setStartTime(runtimeMXBean.getStartTime());
        }
    }

    public DefaultSyncopeCoreInfoContributor(SecurityProperties securityProperties, PersistenceProperties persistenceProperties, ProvisioningProperties provisioningProperties, LogicProperties logicProperties, AnyTypeDAO anyTypeDAO, AnyTypeClassDAO anyTypeClassDAO, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, ExternalResourceDAO resourceDAO, ConfParamOps confParamOps, ServiceOps serviceOps, ConnIdBundleManager bundleManager, PropagationTaskExecutor propagationTaskExecutor, AnyObjectWorkflowAdapter awfAdapter, UserWorkflowAdapter uwfAdapter, GroupWorkflowAdapter gwfAdapter, AnyObjectProvisioningManager aProvisioningManager, UserProvisioningManager uProvisioningManager, GroupProvisioningManager gProvisioningManager, VirAttrCache virAttrCache, NotificationManager notificationManager, AuditManager auditManager, PasswordGenerator passwordGenerator, EntityFactory entityFactory, PlainSchemaDAO plainSchemaDAO, PlainAttrDAO plainAttrDAO, PlainAttrValueDAO plainAttrValueDAO, AnySearchDAO anySearchDAO, ImplementationLookup implLookup, PolicyDAO policyDAO, NotificationDAO notificationDAO, TaskDAO taskDAO, VirSchemaDAO virSchemaDAO, RoleDAO roleDAO, SecurityQuestionDAO securityQuestionDAO, ThreadPoolTaskExecutor asyncConnectorFacadeExecutor, ThreadPoolTaskExecutor propagationTaskExecutorAsyncExecutor) {
        this.securityProperties = securityProperties;
        this.persistenceProperties = persistenceProperties;
        this.provisioningProperties = provisioningProperties;
        this.logicProperties = logicProperties;
        this.anyTypeDAO = anyTypeDAO;
        this.anyTypeClassDAO = anyTypeClassDAO;
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.resourceDAO = resourceDAO;
        this.confParamOps = confParamOps;
        this.serviceOps = serviceOps;
        this.bundleManager = bundleManager;
        this.propagationTaskExecutor = propagationTaskExecutor;
        this.awfAdapter = awfAdapter;
        this.uwfAdapter = uwfAdapter;
        this.gwfAdapter = gwfAdapter;
        this.aProvisioningManager = aProvisioningManager;
        this.uProvisioningManager = uProvisioningManager;
        this.gProvisioningManager = gProvisioningManager;
        this.virAttrCache = virAttrCache;
        this.notificationManager = notificationManager;
        this.auditManager = auditManager;
        this.passwordGenerator = passwordGenerator;
        this.entityFactory = entityFactory;
        this.plainSchemaDAO = plainSchemaDAO;
        this.plainAttrDAO = plainAttrDAO;
        this.plainAttrValueDAO = plainAttrValueDAO;
        this.anySearchDAO = anySearchDAO;
        this.implLookup = implLookup;
        this.policyDAO = policyDAO;
        this.notificationDAO = notificationDAO;
        this.taskDAO = taskDAO;
        this.virSchemaDAO = virSchemaDAO;
        this.roleDAO = roleDAO;
        this.securityQuestionDAO = securityQuestionDAO;
        this.asyncConnectorFacadeExecutor = asyncConnectorFacadeExecutor;
        this.propagationTaskExecutorAsyncExecutor = propagationTaskExecutorAsyncExecutor;
    }

    protected boolean isSelfRegAllowed() {
        return (Boolean)this.confParamOps.get(AuthContextUtils.getDomain(), "selfRegistration.allowed", (Object)false, Boolean.class);
    }

    protected boolean isPwdResetAllowed() {
        return (Boolean)this.confParamOps.get(AuthContextUtils.getDomain(), "passwordReset.allowed", (Object)false, Boolean.class);
    }

    protected boolean isPwdResetRequiringSecurityQuestions() {
        return (Boolean)this.confParamOps.get(AuthContextUtils.getDomain(), "passwordReset.securityQuestion", (Object)true, Boolean.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildPlatform() {
        DefaultSyncopeCoreInfoContributor defaultSyncopeCoreInfoContributor = this;
        synchronized (defaultSyncopeCoreInfoContributor) {
            if (PLATFORM_INFO == null) {
                PLATFORM_INFO = new PlatformInfo();
                PLATFORM_INFO.setKeymasterConfParamOps(AopUtils.getTargetClass((Object)this.confParamOps).getName());
                PLATFORM_INFO.setKeymasterServiceOps(AopUtils.getTargetClass((Object)this.serviceOps).getName());
                PLATFORM_INFO.getConnIdLocations().addAll(this.bundleManager.getLocations().stream().map(URI::toASCIIString).collect(Collectors.toList()));
                PLATFORM_INFO.getWorkflowInfo().setAnyObjectWorkflowAdapter(AopUtils.getTargetClass((Object)this.awfAdapter).getName());
                PLATFORM_INFO.getWorkflowInfo().setUserWorkflowAdapter(AopUtils.getTargetClass((Object)this.uwfAdapter).getName());
                PLATFORM_INFO.getWorkflowInfo().setGroupWorkflowAdapter(AopUtils.getTargetClass((Object)this.gwfAdapter).getName());
                PLATFORM_INFO.getProvisioningInfo().setAnyObjectProvisioningManager(AopUtils.getTargetClass((Object)this.aProvisioningManager).getName());
                PLATFORM_INFO.getProvisioningInfo().setUserProvisioningManager(AopUtils.getTargetClass((Object)this.uProvisioningManager).getName());
                PLATFORM_INFO.getProvisioningInfo().setGroupProvisioningManager(AopUtils.getTargetClass((Object)this.gProvisioningManager).getName());
                PLATFORM_INFO.getProvisioningInfo().setPropagationTaskExecutor(AopUtils.getTargetClass((Object)this.propagationTaskExecutor).getName());
                PLATFORM_INFO.getProvisioningInfo().setVirAttrCache(AopUtils.getTargetClass((Object)this.virAttrCache).getName());
                PLATFORM_INFO.getProvisioningInfo().setNotificationManager(AopUtils.getTargetClass((Object)this.notificationManager).getName());
                PLATFORM_INFO.getProvisioningInfo().setAuditManager(AopUtils.getTargetClass((Object)this.auditManager).getName());
                PLATFORM_INFO.setPasswordGenerator(AopUtils.getTargetClass((Object)this.passwordGenerator).getName());
                PLATFORM_INFO.getPersistenceInfo().setEntityFactory(AopUtils.getTargetClass((Object)this.entityFactory).getName());
                PLATFORM_INFO.getPersistenceInfo().setPlainSchemaDAO(AopUtils.getTargetClass((Object)this.plainSchemaDAO).getName());
                PLATFORM_INFO.getPersistenceInfo().setPlainAttrDAO(AopUtils.getTargetClass((Object)this.plainAttrDAO).getName());
                PLATFORM_INFO.getPersistenceInfo().setPlainAttrValueDAO(AopUtils.getTargetClass((Object)this.plainAttrValueDAO).getName());
                PLATFORM_INFO.getPersistenceInfo().setAnySearchDAO(AopUtils.getTargetClass((Object)this.anySearchDAO).getName());
                PLATFORM_INFO.getPersistenceInfo().setUserDAO(AopUtils.getTargetClass((Object)this.userDAO).getName());
                PLATFORM_INFO.getPersistenceInfo().setGroupDAO(AopUtils.getTargetClass((Object)this.groupDAO).getName());
                PLATFORM_INFO.getPersistenceInfo().setAnyObjectDAO(AopUtils.getTargetClass((Object)this.anyObjectDAO).getName());
                ImplementationTypesHolder.getInstance().getValues().forEach((typeName, typeInterface) -> {
                    Set classNames = this.implLookup.getClassNames(typeName);
                    if (classNames != null) {
                        JavaImplInfo javaImplInfo = new JavaImplInfo();
                        javaImplInfo.setType(typeName);
                        javaImplInfo.getClasses().addAll(classNames);
                        PLATFORM_INFO.getJavaImplInfos().add(javaImplInfo);
                    }
                });
            }
            PLATFORM_INFO.setSelfRegAllowed(this.isSelfRegAllowed());
            PLATFORM_INFO.setPwdResetAllowed(this.isPwdResetAllowed());
            PLATFORM_INFO.setPwdResetRequiringSecurityQuestions(this.isPwdResetRequiringSecurityQuestions());
            PLATFORM_INFO.getEntitlements().clear();
            PLATFORM_INFO.getEntitlements().addAll(EntitlementsHolder.getInstance().getValues());
            PLATFORM_INFO.getImplementationTypes().clear();
            PLATFORM_INFO.getImplementationTypes().addAll(ImplementationTypesHolder.getInstance().getValues().keySet());
            AuthContextUtils.callAsAdmin((String)AuthContextUtils.getDomain(), () -> {
                PLATFORM_INFO.getAnyTypes().clear();
                PLATFORM_INFO.getAnyTypes().addAll(this.anyTypeDAO.findAll().stream().map(Entity::getKey).collect(Collectors.toList()));
                PLATFORM_INFO.getUserClasses().clear();
                PLATFORM_INFO.getUserClasses().addAll(this.anyTypeDAO.findUser().getClasses().stream().map(Entity::getKey).collect(Collectors.toList()));
                PLATFORM_INFO.getAnyTypeClasses().clear();
                PLATFORM_INFO.getAnyTypeClasses().addAll(this.anyTypeClassDAO.findAll().stream().map(Entity::getKey).collect(Collectors.toList()));
                PLATFORM_INFO.getResources().clear();
                PLATFORM_INFO.getResources().addAll(this.resourceDAO.findAll().stream().map(Entity::getKey).collect(Collectors.toList()));
                return null;
            });
        }
    }

    protected NumbersInfo buildNumbers() {
        NumbersInfo numbersInfo = new NumbersInfo();
        numbersInfo.setTotalUsers(this.userDAO.count());
        numbersInfo.getUsersByRealm().putAll(this.userDAO.countByRealm());
        numbersInfo.getUsersByStatus().putAll(this.userDAO.countByStatus());
        numbersInfo.setTotalGroups(this.groupDAO.count());
        numbersInfo.getGroupsByRealm().putAll(this.groupDAO.countByRealm());
        Map anyObjectNumbers = this.anyObjectDAO.countByType();
        Iterator itor = anyObjectNumbers.entrySet().iterator();
        for (int i = 0; i < 2 && itor.hasNext(); ++i) {
            Map.Entry entry = itor.next();
            if (i == 0) {
                numbersInfo.setAnyType1(((AnyType)entry.getKey()).getKey());
                numbersInfo.setTotalAny1((Integer)entry.getValue());
                numbersInfo.getAny1ByRealm().putAll(this.anyObjectDAO.countByRealm((AnyType)entry.getKey()));
                continue;
            }
            numbersInfo.setAnyType2(((AnyType)entry.getKey()).getKey());
            numbersInfo.setTotalAny2((Integer)entry.getValue());
            numbersInfo.getAny2ByRealm().putAll(this.anyObjectDAO.countByRealm((AnyType)entry.getKey()));
        }
        numbersInfo.setTotalResources(this.resourceDAO.count());
        numbersInfo.setTotalRoles(this.roleDAO.count());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.RESOURCE.name(), numbersInfo.getTotalResources() > 0);
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.ACCOUNT_POLICY.name(), !this.policyDAO.find(AccountPolicy.class).isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.PASSWORD_POLICY.name(), !this.policyDAO.find(PasswordPolicy.class).isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.NOTIFICATION.name(), !this.notificationDAO.findAll().isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.PULL_TASK.name(), !this.taskDAO.findAll(TaskType.PULL).isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.VIR_SCHEMA.name(), !this.virSchemaDAO.findAll().isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.ANY_TYPE.name(), !anyObjectNumbers.isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.SECURITY_QUESTION.name(), !this.securityQuestionDAO.findAll().isEmpty());
        numbersInfo.getConfCompleteness().put(NumbersInfo.ConfItem.ROLE.name(), numbersInfo.getTotalRoles() > 0);
        DefaultSyncopeCoreInfoContributor.setTaskExecutorInfo(this.asyncConnectorFacadeExecutor.getThreadPoolExecutor().toString(), numbersInfo.getAsyncConnectorExecutor());
        DefaultSyncopeCoreInfoContributor.setTaskExecutorInfo(this.propagationTaskExecutorAsyncExecutor.getThreadPoolExecutor().toString(), numbersInfo.getPropagationTaskExecutor());
        return numbersInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildSystem() {
        Object object = MONITOR;
        synchronized (object) {
            DefaultSyncopeCoreInfoContributor.initSystemInfo();
        }
    }

    @PreAuthorize(value="isAuthenticated()")
    @Transactional(readOnly=true)
    public void contribute(Info.Builder builder) {
        this.buildPlatform();
        builder.withDetail("platform", (Object)PLATFORM_INFO);
        builder.withDetail("numbers", (Object)this.buildNumbers());
        this.buildSystem();
        builder.withDetail("system", (Object)SYSTEM_INFO);
        builder.withDetail("securityProperties", (Object)this.securityProperties);
        builder.withDetail("persistenceProperties", (Object)this.persistenceProperties);
        builder.withDetail("provisioningProperties", (Object)this.provisioningProperties);
        builder.withDetail("logicProperties", (Object)this.logicProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLoadInstant(PayloadApplicationEvent<SystemInfo.LoadInstant> event) {
        Object object = MONITOR;
        synchronized (object) {
            DefaultSyncopeCoreInfoContributor.initSystemInfo();
            SYSTEM_INFO.getLoad().add((SystemInfo.LoadInstant)event.getPayload());
        }
    }

    static {
        THREADPOOLTASKEXECUTOR_PATTERN = Pattern.compile(".*, pool size = ([0-9]+), active threads = ([0-9]+), queued tasks = ([0-9]+), completed tasks = ([0-9]+).*");
    }
}

