/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.services.idp.metadata.cache.resolver;

import java.io.BufferedWriter;
import java.io.File;
import java.io.InputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.stream.StreamSupport;
import lombok.Generated;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.apereo.cas.configuration.model.support.saml.idp.SamlIdPProperties;
import org.apereo.cas.configuration.model.support.saml.idp.metadata.MDQSamlMetadataProperties;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.InMemoryResourceMetadataResolver;
import org.apereo.cas.support.saml.OpenSamlConfigBean;
import org.apereo.cas.support.saml.SamlException;
import org.apereo.cas.support.saml.SamlUtils;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.cache.resolver.UrlResourceMetadataResolver;
import org.apereo.cas.util.EncodingUtils;
import org.apereo.cas.util.HttpUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class MetadataQueryProtocolMetadataResolver
extends UrlResourceMetadataResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(MetadataQueryProtocolMetadataResolver.class);

    public MetadataQueryProtocolMetadataResolver(SamlIdPProperties samlIdPProperties, OpenSamlConfigBean configBean) {
        super(samlIdPProperties, configBean);
    }

    @Override
    public boolean supports(SamlRegisteredService service) {
        return SamlUtils.isDynamicMetadataQueryConfigured((String)service.getMetadataLocation());
    }

    @Override
    protected boolean shouldHttpResponseStatusBeProcessed(HttpStatus status) {
        return true;
    }

    @Override
    protected AbstractMetadataResolver getMetadataResolverFromResponse(HttpResponse response, File backupFile) throws Exception {
        if (!HttpStatus.valueOf((int)response.getStatusLine().getStatusCode()).is2xxSuccessful()) {
            if (Files.exists(backupFile.toPath(), new LinkOption[0])) {
                return new InMemoryResourceMetadataResolver(backupFile, this.configBean);
            }
            throw new SamlException("Unable to get entity from MDQ server and a backup file does not exist.");
        }
        HttpEntity entity = response.getEntity();
        String result = IOUtils.toString((InputStream)entity.getContent(), (Charset)StandardCharsets.UTF_8);
        Path path = backupFile.toPath();
        LOGGER.trace("Writing metadata to file at [{}]", (Object)path);
        try (BufferedWriter output = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            IOUtils.write((String)result, (Writer)output);
            output.flush();
            StreamSupport.stream(path.getFileSystem().getFileStores().spliterator(), false).filter(store -> store.supportsFileAttributeView(UserDefinedFileAttributeView.class)).forEach(Unchecked.consumer(store -> {
                String etag = response.getFirstHeader("ETag").getValue();
                Files.setAttribute(path, "user:ETag", ByteBuffer.wrap(etag.getBytes(StandardCharsets.UTF_8)), new LinkOption[0]);
            }));
        }
        EntityUtils.consume((HttpEntity)entity);
        return new InMemoryResourceMetadataResolver(backupFile, this.configBean);
    }

    @Override
    protected HttpResponse fetchMetadata(SamlRegisteredService service, String metadataLocation, CriteriaSet criteriaSet, File backupFile) {
        MDQSamlMetadataProperties metadata = this.samlIdPProperties.getMetadata().getMdq();
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("Content-Type", metadata.getSupportedContentType());
        headers.put("Accept", "*/*");
        Path path = backupFile.toPath();
        FunctionUtils.doAndHandle(p -> {
            if (Files.exists(path, new LinkOption[0])) {
                String etag = new String((byte[])Files.getAttribute(path, "user:ETag", new LinkOption[0]), StandardCharsets.UTF_8).trim();
                headers.put("If-None-Match", etag);
            }
        });
        LOGGER.trace("Fetching metadata via MDQ for [{}]", (Object)metadataLocation);
        HttpUtils.HttpExecutionRequest exec = HttpUtils.HttpExecutionRequest.builder().basicAuthPassword(metadata.getBasicAuthnPassword()).basicAuthUsername(metadata.getBasicAuthnUsername()).method(HttpMethod.GET).url(metadataLocation).headers(headers).proxyUrl(service.getMetadataProxyLocation()).build();
        HttpResponse response = HttpUtils.execute((HttpUtils.HttpExecutionRequest)exec);
        if (response == null) {
            LOGGER.error("Unable to fetch metadata from [{}]", (Object)metadataLocation);
            throw new UnauthorizedServiceException("screen.service.error.message");
        }
        return response;
    }

    @Override
    protected String getMetadataLocationForService(SamlRegisteredService service, CriteriaSet criteriaSet) {
        LOGGER.trace("Getting metadata location dynamically for [{}] based on criteria [{}]", (Object)service.getName(), (Object)criteriaSet);
        EntityIdCriterion entityIdCriteria = (EntityIdCriterion)criteriaSet.get(EntityIdCriterion.class);
        String entityId = Optional.ofNullable(entityIdCriteria).map(EntityIdCriterion::getEntityId).orElseGet(() -> ((SamlRegisteredService)service).getServiceId());
        if (StringUtils.isBlank((CharSequence)entityId)) {
            throw new SamlException("Unable to determine entity id to fetch metadata via MDQ for " + service.getName());
        }
        String location = super.getMetadataLocationForService(service, criteriaSet);
        return location.replace("{0}", EncodingUtils.urlEncode((String)entityId));
    }
}

