/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.utils;

import org.apache.syncope.common.lib.to.ConnPoolConfTO;
import org.apache.syncope.core.persistence.api.entity.ConnPoolConf;
import org.identityconnectors.common.pooling.ObjectPoolConfiguration;

public final class ConnPoolConfUtils {
    public static ConnPoolConf getConnPoolConf(ConnPoolConfTO cpcto, ConnPoolConf cpc) {
        ObjectPoolConfiguration opc = new ObjectPoolConfiguration();
        cpc.setMaxIdle(Integer.valueOf(cpcto.getMaxIdle() == null ? opc.getMaxIdle() : cpcto.getMaxIdle().intValue()));
        cpc.setMaxObjects(Integer.valueOf(cpcto.getMaxObjects() == null ? opc.getMaxObjects() : cpcto.getMaxObjects().intValue()));
        cpc.setMaxWait(Long.valueOf(cpcto.getMaxWait() == null ? opc.getMaxWait() : cpcto.getMaxWait().longValue()));
        cpc.setMinEvictableIdleTimeMillis(Long.valueOf(cpcto.getMinEvictableIdleTimeMillis() == null ? opc.getMinEvictableIdleTimeMillis() : cpcto.getMinEvictableIdleTimeMillis().longValue()));
        cpc.setMinIdle(Integer.valueOf(cpcto.getMinIdle() == null ? opc.getMinIdle() : cpcto.getMinIdle().intValue()));
        return cpc;
    }

    public static ObjectPoolConfiguration getObjectPoolConfiguration(ConnPoolConf cpc) {
        ObjectPoolConfiguration opc = new ObjectPoolConfiguration();
        ConnPoolConfUtils.updateObjectPoolConfiguration(opc, cpc);
        return opc;
    }

    public static void updateObjectPoolConfiguration(ObjectPoolConfiguration opc, ConnPoolConf cpc) {
        if (cpc.getMaxIdle() != null) {
            opc.setMaxIdle(cpc.getMaxIdle().intValue());
        }
        if (cpc.getMaxObjects() != null) {
            opc.setMaxObjects(cpc.getMaxObjects().intValue());
        }
        if (cpc.getMaxWait() != null) {
            opc.setMaxWait(cpc.getMaxWait().longValue());
        }
        if (cpc.getMinEvictableIdleTimeMillis() != null) {
            opc.setMinEvictableIdleTimeMillis(cpc.getMinEvictableIdleTimeMillis().longValue());
        }
        if (cpc.getMinIdle() != null) {
            opc.setMinIdle(cpc.getMinIdle().intValue());
        }
    }

    private ConnPoolConfUtils() {
    }
}

