/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Base64;
import org.identityconnectors.framework.common.objects.SyncToken;

class SyncTokenSerializer
extends JsonSerializer<SyncToken> {
    SyncTokenSerializer() {
    }

    public void serialize(SyncToken source, JsonGenerator jgen, SerializerProvider sp) throws IOException {
        jgen.writeStartObject();
        jgen.writeFieldName("value");
        if (source.getValue() == null) {
            jgen.writeNull();
        } else if (source.getValue() instanceof Boolean) {
            jgen.writeBoolean(((Boolean)source.getValue()).booleanValue());
        } else if (source.getValue() instanceof Double) {
            jgen.writeNumber(((Double)source.getValue()).doubleValue());
        } else if (source.getValue() instanceof Long) {
            jgen.writeNumber(((Long)source.getValue()).longValue());
        } else if (source.getValue() instanceof Integer) {
            jgen.writeNumber(((Integer)source.getValue()).intValue());
        } else if (source.getValue() instanceof byte[]) {
            jgen.writeString(Base64.getEncoder().encodeToString((byte[])source.getValue()));
        } else {
            jgen.writeString(source.getValue().toString());
        }
        jgen.writeEndObject();
    }
}

