/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.api.jexl;

import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.internal.introspection.Uberspect;
import org.apache.commons.jexl3.introspection.JexlMethod;
import org.apache.commons.jexl3.introspection.JexlPropertySet;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.logging.LogFactory;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.MembershipTO;
import org.apache.syncope.common.lib.to.RealmTO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.Membership;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.provisioning.api.jexl.SyncopeJexlFunctions;

class SandboxUberspect
extends Uberspect {
    private static final Set<String> COLLECTION_METHODS = Set.of("contains", "containsAll", "isEmpty", "size", "iterator", "toString");
    private static final Set<String> LIST_METHODS = Set.of("get", "indexOf", "lastIndexOf", "toString");
    private static final Set<String> MAP_METHODS = Set.of("get", "getOrDefault", "containsKey", "containsValue", "toString");

    SandboxUberspect() {
        super(LogFactory.getLog(JexlEngine.class), JexlUberspect.JEXL_STRATEGY);
    }

    public JexlMethod getConstructor(Object ctorHandle, Object ... args) {
        return null;
    }

    public JexlMethod getMethod(Object obj, String method, Object ... args) {
        if (obj instanceof AnyTO || obj instanceof Any || obj instanceof PlainAttr || obj instanceof Attr || obj instanceof MembershipTO || obj instanceof Membership || obj instanceof Realm || obj instanceof RealmTO) {
            return super.getMethod(obj, method, args);
        }
        if (obj instanceof SyncopeJexlFunctions) {
            return super.getMethod(obj, method, args);
        }
        if (obj instanceof Optional) {
            return super.getMethod(obj, method, args);
        }
        if (obj.getClass().isArray()) {
            return super.getMethod(obj, method, args);
        }
        if (obj instanceof String) {
            return super.getMethod(obj, method, args);
        }
        if (obj instanceof Date || obj instanceof Instant || obj instanceof TemporalAccessor) {
            return super.getMethod(obj, method, args);
        }
        if (obj instanceof Map && MAP_METHODS.contains(method)) {
            return super.getMethod(obj, method, args);
        }
        if (obj instanceof List && (LIST_METHODS.contains(method) || COLLECTION_METHODS.contains(method))) {
            return super.getMethod(obj, method, args);
        }
        if (obj instanceof Collection && COLLECTION_METHODS.contains(method)) {
            return super.getMethod(obj, method, args);
        }
        return null;
    }

    public JexlPropertySet getPropertySet(Object obj, Object identifier, Object arg) {
        return null;
    }

    public JexlPropertySet getPropertySet(List<JexlUberspect.PropertyResolver> resolvers, Object obj, Object identifier, Object arg) {
        return null;
    }
}

