/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.wa;

import java.lang.reflect.Method;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.transport.http.auth.DefaultBasicAuthSupplier;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.lib.Attr;
import org.apache.syncope.common.lib.to.EntityTO;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.WAConfigDAO;
import org.apache.syncope.core.provisioning.api.data.WAConfigDataBinder;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class WAConfigLogic
extends AbstractTransactionalLogic<EntityTO> {
    protected final ServiceOps serviceOps;
    protected final WAConfigDataBinder binder;
    protected final WAConfigDAO waConfigDAO;
    protected final SecurityProperties securityProperties;

    public WAConfigLogic(ServiceOps serviceOps, WAConfigDataBinder binder, WAConfigDAO waConfigDAO, SecurityProperties securityProperties) {
        this.serviceOps = serviceOps;
        this.binder = binder;
        this.waConfigDAO = waConfigDAO;
        this.securityProperties = securityProperties;
    }

    @PreAuthorize(value="hasRole('WA_CONFIG_LIST') or hasRole('ANONYMOUS')")
    @Transactional(readOnly=true)
    public List<Attr> list() {
        return this.waConfigDAO.findAll().stream().map(arg_0 -> ((WAConfigDataBinder)this.binder).get(arg_0)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('WA_CONFIG_GET')")
    @Transactional(readOnly=true)
    public Attr get(String schema) {
        return Optional.ofNullable(this.waConfigDAO.find(schema)).map(arg_0 -> ((WAConfigDataBinder)this.binder).get(arg_0)).orElseThrow(() -> new NotFoundException("Configuration entry " + schema + " not found"));
    }

    @PreAuthorize(value="hasRole('WA_CONFIG_SET')")
    public void set(Attr value) {
        this.waConfigDAO.save(this.binder.set(value));
    }

    @PreAuthorize(value="hasRole('WA_CONFIG_DELETE')")
    public void delete(String key) {
        this.waConfigDAO.delete(key);
    }

    @PreAuthorize(value="hasRole('WA_CONFIG_PUSH')")
    public void pushToWA() {
        HttpClient client = HttpClient.newHttpClient();
        try {
            this.serviceOps.list(NetworkService.Type.WA).forEach(wa -> client.sendAsync(HttpRequest.newBuilder(URI.create(StringUtils.appendIfMissing((String)wa.getAddress(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "actuator/refresh")).header("Authorization", DefaultBasicAuthSupplier.getBasicAuthHeader((String)this.securityProperties.getAnonymousUser(), (String)this.securityProperties.getAnonymousKey())).POST(HttpRequest.BodyPublishers.noBody()).build(), HttpResponse.BodyHandlers.discarding()).thenAcceptAsync(response -> LOG.info("Pushed to WA instance {} with HTTP status: {}", (Object)wa.getAddress(), (Object)response.statusCode())));
        }
        catch (KeymasterException e) {
            throw new NotFoundException("Could not find any WA instance", (Exception)((Object)e));
        }
    }

    protected EntityTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        throw new UnresolvedReferenceException();
    }
}

