/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic.wa;

import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.common.lib.wa.U2FDevice;
import org.apache.syncope.core.logic.AbstractAuthProfileLogic;
import org.apache.syncope.core.persistence.api.dao.AuthProfileDAO;
import org.apache.syncope.core.persistence.api.dao.search.OrderByClause;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.am.AuthProfile;
import org.apache.syncope.core.provisioning.api.data.AuthProfileDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;

public class U2FRegistrationLogic
extends AbstractAuthProfileLogic {
    protected final EntityFactory entityFactory;

    public U2FRegistrationLogic(EntityFactory entityFactory, AuthProfileDAO authProfileDAO, AuthProfileDataBinder binder) {
        super(authProfileDAO, binder);
        this.entityFactory = entityFactory;
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void create(String owner, U2FDevice device) {
        AuthProfile profile = this.authProfileDAO.findByOwner(owner).orElseGet(() -> {
            AuthProfile authProfile = (AuthProfile)this.entityFactory.newEntity(AuthProfile.class);
            authProfile.setOwner(owner);
            return authProfile;
        });
        List devices = profile.getU2FRegisteredDevices();
        devices.add(device);
        profile.setU2FRegisteredDevices(devices);
        this.authProfileDAO.save(profile);
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public void delete(Long id, OffsetDateTime expirationDate) {
        List profiles = this.authProfileDAO.findAll(-1, -1);
        profiles.forEach(profile -> {
            List<U2FDevice> devices = profile.getU2FRegisteredDevices();
            if (devices != null) {
                if (id != null) {
                    devices.removeIf(device -> device.getId() == id.longValue());
                } else if (expirationDate != null) {
                    devices.removeIf(device -> device.getIssueDate().compareTo(expirationDate) < 0);
                } else {
                    devices = List.of();
                }
                profile.setU2FRegisteredDevices(devices);
                this.authProfileDAO.save(profile);
            }
        });
    }

    @PreAuthorize(value="hasRole('ANONYMOUS')")
    public Pair<Integer, List<U2FDevice>> search(Integer page, Integer itemsPerPage, Long id, OffsetDateTime expirationDate, List<OrderByClause> orderByClauses) {
        List comparatorList = orderByClauses.stream().map(orderByClause -> {
            Comparator comparator = null;
            if (orderByClause.getField().equals("id")) {
                comparator = (o1, o2) -> new CompareToBuilder().append(o1.getId(), o2.getId()).toComparison();
            }
            if (orderByClause.getField().equals("issueDate")) {
                comparator = (o1, o2) -> new CompareToBuilder().append((Object)o1.getIssueDate(), (Object)o2.getIssueDate()).toComparison();
            }
            if (orderByClause.getField().equals("record")) {
                comparator = (o1, o2) -> new CompareToBuilder().append((Object)o1.getRecord(), (Object)o2.getRecord()).toComparison();
            }
            if (comparator != null) {
                if (orderByClause.getDirection() == OrderByClause.Direction.DESC) {
                    return comparator.reversed();
                }
                return comparator;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List devices = this.authProfileDAO.findAll(-1, -1).stream().map(AuthProfile::getU2FRegisteredDevices).filter(Objects::nonNull).flatMap(Collection::stream).filter(device -> {
            EqualsBuilder builder = new EqualsBuilder();
            if (id != null) {
                builder.append((Object)id, (Object)device.getId());
            }
            if (expirationDate != null) {
                builder.appendSuper(device.getIssueDate().compareTo(expirationDate) >= 0);
            }
            return true;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List result = devices.stream().limit(itemsPerPage.intValue()).skip((long)itemsPerPage.intValue() * (page <= 0 ? 0L : page.longValue() - 1L)).sorted((o1, o2) -> {
            for (Comparator comparator : comparatorList) {
                int compare = comparator.compare(o1, o2);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        }).collect(Collectors.toList());
        return Pair.of((Object)devices.size(), result);
    }
}

