/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.InternalServerErrorException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.cxf.transport.http.auth.DefaultBasicAuthSupplier;
import org.apache.syncope.common.keymaster.client.api.KeymasterException;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ClientAppTO;
import org.apache.syncope.common.lib.types.ClientAppType;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.CASSPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.OIDCRPClientAppDAO;
import org.apache.syncope.core.persistence.api.dao.SAML2SPClientAppDAO;
import org.apache.syncope.core.persistence.api.entity.am.CASSPClientApp;
import org.apache.syncope.core.persistence.api.entity.am.ClientApp;
import org.apache.syncope.core.persistence.api.entity.am.ClientAppUtils;
import org.apache.syncope.core.persistence.api.entity.am.ClientAppUtilsFactory;
import org.apache.syncope.core.persistence.api.entity.am.OIDCRPClientApp;
import org.apache.syncope.core.persistence.api.entity.am.SAML2SPClientApp;
import org.apache.syncope.core.provisioning.api.data.ClientAppDataBinder;
import org.apache.syncope.core.spring.security.SecurityProperties;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class ClientAppLogic
extends AbstractTransactionalLogic<ClientAppTO> {
    protected final ServiceOps serviceOps;
    protected final ClientAppUtilsFactory clientAppUtilsFactory;
    protected final ClientAppDataBinder binder;
    protected final CASSPClientAppDAO casSPClientAppDAO;
    protected final OIDCRPClientAppDAO oidcRPClientAppDAO;
    protected final SAML2SPClientAppDAO saml2SPClientAppDAO;
    protected final SecurityProperties securityProperties;

    public ClientAppLogic(ServiceOps serviceOps, ClientAppUtilsFactory clientAppUtilsFactory, ClientAppDataBinder binder, CASSPClientAppDAO casSPClientAppDAO, OIDCRPClientAppDAO oidcRPClientAppDAO, SAML2SPClientAppDAO saml2SPClientAppDAO, SecurityProperties securityProperties) {
        this.serviceOps = serviceOps;
        this.clientAppUtilsFactory = clientAppUtilsFactory;
        this.binder = binder;
        this.casSPClientAppDAO = casSPClientAppDAO;
        this.oidcRPClientAppDAO = oidcRPClientAppDAO;
        this.saml2SPClientAppDAO = saml2SPClientAppDAO;
        this.securityProperties = securityProperties;
    }

    @PreAuthorize(value="hasRole('CLIENTAPP_LIST')")
    public <T extends ClientAppTO> List<T> list(ClientAppType type) {
        Stream<ClientAppTO> stream;
        switch (type) {
            case OIDCRP: {
                stream = this.oidcRPClientAppDAO.findAll().stream().map(arg_0 -> ((ClientAppDataBinder)this.binder).getClientAppTO(arg_0));
                break;
            }
            case CASSP: {
                stream = this.casSPClientAppDAO.findAll().stream().map(arg_0 -> ((ClientAppDataBinder)this.binder).getClientAppTO(arg_0));
                break;
            }
            default: {
                stream = this.saml2SPClientAppDAO.findAll().stream().map(arg_0 -> ((ClientAppDataBinder)this.binder).getClientAppTO(arg_0));
            }
        }
        return stream.collect(Collectors.toList());
    }

    protected void checkType(ClientAppType type, ClientAppUtils clientAppUtils) {
        if (clientAppUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + type + ", expected " + clientAppUtils.getType());
            throw sce;
        }
    }

    @PreAuthorize(value="hasRole('CLIENTAPP_READ')")
    @Transactional(readOnly=true)
    public <T extends ClientAppTO> T read(ClientAppType type, String key) {
        switch (type) {
            case OIDCRP: {
                OIDCRPClientApp oidcrp = this.oidcRPClientAppDAO.find(key);
                if (oidcrp == null) {
                    throw new NotFoundException("Client app " + key + " not found");
                }
                this.checkType(type, this.clientAppUtilsFactory.getInstance((ClientApp)oidcrp));
                return (T)this.binder.getClientAppTO((ClientApp)oidcrp);
            }
            case CASSP: {
                CASSPClientApp cassp = this.casSPClientAppDAO.find(key);
                if (cassp == null) {
                    throw new NotFoundException("Client app " + key + " not found");
                }
                this.checkType(type, this.clientAppUtilsFactory.getInstance((ClientApp)cassp));
                return (T)this.binder.getClientAppTO((ClientApp)cassp);
            }
        }
        SAML2SPClientApp saml2sp = this.saml2SPClientAppDAO.find(key);
        if (saml2sp == null) {
            throw new NotFoundException("Client app " + key + " not found");
        }
        this.checkType(type, this.clientAppUtilsFactory.getInstance((ClientApp)saml2sp));
        return (T)this.binder.getClientAppTO((ClientApp)saml2sp);
    }

    @PreAuthorize(value="hasRole('CLIENTAPP_CREATE')")
    public ClientAppTO create(ClientAppType type, ClientAppTO clientAppTO) {
        this.checkType(type, this.clientAppUtilsFactory.getInstance(clientAppTO));
        switch (type) {
            case OIDCRP: {
                return this.binder.getClientAppTO((ClientApp)this.oidcRPClientAppDAO.save((OIDCRPClientApp)this.binder.create(clientAppTO)));
            }
            case CASSP: {
                return this.binder.getClientAppTO((ClientApp)this.casSPClientAppDAO.save((CASSPClientApp)this.binder.create(clientAppTO)));
            }
        }
        return this.binder.getClientAppTO((ClientApp)this.saml2SPClientAppDAO.save((SAML2SPClientApp)this.binder.create(clientAppTO)));
    }

    @PreAuthorize(value="hasRole('CLIENTAPP_CREATE')")
    public void update(ClientAppType type, ClientAppTO clientAppTO) {
        this.checkType(type, this.clientAppUtilsFactory.getInstance(clientAppTO));
        switch (type) {
            case OIDCRP: {
                OIDCRPClientApp oidcrp = this.oidcRPClientAppDAO.find(clientAppTO.getKey());
                if (oidcrp == null) {
                    throw new NotFoundException("Client app " + clientAppTO.getKey() + " not found");
                }
                this.binder.update((ClientApp)oidcrp, clientAppTO);
                this.oidcRPClientAppDAO.save(oidcrp);
                break;
            }
            case CASSP: {
                CASSPClientApp cassp = this.casSPClientAppDAO.find(clientAppTO.getKey());
                if (cassp == null) {
                    throw new NotFoundException("Client app " + clientAppTO.getKey() + " not found");
                }
                this.binder.update((ClientApp)cassp, clientAppTO);
                this.casSPClientAppDAO.save(cassp);
                break;
            }
            default: {
                SAML2SPClientApp saml2sp = this.saml2SPClientAppDAO.find(clientAppTO.getKey());
                if (saml2sp == null) {
                    throw new NotFoundException("Client app " + clientAppTO.getKey() + " not found");
                }
                this.binder.update((ClientApp)saml2sp, clientAppTO);
                this.saml2SPClientAppDAO.save(saml2sp);
            }
        }
    }

    @PreAuthorize(value="hasRole('CLIENTAPP_DELETE')")
    public void delete(ClientAppType type, String key) {
        switch (type) {
            case OIDCRP: {
                OIDCRPClientApp oidcrp = this.oidcRPClientAppDAO.find(key);
                if (oidcrp == null) {
                    throw new NotFoundException("Client app " + key + " not found");
                }
                this.oidcRPClientAppDAO.delete(oidcrp);
                break;
            }
            case CASSP: {
                CASSPClientApp cassp = this.casSPClientAppDAO.find(key);
                if (cassp == null) {
                    throw new NotFoundException("Client app " + key + " not found");
                }
                this.casSPClientAppDAO.delete(cassp);
                break;
            }
            default: {
                SAML2SPClientApp saml2sp = this.saml2SPClientAppDAO.find(key);
                if (saml2sp == null) {
                    throw new NotFoundException("Client app " + key + " not found");
                }
                this.saml2SPClientAppDAO.delete(saml2sp);
            }
        }
    }

    protected ClientAppTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        String key = null;
        if (ArrayUtils.isNotEmpty((Object[])args)) {
            for (int i = 0; key == null && i < args.length; ++i) {
                if (args[i] instanceof String) {
                    key = (String)args[i];
                    continue;
                }
                if (!(args[i] instanceof ClientAppTO)) continue;
                key = ((ClientAppTO)args[i]).getKey();
            }
        }
        if (key != null) {
            try {
                SAML2SPClientApp clientApp = this.saml2SPClientAppDAO.find(key);
                if (clientApp == null) {
                    clientApp = this.oidcRPClientAppDAO.find(key);
                }
                return this.binder.getClientAppTO((ClientApp)clientApp);
            }
            catch (Throwable ex) {
                LOG.debug("Unresolved reference", ex);
                throw new UnresolvedReferenceException(ex);
            }
        }
        throw new UnresolvedReferenceException();
    }

    @PreAuthorize(value="hasRole('CLIENTAPP_PUSH')")
    public void pushToWA() {
        try {
            NetworkService wa = this.serviceOps.get(NetworkService.Type.WA);
            String basicAuthHeader = DefaultBasicAuthSupplier.getBasicAuthHeader((String)this.securityProperties.getAnonymousUser(), (String)this.securityProperties.getAnonymousKey());
            URI endpoint = URI.create(StringUtils.appendIfMissing((String)wa.getAddress(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "actuator/registeredServices");
            HttpClient.newBuilder().build().send(HttpRequest.newBuilder(endpoint).header("Authorization", basicAuthHeader).header("Content-Type", "application/json").GET().build(), HttpResponse.BodyHandlers.discarding());
        }
        catch (KeymasterException e) {
            throw new NotFoundException("Could not find any WA instance", (Exception)((Object)e));
        }
        catch (IOException | InterruptedException e) {
            throw new InternalServerErrorException("Errors while communicating with WA instance", (Throwable)e);
        }
    }
}

