/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.QueryOperator;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.variable.service.impl.types.ByteArrayType;
import org.flowable.variable.service.impl.types.JPAEntityListVariableType;
import org.flowable.variable.service.impl.types.JPAEntityVariableType;

public class QueryVariableValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Object value;
    private QueryOperator operator;
    private VariableInstanceEntity variableInstanceEntity;
    private boolean local;
    private String scopeType;

    public QueryVariableValue(String name, Object value, QueryOperator operator, boolean local) {
        this.name = name;
        this.value = value;
        this.operator = operator;
        this.local = local;
    }

    public QueryVariableValue(String name, Object value, QueryOperator operator, boolean local, String scopeType) {
        this(name, value, operator, local);
        this.scopeType = scopeType;
    }

    public void initialize(VariableServiceConfiguration variableServiceConfiguration) {
        if (this.variableInstanceEntity == null) {
            VariableType type = variableServiceConfiguration.getVariableTypes().findVariableType(this.value);
            if (type instanceof ByteArrayType) {
                throw new FlowableIllegalArgumentException("Variables of type ByteArray cannot be used to query");
            }
            if (type instanceof JPAEntityVariableType && this.operator != QueryOperator.EQUALS) {
                throw new FlowableIllegalArgumentException("JPA entity variables can only be used in 'variableValueEquals'");
            }
            if (type instanceof JPAEntityListVariableType) {
                throw new FlowableIllegalArgumentException("Variables containing a list of JPA entities cannot be used to query");
            }
            this.variableInstanceEntity = variableServiceConfiguration.getVariableInstanceEntityManager().create(this.name, type, this.value);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getOperator() {
        if (this.operator != null) {
            return this.operator.toString();
        }
        return QueryOperator.EQUALS.toString();
    }

    public String getTextValue() {
        if (this.variableInstanceEntity != null) {
            return this.variableInstanceEntity.getTextValue();
        }
        return null;
    }

    public Long getLongValue() {
        if (this.variableInstanceEntity != null) {
            return this.variableInstanceEntity.getLongValue();
        }
        return null;
    }

    public Double getDoubleValue() {
        if (this.variableInstanceEntity != null) {
            return this.variableInstanceEntity.getDoubleValue();
        }
        return null;
    }

    public String getTextValue2() {
        if (this.variableInstanceEntity != null) {
            return this.variableInstanceEntity.getTextValue2();
        }
        return null;
    }

    public String getType() {
        if (this.variableInstanceEntity != null) {
            return this.variableInstanceEntity.getType().getTypeName();
        }
        return null;
    }

    public boolean needsTypeCheck() {
        if (this.operator == QueryOperator.NOT_EQUALS || this.operator == QueryOperator.NOT_EQUALS_IGNORE_CASE) {
            return false;
        }
        if (this.variableInstanceEntity != null) {
            return !"null".equals(this.variableInstanceEntity.getType().getTypeName());
        }
        return false;
    }

    public boolean isLocal() {
        return this.local;
    }

    public String getScopeType() {
        return this.scopeType;
    }
}

