/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.query.AbstractQuery;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.QueryOperator;
import org.flowable.variable.service.impl.QueryVariableValue;

public abstract class AbstractVariableQueryImpl<T extends Query<?, ?>, U>
extends AbstractQuery<T, U> {
    private static final long serialVersionUID = 1L;
    protected VariableServiceConfiguration variableServiceConfiguration;
    protected List<QueryVariableValue> queryVariableValues = new ArrayList<QueryVariableValue>();

    public AbstractVariableQueryImpl() {
    }

    public AbstractVariableQueryImpl(CommandContext commandContext, VariableServiceConfiguration variableServiceConfiguration) {
        super(commandContext);
        this.variableServiceConfiguration = variableServiceConfiguration;
    }

    public AbstractVariableQueryImpl(CommandExecutor commandExecutor, VariableServiceConfiguration variableServiceConfiguration) {
        super(commandExecutor);
        this.variableServiceConfiguration = variableServiceConfiguration;
    }

    public abstract long executeCount(CommandContext var1);

    public abstract List<U> executeList(CommandContext var1);

    public T variableValueEquals(String name, Object value) {
        return this.variableValueEquals(name, value, true);
    }

    protected T variableValueEquals(String name, Object value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.EQUALS, localScope);
        return (T)((Object)this);
    }

    protected T variableValueEquals(String name, Object value, String scopeType) {
        this.addVariable(name, value, QueryOperator.EQUALS, scopeType, false);
        return (T)((Object)this);
    }

    public T variableValueEquals(Object value) {
        return this.variableValueEquals(value, true);
    }

    protected T variableValueEquals(Object value, boolean localScope) {
        this.queryVariableValues.add(new QueryVariableValue(null, value, QueryOperator.EQUALS, localScope));
        return (T)((Object)this);
    }

    protected T variableValueEquals(Object value, String scopeType) {
        this.queryVariableValues.add(new QueryVariableValue(null, value, QueryOperator.EQUALS, false, scopeType));
        return (T)((Object)this);
    }

    public T variableValueEqualsIgnoreCase(String name, String value) {
        return this.variableValueEqualsIgnoreCase(name, value, true);
    }

    protected T variableValueEqualsIgnoreCase(String name, String value, boolean localScope) {
        if (value == null) {
            throw new FlowableIllegalArgumentException("value is null");
        }
        this.addVariable(name, value.toLowerCase(), QueryOperator.EQUALS_IGNORE_CASE, localScope);
        return (T)((Object)this);
    }

    protected T variableValueEqualsIgnoreCase(String name, String value, String scopeType) {
        if (value == null) {
            throw new FlowableIllegalArgumentException("value is null");
        }
        this.addVariable(name, value.toLowerCase(), QueryOperator.EQUALS_IGNORE_CASE, scopeType, false);
        return (T)((Object)this);
    }

    public T variableValueNotEqualsIgnoreCase(String name, String value) {
        return this.variableValueNotEqualsIgnoreCase(name, value, true);
    }

    protected T variableValueNotEqualsIgnoreCase(String name, String value, boolean localScope) {
        if (value == null) {
            throw new FlowableIllegalArgumentException("value is null");
        }
        this.addVariable(name, value.toLowerCase(), QueryOperator.NOT_EQUALS_IGNORE_CASE, localScope);
        return (T)((Object)this);
    }

    protected T variableValueNotEqualsIgnoreCase(String name, String value, String scopeType) {
        if (value == null) {
            throw new FlowableIllegalArgumentException("value is null");
        }
        this.addVariable(name, value.toLowerCase(), QueryOperator.NOT_EQUALS_IGNORE_CASE, scopeType, false);
        return (T)((Object)this);
    }

    public T variableValueNotEquals(String name, Object value) {
        return this.variableValueNotEquals(name, value, true);
    }

    protected T variableValueNotEquals(String name, Object value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.NOT_EQUALS, localScope);
        return (T)((Object)this);
    }

    protected T variableValueNotEquals(String name, Object value, String scopeType) {
        this.addVariable(name, value, QueryOperator.NOT_EQUALS, scopeType, false);
        return (T)((Object)this);
    }

    public T variableValueGreaterThan(String name, Object value) {
        return this.variableValueGreaterThan(name, value, true);
    }

    protected T variableValueGreaterThan(String name, Object value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.GREATER_THAN, localScope);
        return (T)((Object)this);
    }

    protected T variableValueGreaterThan(String name, Object value, String scopeType) {
        this.addVariable(name, value, QueryOperator.GREATER_THAN, scopeType, false);
        return (T)((Object)this);
    }

    public T variableValueGreaterThanOrEqual(String name, Object value) {
        return this.variableValueGreaterThanOrEqual(name, value, true);
    }

    protected T variableValueGreaterThanOrEqual(String name, Object value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.GREATER_THAN_OR_EQUAL, localScope);
        return (T)((Object)this);
    }

    protected T variableValueGreaterThanOrEqual(String name, Object value, String scopeType) {
        this.addVariable(name, value, QueryOperator.GREATER_THAN_OR_EQUAL, scopeType, false);
        return (T)((Object)this);
    }

    public T variableValueLessThan(String name, Object value) {
        return this.variableValueLessThan(name, value, true);
    }

    protected T variableValueLessThan(String name, Object value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.LESS_THAN, localScope);
        return (T)((Object)this);
    }

    protected T variableValueLessThan(String name, Object value, String scopeType) {
        this.addVariable(name, value, QueryOperator.LESS_THAN, scopeType, false);
        return (T)((Object)this);
    }

    public T variableValueLessThanOrEqual(String name, Object value) {
        return this.variableValueLessThanOrEqual(name, value, true);
    }

    protected T variableValueLessThanOrEqual(String name, Object value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.LESS_THAN_OR_EQUAL, localScope);
        return (T)((Object)this);
    }

    protected T variableValueLessThanOrEqual(String name, Object value, String scopeType) {
        this.addVariable(name, value, QueryOperator.LESS_THAN_OR_EQUAL, scopeType, false);
        return (T)((Object)this);
    }

    public T variableValueLike(String name, String value) {
        return this.variableValueLike(name, value, true);
    }

    public T variableValueLikeIgnoreCase(String name, String value) {
        return this.variableValueLikeIgnoreCase(name, value, true);
    }

    protected T variableValueLike(String name, String value, boolean localScope) {
        this.addVariable(name, value, QueryOperator.LIKE, localScope);
        return (T)((Object)this);
    }

    protected T variableValueLike(String name, String value, String scopeType) {
        this.addVariable(name, value, QueryOperator.LIKE, scopeType, false);
        return (T)((Object)this);
    }

    protected T variableValueLikeIgnoreCase(String name, String value, boolean localScope) {
        if (value == null) {
            throw new FlowableIllegalArgumentException("value is null");
        }
        this.addVariable(name, value.toLowerCase(), QueryOperator.LIKE_IGNORE_CASE, localScope);
        return (T)((Object)this);
    }

    protected T variableValueLikeIgnoreCase(String name, String value, String scopeType) {
        if (value == null) {
            throw new FlowableIllegalArgumentException("value is null");
        }
        this.addVariable(name, value.toLowerCase(), QueryOperator.LIKE_IGNORE_CASE, scopeType, false);
        return (T)((Object)this);
    }

    public T variableExists(String name) {
        return this.variableExists(name, true);
    }

    protected T variableExists(String name, boolean localScope) {
        this.addVariable(name, null, QueryOperator.EXISTS, localScope);
        return (T)((Object)this);
    }

    protected T variableExists(String name, String scopeType) {
        this.addVariable(name, null, QueryOperator.EXISTS, scopeType, false);
        return (T)((Object)this);
    }

    public T variableNotExists(String name) {
        return this.variableNotExists(name, true);
    }

    protected T variableNotExists(String name, boolean localScope) {
        this.addVariable(name, null, QueryOperator.NOT_EXISTS, localScope);
        return (T)((Object)this);
    }

    protected T variableNotExists(String name, String scopeType) {
        this.addVariable(name, null, QueryOperator.NOT_EXISTS, scopeType, false);
        return (T)((Object)this);
    }

    protected void addVariable(String name, Object value, QueryOperator operator, boolean localScope) {
        this.addVariable(name, value, operator, null, localScope);
    }

    protected void addVariable(String name, Object value, QueryOperator operator, String scopeType, boolean localScope) {
        if (name == null) {
            throw new FlowableIllegalArgumentException("name is null");
        }
        if (value == null || this.isBoolean(value)) {
            switch (operator) {
                case GREATER_THAN: {
                    throw new FlowableIllegalArgumentException("Booleans and null cannot be used in 'greater than' condition");
                }
                case LESS_THAN: {
                    throw new FlowableIllegalArgumentException("Booleans and null cannot be used in 'less than' condition");
                }
                case GREATER_THAN_OR_EQUAL: {
                    throw new FlowableIllegalArgumentException("Booleans and null cannot be used in 'greater than or equal' condition");
                }
                case LESS_THAN_OR_EQUAL: {
                    throw new FlowableIllegalArgumentException("Booleans and null cannot be used in 'less than or equal' condition");
                }
            }
            if (operator == QueryOperator.EQUALS_IGNORE_CASE && !(value instanceof String)) {
                throw new FlowableIllegalArgumentException("Only string values can be used with 'equals ignore case' condition");
            }
            if (operator == QueryOperator.NOT_EQUALS_IGNORE_CASE && !(value instanceof String)) {
                throw new FlowableIllegalArgumentException("Only string values can be used with 'not equals ignore case' condition");
            }
            if (!(operator != QueryOperator.LIKE && operator != QueryOperator.LIKE_IGNORE_CASE || value instanceof String)) {
                throw new FlowableIllegalArgumentException("Only string values can be used with 'like' condition");
            }
        }
        this.queryVariableValues.add(new QueryVariableValue(name, value, operator, localScope, scopeType));
    }

    protected boolean isBoolean(Object value) {
        if (value == null) {
            return false;
        }
        return Boolean.class.isAssignableFrom(value.getClass()) || Boolean.TYPE.isAssignableFrom(value.getClass());
    }

    protected void ensureVariablesInitialized() {
        if (!this.queryVariableValues.isEmpty()) {
            for (QueryVariableValue queryVariableValue : this.queryVariableValues) {
                queryVariableValue.initialize(this.variableServiceConfiguration);
            }
        }
    }

    public List<QueryVariableValue> getQueryVariableValues() {
        return this.queryVariableValues;
    }

    public boolean hasValueComparisonQueryVariables() {
        for (QueryVariableValue qvv : this.queryVariableValues) {
            if (QueryOperator.EXISTS.toString().equals(qvv.getOperator()) || QueryOperator.NOT_EXISTS.toString().equals(qvv.getOperator())) continue;
            return true;
        }
        return false;
    }

    public boolean hasLocalQueryVariableValue() {
        for (QueryVariableValue qvv : this.queryVariableValues) {
            if (!qvv.isLocal()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNonLocalQueryVariableValue() {
        for (QueryVariableValue qvv : this.queryVariableValues) {
            if (qvv.isLocal()) continue;
            return true;
        }
        return false;
    }
}

